/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.MetadataSubprogramOnly;
import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.scanner.Block;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class FunctionMDOnly
implements ParserListener {
    private final FunctionDefinition function;
    private final Types types;
    private final IRScope scope;

    public FunctionMDOnly(IRScope scope, Types types, FunctionDefinition function) {
        this.scope = scope;
        this.types = types;
        this.function = function;
    }

    public void setupScope() {
        this.scope.startLocalScope(this.function);
    }

    @Override
    public ParserListener enter(Block block) {
        switch (block) {
            case METADATA: 
            case METADATA_ATTACHMENT: 
            case METADATA_KIND: {
                return new MetadataSubprogramOnly(this.types, this.scope);
            }
        }
        return ParserListener.DEFAULT;
    }

    @Override
    public void exit() {
        this.scope.exitLocalScope();
    }

    @Override
    public void record(RecordBuffer buffer) {
    }
}

