/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.profiling;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.NodeCloneable;

public abstract class BooleanValueProfile
extends NodeCloneable {
    BooleanValueProfile() {
    }

    public abstract boolean profile(boolean var1);

    public static BooleanValueProfile create() {
        if (Truffle.getRuntime().isProfilingEnabled()) {
            return new Enabled();
        }
        return new Disabled();
    }

    static final class Enabled
    extends BooleanValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private boolean cachedValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public boolean profile(boolean value) {
            byte localState = this.state;
            if (localState != 2) {
                boolean v;
                if (localState == 1 && (v = this.cachedValue) == value) {
                    return v;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }
    }

    static final class Disabled
    extends BooleanValueProfile {
        Disabled() {
        }

        @Override
        public boolean profile(boolean value) {
            return value;
        }
    }
}

