/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMExtractElementNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMExtractElementNode.class)
public final class LLVMExtractElementNodeFactory {

    @GeneratedBy(value=LLVMExtractElementNode.LLVMDoubleExtractElementNode.class)
    public static final class LLVMDoubleExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMDoubleExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMDoubleExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeDouble_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeDouble_long4(state_0, frameValue, child0Value_);
            }
            return this.executeDouble_generic5(state_0, frameValue, child0Value_);
        }

        private double executeDouble_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private double executeDouble_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private double executeDouble_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private double executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doDouble(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doDouble(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMDoubleExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMDoubleExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMFloatExtractElementNode.class)
    public static final class LLVMFloatExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMFloatExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFloatExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return Float.valueOf(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return Float.valueOf(this.doFloat(child0Value__, child1Value_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return Float.valueOf(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return Float.valueOf(this.doFloat(child0Value__, child1Value_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return Float.valueOf(this.doFloat(child0Value__, child1Value__));
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return Float.valueOf(this.doFloat(child0Value__, child1Value__));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeFloat_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeFloat_long4(state_0, frameValue, child0Value_);
            }
            return this.executeFloat_generic5(state_0, frameValue, child0Value_);
        }

        private float executeFloat_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private float executeFloat_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private float executeFloat_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doFloat(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doFloat(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private float executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value_ = (LLVMFloatVector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doFloat(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doFloat(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMFloatExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMFloatExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI64ExtractElementNode.class)
    public static final class LLVMI64ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI64ExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI64ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x14) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0xA) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int child1Value_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 0xA) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                    return this.doI64(child0Value__, child1Value_);
                }
                if ((state_0 & 8) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                    return this.doPointer(child0Value__, child1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long child1Value_;
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 0x14) != 0) {
                if ((state_0 & 4) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                    return this.doI64(child0Value__, child1Value_);
                }
                if ((state_0 & 0x10) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                    return this.doPointer(child0Value__, child1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 0x1E) != 0) {
                LLVMVector child0Value__;
                if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI64Vector) {
                    child0Value__ = (LLVMI64Vector)child0Value_;
                    if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                        int child1Value__ = (Integer)child1Value_;
                        return this.doI64((LLVMI64Vector)child0Value__, child1Value__);
                    }
                    if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        return this.doI64((LLVMI64Vector)child0Value__, child1Value__);
                    }
                }
                if ((state_0 & 0x18) != 0 && child0Value_ instanceof LLVMPointerVector) {
                    child0Value__ = (LLVMPointerVector)child0Value_;
                    if ((state_0 & 8) != 0 && child1Value_ instanceof Integer) {
                        int child1Value__ = (Integer)child1Value_;
                        return this.doPointer((LLVMPointerVector)child0Value__, child1Value__);
                    }
                    if ((state_0 & 0x10) != 0 && child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        return this.doPointer((LLVMPointerVector)child0Value__, child1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI64_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI64_long4(state_0, frameValue, child0Value_);
            }
            return this.executeI64_generic5(state_0, frameValue, child0Value_);
        }

        private long executeI64_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) throws UnexpectedResultException {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                return this.doI64(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) throws UnexpectedResultException {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                return this.doI64(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI64(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI64(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            LLVMVector child0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI64Vector) {
                child0Value_ = (LLVMI64Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doI64((LLVMI64Vector)child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doI64((LLVMI64Vector)child0Value_, child1Value_);
                }
            }
            if (child0Value instanceof LLVMPointerVector) {
                child0Value_ = (LLVMPointerVector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPointer((LLVMPointerVector)child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 0x10;
                    return this.doPointer((LLVMPointerVector)child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMI64ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI64ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI32ExtractElementNode.class)
    public static final class LLVMI32ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI32ExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI32ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI32(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI32(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI32_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI32_long4(state_0, frameValue, child0Value_);
            }
            return this.executeI32_generic5(state_0, frameValue, child0Value_);
        }

        private int executeI32_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private int executeI32_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private int executeI32_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI32(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI32(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private int executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value_ = (LLVMI32Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doI32(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doI32(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMI32ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI32ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI16ExtractElementNode.class)
    public static final class LLVMI16ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI16ExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI16ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI16(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI16(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI16_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI16_long4(state_0, frameValue, child0Value_);
            }
            return this.executeI16_generic5(state_0, frameValue, child0Value_);
        }

        private short executeI16_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private short executeI16_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private short executeI16_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI16(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI16(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private short executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value_ = (LLVMI16Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doI16(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doI16(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMI16ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI16ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI8ExtractElementNode.class)
    public static final class LLVMI8ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI8ExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI8ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI8(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI8(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI8_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI8_long4(state_0, frameValue, child0Value_);
            }
            return this.executeI8_generic5(state_0, frameValue, child0Value_);
        }

        private byte executeI8_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private byte executeI8_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private byte executeI8_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI8(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI8(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private byte executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value_ = (LLVMI8Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doI8(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doI8(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMI8ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI8ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI1ExtractElementNode.class)
    public static final class LLVMI1ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI1ExtractElementNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI1ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI1(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI1(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI1_int3(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI1_long4(state_0, frameValue, child0Value_);
            }
            return this.executeI1_generic5(state_0, frameValue, child0Value_);
        }

        private boolean executeI1_int3(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private boolean executeI1_long4(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private boolean executeI1_generic5(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doI1(child0Value__, child1Value__);
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doI1(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private boolean executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value_ = (LLVMI1Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doI1(child0Value_, child1Value_);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doI1(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMExtractElementNode.LLVMI1ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI1ExtractElementNodeGen(child0, child1);
        }
    }
}

