/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAccessSymbolNode
extends LLVMExpressionNode {
    protected final LLVMSymbol symbol;

    LLVMAccessSymbolNode(LLVMSymbol symbol) {
        this.symbol = LLVMAlias.resolveAlias(symbol);
    }

    @Override
    public abstract LLVMPointer executeGeneric(VirtualFrame var1);

    @Override
    public String toString() {
        return this.getShortString("symbol");
    }

    public LLVMSymbol getSymbol() {
        return this.symbol;
    }

    @CompilerDirectives.TruffleBoundary
    protected LLVMLinkerException notFound() {
        throw new LLVMLinkerException((Node)this, "External %s %s cannot be found.", this.symbol.getKind(), this.symbol.getName());
    }

    protected LLVMPointer checkNull(LLVMPointer result, BranchProfile exception) {
        if (result == null) {
            exception.enter();
            throw this.notFound();
        }
        return result;
    }
}

