/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNodeFactory;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.util.function.DoublePredicate;

@NodeChildren(value={@NodeChild(value="op"), @NodeChild(value="test")})
public abstract class LLVMIsFPClassNode
extends LLVMExpressionNode {
    public static LLVMBuiltin.TypedBuiltinFactory getIsFPClassFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case FLOAT: {
                return LLVMBuiltin.TypedBuiltinFactory.vector2(LLVMIsFPClassNodeFactory.IsFPClassF32NodeGen::create, LLVMIsFPClassNodeFactory.IsFPClassF32VectorNodeGen::create);
            }
            case DOUBLE: {
                return LLVMBuiltin.TypedBuiltinFactory.vector2(LLVMIsFPClassNodeFactory.IsFPClassF64NodeGen::create, LLVMIsFPClassNodeFactory.IsFPClassF64VectorNodeGen::create);
            }
            case X86_FP80: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(LLVMIsFPClassNodeFactory.IsFPClassF80NodeGen::create);
            }
        }
        return null;
    }

    public static abstract class IsFPClassF64Vector
    extends LLVMIsFPClassNode {
        private final int vectorSize;

        IsFPClassF64Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI1Vector doTest(LLVMDoubleVector v, int test) {
            boolean[] ret = new boolean[v.getLength()];
            for (int i = 0; i < this.vectorSize; ++i) {
                ret[i] = IsFPClassF64.doTest(v.getValue(i), test);
            }
            return LLVMI1Vector.create(ret);
        }
    }

    public static abstract class IsFPClassF32Vector
    extends LLVMIsFPClassNode {
        private final int vectorSize;

        IsFPClassF32Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI1Vector doTest(LLVMFloatVector v, int test) {
            boolean[] ret = new boolean[v.getLength()];
            for (int i = 0; i < this.vectorSize; ++i) {
                ret[i] = IsFPClassF32.doTest(v.getValue(i), test);
            }
            return LLVMI1Vector.create(ret);
        }
    }

    public static abstract class IsFPClassF80
    extends LLVMIsFPClassNode {
        private static boolean checkCondition(LLVM80BitFloat op, int test, int mask, FP80Predicate pred) {
            if ((test & mask) == mask) {
                return pred.test(op);
            }
            return false;
        }

        private static boolean isSubnormal(LLVM80BitFloat f) {
            return f.getExponent() == 0;
        }

        @Specialization
        static boolean doTest(LLVM80BitFloat op, int test) {
            boolean ret = false;
            ret |= IsFPClassF80.checkCondition(op, test, 28, f -> f.getSign());
            ret |= IsFPClassF80.checkCondition(op, test, 896, f -> !f.getSign());
            ret |= IsFPClassF80.checkCondition(op, test, 2, f -> f.isSNaN());
            ret |= IsFPClassF80.checkCondition(op, test, 1, f -> f.isQNaN());
            ret |= IsFPClassF80.checkCondition(op, test, 4, f -> f.isNegativeInfinity());
            ret |= IsFPClassF80.checkCondition(op, test, 8, f -> f.getSign() && !f.isNaN() && !f.isNegativeInfinity() && !IsFPClassF80.isSubnormal(f));
            ret |= IsFPClassF80.checkCondition(op, test, 16, f -> f.getSign() && !f.isNaN() && !f.isNegativeInfinity() && IsFPClassF80.isSubnormal(f));
            ret |= IsFPClassF80.checkCondition(op, test, 32, f -> f.isNegativeZero());
            ret |= IsFPClassF80.checkCondition(op, test, 64, f -> f.isPositiveZero());
            ret |= IsFPClassF80.checkCondition(op, test, 128, f -> !f.getSign() && !f.isNaN() && !f.isPositiveInfinity() && IsFPClassF80.isSubnormal(f));
            ret |= IsFPClassF80.checkCondition(op, test, 256, f -> !f.getSign() && !f.isNaN() && !f.isPositiveInfinity() && !IsFPClassF80.isSubnormal(f));
            return ret |= IsFPClassF80.checkCondition(op, test, 512, f -> f.isPositiveInfinity());
        }
    }

    public static abstract class IsFPClassF64
    extends LLVMIsFPClassNode {
        private static boolean checkCondition(double op, int test, int mask, DoublePredicate pred) {
            if ((test & mask) == mask) {
                return pred.test(op);
            }
            return false;
        }

        private static boolean isSubnormal(double f) {
            return (Double.doubleToLongBits(f) & 0x7FF0000000000000L) == 0L;
        }

        @Specialization
        static boolean doTest(double op, int test) {
            boolean ret = false;
            ret |= IsFPClassF64.checkCondition(op, test, 3, Double::isNaN);
            ret |= IsFPClassF64.checkCondition(op, test, 2, f -> Double.isNaN(f) && (Double.doubleToLongBits(f) & 0x8000000000000L) == 0L);
            ret |= IsFPClassF64.checkCondition(op, test, 1, f -> Double.isNaN(f) && (Double.doubleToLongBits(f) & 0x8000000000000L) != 0L);
            ret |= IsFPClassF64.checkCondition(op, test, 28, f -> f < 0.0);
            ret |= IsFPClassF64.checkCondition(op, test, 896, f -> f > 0.0);
            ret |= IsFPClassF64.checkCondition(op, test, 504, Double::isFinite);
            ret |= IsFPClassF64.checkCondition(op, test, 516, Double::isInfinite);
            ret |= IsFPClassF64.checkCondition(op, test, 96, f -> f == 0.0);
            ret |= IsFPClassF64.checkCondition(op, test, 4, f -> f == Double.NEGATIVE_INFINITY);
            ret |= IsFPClassF64.checkCondition(op, test, 8, f -> f < 0.0 && Double.isFinite(f) && !IsFPClassF64.isSubnormal(f));
            ret |= IsFPClassF64.checkCondition(op, test, 16, f -> f < 0.0 && Double.isFinite(f) && IsFPClassF64.isSubnormal(f));
            ret |= IsFPClassF64.checkCondition(op, test, 32, f -> Double.doubleToLongBits(f) == Integer.MIN_VALUE);
            ret |= IsFPClassF64.checkCondition(op, test, 64, f -> Double.doubleToLongBits(f) == 0L);
            ret |= IsFPClassF64.checkCondition(op, test, 128, f -> f > 0.0 && Double.isFinite(f) && IsFPClassF64.isSubnormal(f));
            ret |= IsFPClassF64.checkCondition(op, test, 256, f -> f > 0.0 && Double.isFinite(f) && !IsFPClassF64.isSubnormal(f));
            return ret |= IsFPClassF64.checkCondition(op, test, 512, f -> f == Double.POSITIVE_INFINITY);
        }
    }

    public static abstract class IsFPClassF32
    extends LLVMIsFPClassNode {
        private static boolean checkCondition(float op, int test, int mask, FloatPredicate pred) {
            if ((test & mask) == mask) {
                return pred.test(op);
            }
            return false;
        }

        private static boolean isSubnormal(float f) {
            return (Float.floatToIntBits(f) & 0x7F800000) == 0;
        }

        @Specialization
        static boolean doTest(float op, int test) {
            boolean ret = false;
            ret |= IsFPClassF32.checkCondition(op, test, 3, Float::isNaN);
            ret |= IsFPClassF32.checkCondition(op, test, 2, f -> Float.isNaN(f) && (Float.floatToIntBits(f) & 0x400000) == 0);
            ret |= IsFPClassF32.checkCondition(op, test, 1, f -> Float.isNaN(f) && (Float.floatToIntBits(f) & 0x400000) != 0);
            ret |= IsFPClassF32.checkCondition(op, test, 28, f -> f < 0.0f);
            ret |= IsFPClassF32.checkCondition(op, test, 896, f -> f > 0.0f);
            ret |= IsFPClassF32.checkCondition(op, test, 504, Float::isFinite);
            ret |= IsFPClassF32.checkCondition(op, test, 516, Float::isInfinite);
            ret |= IsFPClassF32.checkCondition(op, test, 96, f -> f == 0.0f);
            ret |= IsFPClassF32.checkCondition(op, test, 4, f -> f == Float.NEGATIVE_INFINITY);
            ret |= IsFPClassF32.checkCondition(op, test, 8, f -> f < 0.0f && Float.isFinite(f) && !IsFPClassF32.isSubnormal(f));
            ret |= IsFPClassF32.checkCondition(op, test, 16, f -> f < 0.0f && Float.isFinite(f) && IsFPClassF32.isSubnormal(f));
            ret |= IsFPClassF32.checkCondition(op, test, 32, f -> Float.floatToIntBits(f) == Integer.MIN_VALUE);
            ret |= IsFPClassF32.checkCondition(op, test, 64, f -> Float.floatToIntBits(f) == 0);
            ret |= IsFPClassF32.checkCondition(op, test, 128, f -> f > 0.0f && Float.isFinite(f) && IsFPClassF32.isSubnormal(f));
            ret |= IsFPClassF32.checkCondition(op, test, 256, f -> f > 0.0f && Float.isFinite(f) && !IsFPClassF32.isSubnormal(f));
            return ret |= IsFPClassF32.checkCondition(op, test, 512, f -> f == Float.POSITIVE_INFINITY);
        }
    }

    @FunctionalInterface
    static interface FP80Predicate {
        public boolean test(LLVM80BitFloat var1);
    }

    @FunctionalInterface
    static interface FloatPredicate {
        public boolean test(float var1);
    }

    private static final class FPClassBits {
        private static final int SNAN = 1;
        private static final int QNAN = 2;
        private static final int NINF = 4;
        private static final int NNORM = 8;
        private static final int NSUBN = 16;
        private static final int NZERO = 32;
        private static final int PZERO = 64;
        private static final int PSUBN = 128;
        private static final int PNORM = 256;
        private static final int PINF = 512;
        private static final int F32_SNAN_MASK = 0x400000;
        private static final int F32_EXP_MASK = 2139095040;
        private static final long F64_SNAN_MASK = 0x8000000000000L;
        private static final long F64_EXP_MASK = 0x7FF0000000000000L;

        private FPClassBits() {
        }
    }
}

