/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI64LoadNode
extends LLVMLoadNode {
    public static LLVMI64LoadNode create() {
        return LLVMI64LoadNodeGen.create(null);
    }

    public abstract long executeWithTarget(Object var1) throws UnexpectedResultException;

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected long doI64Native(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getI64((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"}, rewriteOn={UnexpectedResultException.class})
    protected long doI64DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return this.doI64Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"}, replaces={"doI64DerefHandle"})
    protected Object doGenericI64DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doGenericI64Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3", rewriteOn={UnexpectedResultException.class})
    @GenerateAOT.Exclude
    protected long doI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return nativeRead.readI64(addr.getObject(), addr.getOffset());
    }

    @Specialization(limit="3", replaces={"doI64Managed"})
    @GenerateAOT.Exclude
    protected Object doGenericI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readGenericI64(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMI64OffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMI64OffsetLoadNode create() {
            return LLVMI64LoadNodeGen.LLVMI64OffsetLoadNodeGen.create();
        }

        public abstract long executeWithTarget(LLVMPointer var1, long var2) throws UnexpectedResultException;

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected long doI64Native(LLVMNativePointer addr, long offset) {
            return this.getLanguage().getLLVMMemory().getI64((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"}, rewriteOn={UnexpectedResultException.class})
        protected long doI64DerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
            return this.doI64Managed(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"}, replaces={"doI64DerefHandle"})
        protected Object doGenericI64DerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doGenericI64Managed(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3", rewriteOn={UnexpectedResultException.class})
        @GenerateAOT.Exclude
        protected long doI64Managed(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
            return nativeRead.readI64(addr.getObject(), addr.getOffset() + offset);
        }

        @Specialization(limit="3", replaces={"doI64Managed"})
        @GenerateAOT.Exclude
        protected Object doGenericI64Managed(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readGenericI64(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

