/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMFloatLoadNode
extends LLVMLoadNode {
    public static LLVMFloatLoadNode create() {
        return LLVMFloatLoadNodeGen.create(null);
    }

    public abstract float executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected float doFloatNative(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getFloat((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static float doFloatDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return LLVMFloatLoadNode.doFloatManaged(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static float doFloatManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readFloat(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMFloatOffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMFloatOffsetLoadNode create() {
            return LLVMFloatLoadNodeGen.LLVMFloatOffsetLoadNodeGen.create();
        }

        public abstract float executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected float doFloatNative(LLVMNativePointer addr, long offset) {
            return this.getLanguage().getLLVMMemory().getFloat((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        @GenerateAOT.Exclude
        protected static float doFloatDerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return LLVMFloatOffsetLoadNode.doFloatManaged(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static float doFloatManaged(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readFloat(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

