/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@GenerateUncached
public abstract class NativeMemSetNode
extends LLVMMemSetNode {
    protected static final long MAX_JAVA_LEN = 256L;

    static long getAccessLength(LLVMManagedPointer pointer, long length, NativeTypeLibrary nativeTypes) {
        LLVMInteropType.StructMember member;
        long elementSize;
        Object object = pointer.getObject();
        Object type = nativeTypes.getNativeType(object);
        if (type instanceof LLVMInteropType.Array && length % (elementSize = ((LLVMInteropType.Array)type).elementSize) == 0L) {
            return elementSize;
        }
        if (type instanceof LLVMInteropType.Struct && (member = NativeMemSetNode.findMember((LLVMInteropType.Struct)type, pointer.getOffset())) != null && member.type instanceof LLVMInteropType.Value && length % member.type.getSize() == 0L) {
            return member.type.getSize();
        }
        return 1L;
    }

    private static LLVMInteropType.StructMember findMember(LLVMInteropType.Struct struct, long offset) {
        for (int i = 0; i < struct.getMemberCount(); ++i) {
            LLVMInteropType.StructMember m = struct.getMember(i);
            if (m.startOffset != offset) continue;
            return m;
        }
        return null;
    }

    @Specialization(guards={"nativeWrite.isWritable(object.getObject())", "getAccessLength(object, length, nativeTypes) == 1"})
    protected void memsetManagedI8(LLVMManagedPointer object, byte value, long length, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        int i = 0;
        while ((long)i < length) {
            nativeWrite.writeI8(object.getObject(), object.getOffset() + (long)i, value);
            ++i;
        }
    }

    @Specialization(guards={"nativeWrite.isWritable(object.getObject())", "getAccessLength(object, length, nativeTypes) == 2"})
    protected void memsetManagedI16(LLVMManagedPointer object, byte value, long length, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        int bValue = value & 0xFF;
        int sValue = bValue << 8 | bValue;
        int i = 0;
        while ((long)i < length) {
            nativeWrite.writeI16(object.getObject(), object.getOffset() + (long)i, (short)sValue);
            i += 2;
        }
    }

    @Specialization(guards={"nativeWrite.isWritable(object.getObject())", "getAccessLength(object, length, nativeTypes) == 4"})
    protected void memsetManagedI32(LLVMManagedPointer object, byte value, long length, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        int bValue = value & 0xFF;
        int sValue = bValue << 8 | bValue;
        int iValue = sValue << 16 | sValue;
        int i = 0;
        while ((long)i < length) {
            nativeWrite.writeI32(object.getObject(), object.getOffset() + (long)i, iValue);
            i += 4;
        }
    }

    @Specialization(guards={"nativeWrite.isWritable(object.getObject())", "getAccessLength(object, length, nativeTypes) == 8"})
    protected void memsetManagedI64(LLVMManagedPointer object, byte value, long length, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        long bValue = (long)value & 0xFFL;
        long sValue = bValue << 8 | bValue;
        long iValue = sValue << 16 | sValue;
        long lValue = iValue << 32 | iValue;
        int i = 0;
        while ((long)i < length) {
            nativeWrite.writeI64(object.getObject(), object.getOffset() + (long)i, lValue);
            i += 8;
        }
    }

    @Specialization(guards={"length <= MAX_JAVA_LEN"})
    protected void nativeInJavaMemset(LLVMNativePointer object, byte value, long length, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode globalAccess) {
        LLVMMemory memory = this.getLanguage().getLLVMMemory();
        long current = globalAccess.executeWithTarget(object).asNative();
        long i64ValuesToWrite = length >> 3;
        if (CompilerDirectives.injectBranchProbability((double)0.75, (i64ValuesToWrite > 0L ? (byte)1 : 0) != 0)) {
            long v16 = ((long)value & 0xFFL) << 8 | (long)value & 0xFFL;
            long v32 = v16 << 16 | v16;
            long v64 = v32 << 32 | v32;
            long i = 0L;
            while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i64ValuesToWrite ? (byte)1 : 0) != 0)) {
                memory.putI64((Node)this, current, v64);
                current += 8L;
                ++i;
            }
        }
        long i8ValuesToWrite = length & 7L;
        long i = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i8ValuesToWrite ? (byte)1 : 0) != 0)) {
            memory.putI8((Node)this, current, value);
            ++current;
            ++i;
        }
    }

    @Specialization(replaces={"nativeInJavaMemset"})
    protected void nativeMemset(LLVMNativePointer object, byte value, long length, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode globalAccess) {
        LLVMMemory memory = this.getLanguage().getLLVMMemory();
        memory.memset(this, globalAccess.executeWithTarget(object), length, value);
    }
}

