/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild, @NodeChild, @NodeChild})
public abstract class LLVMInsertValueNode
extends LLVMExpressionNode {
    protected final long sourceAggregateSize;
    protected final long offset;
    @Node.Child
    private LLVMStoreNode store;
    @Node.Child
    private LLVMMemMoveNode memMove;

    public LLVMInsertValueNode(LLVMStoreNode store, LLVMMemMoveNode memMove, long sourceAggregateSize, long offset) {
        this.sourceAggregateSize = sourceAggregateSize;
        this.offset = offset;
        this.store = store;
        this.memMove = memMove;
    }

    @Specialization
    protected LLVMPointer doLLVMPointer(VirtualFrame frame, LLVMPointer sourceAggr, LLVMPointer targetAggr, Object element) {
        this.memMove.executeWithTarget(frame, targetAggr, sourceAggr, this.sourceAggregateSize);
        this.store.executeWithTarget(frame, targetAggr.increment(this.offset), element);
        return targetAggr;
    }
}

