/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMMemoryIntrinsic.class)
public final class LLVMMemoryIntrinsicFactory {

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMFreeOpNode.class)
    public static final class LLVMFreeOpNodeGen
    extends LLVMMemoryIntrinsic.LLVMFreeOpNode
    implements GenerateAOT.Provider {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFreeOpNodeGen() {
        }

        @Override
        public void execute(LLVMPointer arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value);
                return;
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 2) != 0 && arg0Value_.isNull()) {
                    this.doNull(arg0Value_);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.doVoid(arg0Value_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (arg0Value_.isNull()) {
                    this.state_0_ = state_0 |= 2;
                    this.doNull(arg0Value_);
                    return;
                }
                this.state_0_ = state_0 |= 4;
                this.doVoid(arg0Value_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value});
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMFreeOpNode create() {
            return new LLVMFreeOpNodeGen();
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMFreeOpNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMFreeOpNode.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMMemoryIntrinsic.LLVMFreeOpNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execute(LLVMPointer arg0Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg0Value_.isNull()) {
                        this.doNull(arg0Value_);
                        return;
                    }
                    this.doVoid(arg0Value_);
                    return;
                }
                throw LLVMFreeOpNodeGen.newUnsupportedSpecializationException1(this, arg0Value);
            }
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMFree.class)
    public static final class LLVMFreeNodeGen
    extends LLVMMemoryIntrinsic.LLVMFree
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFreeNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if ((state_0 & 2) != 0 && child0Value__.isNull()) {
                    return this.doNull(child0Value__);
                }
                if ((state_0 & 4) != 0) {
                    return this.doVoid(child0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public void execute(LLVMPointer child0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(child0Value);
                return;
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                if ((state_0 & 2) != 0 && child0Value_.isNull()) {
                    this.doNull(child0Value_);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.doVoid(child0Value_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(child0Value);
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                if (child0Value_.isNull()) {
                    this.state_0_ = state_0 |= 2;
                    return this.doNull(child0Value_);
                }
                this.state_0_ = state_0 |= 4;
                return this.doVoid(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMFree create(LLVMExpressionNode child0) {
            return new LLVMFreeNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMPosixMemalign.class)
    public static final class LLVMPosixMemalignNodeGen
    extends LLVMMemoryIntrinsic.LLVMPosixMemalign
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode memptr_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMPosixMemalignNodeGen(LLVMExpressionNode alignment, LLVMExpressionNode size, LLVMExpressionNode memptr) {
            super(alignment, size);
            this.memptr_ = memptr;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object memptrValue_ = this.memptr_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, memptrValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(memptrValue_)) {
                LLVMPointer memptrValue__ = LLVMTypes.asPointer(memptrValue_);
                return this.doVoid(frameValue, memptrValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, memptrValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object memptrValue_ = this.memptr_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, memptrValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(memptrValue_)) {
                LLVMPointer memptrValue__ = LLVMTypes.asPointer(memptrValue_);
                return this.doVoid(frameValue, memptrValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, memptrValue_);
        }

        private int executeAndSpecialize(VirtualFrame frameValue, Object memptrValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(memptrValue)) {
                LLVMPointer memptrValue_ = LLVMTypes.asPointer(memptrValue);
                this.state_0_ = state_0 |= 2;
                return this.doVoid(frameValue, memptrValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.memptr_}, new Object[]{memptrValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMPosixMemalign create(LLVMExpressionNode alignment, LLVMExpressionNode size, LLVMExpressionNode memptr) {
            return new LLVMPosixMemalignNodeGen(alignment, size, memptr);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMAlignedAlloc.class)
    public static final class LLVMAlignedAllocNodeGen
    extends LLVMMemoryIntrinsic.LLVMAlignedAlloc
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode alignment_;
        @Node.Child
        private LLVMExpressionNode size_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile outOfMemory_;

        private LLVMAlignedAllocNodeGen(LLVMExpressionNode alignment, LLVMExpressionNode size) {
            this.alignment_ = alignment;
            this.size_ = size;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            BranchProfile outOfMemory__;
            long sizeValue_;
            long alignmentValue_;
            int state_0 = this.state_0_;
            try {
                alignmentValue_ = this.alignment_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object sizeValue = this.size_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), sizeValue);
            }
            try {
                sizeValue_ = this.size_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(alignmentValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(alignmentValue_, sizeValue_);
            }
            if ((state_0 & 2) != 0 && (outOfMemory__ = this.outOfMemory_) != null) {
                return this.doAlloc(alignmentValue_, sizeValue_, outOfMemory__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(alignmentValue_, sizeValue_);
        }

        @Override
        LLVMPointer execute(VirtualFrame frameValue) {
            BranchProfile outOfMemory__;
            long sizeValue_;
            long alignmentValue_;
            int state_0 = this.state_0_;
            try {
                alignmentValue_ = this.alignment_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object sizeValue = this.size_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), sizeValue);
            }
            try {
                sizeValue_ = this.size_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(alignmentValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(alignmentValue_, sizeValue_);
            }
            if ((state_0 & 2) != 0 && (outOfMemory__ = this.outOfMemory_) != null) {
                return this.doAlloc(alignmentValue_, sizeValue_, outOfMemory__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(alignmentValue_, sizeValue_);
        }

        private LLVMPointer executeAndSpecialize(Object alignmentValue, Object sizeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (alignmentValue instanceof Long) {
                long alignmentValue_ = (Long)alignmentValue;
                if (sizeValue instanceof Long) {
                    long sizeValue_ = (Long)sizeValue;
                    BranchProfile outOfMemory__ = BranchProfile.create();
                    Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.outOfMemory_ = outOfMemory__;
                    this.state_0_ = state_0 |= 2;
                    return this.doAlloc(alignmentValue_, sizeValue_, outOfMemory__);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.alignment_, this.size_}, new Object[]{alignmentValue, sizeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            BranchProfile outOfMemory__ = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.outOfMemory_ = outOfMemory__;
            this.outOfMemory_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.outOfMemory_.reset();
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMAlignedAlloc create(LLVMExpressionNode alignment, LLVMExpressionNode size) {
            return new LLVMAlignedAllocNodeGen(alignment, size);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMRealloc.class)
    public static final class LLVMReallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMRealloc
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void0_outOfMemory_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void1_outOfMemory_;

        private LLVMReallocNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMNativePointer executeWithTarget(LLVMNativePointer child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value, child1Value);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    BranchProfile outOfMemory__ = this.void0_outOfMemory_;
                    if (outOfMemory__ != null) {
                        return this.doVoid(child0Value, child1Value_, outOfMemory__);
                    }
                }
                if ((state_0 & 4) != 0 && child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
                    if (outOfMemory__1 != null) {
                        return this.doVoid(child0Value, child1Value_, outOfMemory__1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, child1Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, child0Value_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, child0Value_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, child0Value_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                BranchProfile outOfMemory__ = this.void0_outOfMemory_;
                if (outOfMemory__ != null) {
                    return this.doVoid(child0Value__, child1Value_, outOfMemory__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            long child1Value_;
            int state_0 = state_0__;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
                if (outOfMemory__1 != null) {
                    return this.doVoid(child0Value__, child1Value_, outOfMemory__1);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object child0Value_) {
            int state_0 = state_0__;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if ((state_0 & 2) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    BranchProfile outOfMemory__ = this.void0_outOfMemory_;
                    if (outOfMemory__ != null) {
                        return this.doVoid(child0Value__, child1Value__, outOfMemory__);
                    }
                }
                if ((state_0 & 4) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
                    if (outOfMemory__1 != null) {
                        return this.doVoid(child0Value__, child1Value__, outOfMemory__1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    BranchProfile outOfMemory__ = BranchProfile.create();
                    Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.void0_outOfMemory_ = outOfMemory__;
                    this.state_0_ = state_0 |= 2;
                    return this.doVoid(child0Value_, child1Value_, outOfMemory__);
                }
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    BranchProfile outOfMemory__1 = BranchProfile.create();
                    Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.void1_outOfMemory_ = outOfMemory__1;
                    this.state_0_ = state_0 |= 4;
                    return this.doVoid(child0Value_, child1Value_, outOfMemory__1);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            BranchProfile outOfMemory__ = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void0_outOfMemory_ = outOfMemory__;
            this.void0_outOfMemory_.disable();
            this.state_0_ |= 2;
            BranchProfile outOfMemory__1 = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void1_outOfMemory_ = outOfMemory__1;
            this.void1_outOfMemory_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.void0_outOfMemory_.reset();
            this.void1_outOfMemory_.reset();
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMRealloc create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMReallocNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMCalloc.class)
    public static final class LLVMCallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMCalloc
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void0_outOfMemory_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void1_outOfMemory_;

        private LLVMCallocNodeGen(LLVMMemSetNode memSet, LLVMExpressionNode child0, LLVMExpressionNode child1) {
            super(memSet);
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int_int0(state_0, frameValue);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int_int0(int state_0__, VirtualFrame frameValue) {
            int child1Value_;
            int child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 2) != 0);
            BranchProfile outOfMemory__ = this.void0_outOfMemory_;
            if (outOfMemory__ != null) {
                return this.doVoid(child0Value_, child1Value_, outOfMemory__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long_long1(int state_0__, VirtualFrame frameValue) {
            long child1Value_;
            long child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            assert ((state_0 & 4) != 0);
            BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
            if (outOfMemory__1 != null) {
                return this.doVoid(child0Value_, child1Value_, outOfMemory__1);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_, child1Value_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof Integer) {
                    int child0Value__ = (Integer)child0Value_;
                    if (child1Value_ instanceof Integer) {
                        int child1Value__ = (Integer)child1Value_;
                        BranchProfile outOfMemory__ = this.void0_outOfMemory_;
                        if (outOfMemory__ != null) {
                            return this.doVoid(child0Value__, child1Value__, outOfMemory__);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    if (child1Value_ instanceof Long) {
                        long child1Value__ = (Long)child1Value_;
                        BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
                        if (outOfMemory__1 != null) {
                            return this.doVoid(child0Value__, child1Value__, outOfMemory__1);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    BranchProfile outOfMemory__ = BranchProfile.create();
                    Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.void0_outOfMemory_ = outOfMemory__;
                    this.state_0_ = state_0 |= 2;
                    return this.doVoid(child0Value_, child1Value_, outOfMemory__);
                }
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                if (child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    BranchProfile outOfMemory__1 = BranchProfile.create();
                    Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.void1_outOfMemory_ = outOfMemory__1;
                    this.state_0_ = state_0 |= 4;
                    return this.doVoid(child0Value_, child1Value_, outOfMemory__1);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            BranchProfile outOfMemory__ = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void0_outOfMemory_ = outOfMemory__;
            this.void0_outOfMemory_.disable();
            this.state_0_ |= 2;
            BranchProfile outOfMemory__1 = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void1_outOfMemory_ = outOfMemory__1;
            this.void1_outOfMemory_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.void0_outOfMemory_.reset();
            this.void1_outOfMemory_.reset();
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMCalloc create(LLVMMemSetNode memSet, LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMCallocNodeGen(memSet, child0, child1);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMMalloc.class)
    public static final class LLVMMallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMMalloc
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void0_outOfMemory_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile void1_outOfMemory_;

        private LLVMMallocNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            assert ((state_0 & 2) != 0);
            BranchProfile outOfMemory__ = this.void0_outOfMemory_;
            if (outOfMemory__ != null) {
                return this.doVoid(child0Value_, outOfMemory__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long child0Value_;
            int state_0 = state_0__;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            assert ((state_0 & 4) != 0);
            BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
            if (outOfMemory__1 != null) {
                return this.doVoid(child0Value_, outOfMemory__1);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && child0Value_ instanceof Integer) {
                    int child0Value__ = (Integer)child0Value_;
                    BranchProfile outOfMemory__ = this.void0_outOfMemory_;
                    if (outOfMemory__ != null) {
                        return this.doVoid(child0Value__, outOfMemory__);
                    }
                }
                if ((state_0 & 4) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    BranchProfile outOfMemory__1 = this.void1_outOfMemory_;
                    if (outOfMemory__1 != null) {
                        return this.doVoid(child0Value__, outOfMemory__1);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                BranchProfile outOfMemory__ = BranchProfile.create();
                Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.void0_outOfMemory_ = outOfMemory__;
                this.state_0_ = state_0 |= 2;
                return this.doVoid(child0Value_, outOfMemory__);
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                BranchProfile outOfMemory__1 = BranchProfile.create();
                Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.void1_outOfMemory_ = outOfMemory__1;
                this.state_0_ = state_0 |= 4;
                return this.doVoid(child0Value_, outOfMemory__1);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            BranchProfile outOfMemory__ = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void0_outOfMemory_ = outOfMemory__;
            this.void0_outOfMemory_.disable();
            this.state_0_ |= 2;
            BranchProfile outOfMemory__1 = BranchProfile.create();
            Objects.requireNonNull(outOfMemory__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void1_outOfMemory_ = outOfMemory__1;
            this.void1_outOfMemory_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.void0_outOfMemory_.reset();
            this.void1_outOfMemory_.reset();
        }

        @NeverDefault
        public static LLVMMemoryIntrinsic.LLVMMalloc create(LLVMExpressionNode child0) {
            return new LLVMMallocNodeGen(child0);
        }
    }
}

