/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.values.LLVMTimeZoneValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotTimeZoneFromIdNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.time.DateTimeException;

@NodeChild(value="zoneId", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotTimeZoneFromIdNode
extends LLVMExpressionNode {
    @CompilerDirectives.TruffleBoundary
    private LLVMTimeZoneValue timeZoneOfString(String timeZone) {
        try {
            return LLVMTimeZoneValue.ofString(timeZone);
        }
        catch (DateTimeException ex) {
            throw new LLVMPolyglotException((Node)this, "Could not construct time zone value: %s", ex.toString());
        }
    }

    @Specialization
    @GenerateAOT.Exclude
    public Object doDefault(LLVMManagedPointer pointer, @Cached LLVMAsForeignNode foreign, @Cached BranchProfile exception, @CachedLibrary(limit="3") InteropLibrary library) {
        Object object = foreign.execute(pointer);
        try {
            String s = library.asString(object);
            return LLVMManagedPointer.create(this.timeZoneOfString(s));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "The provided argument is not a string.");
        }
    }

    public static LLVMPolyglotTimeZoneFromIdNode create(LLVMExpressionNode zoneId) {
        return LLVMPolyglotTimeZoneFromIdNodeGen.create(zoneId);
    }
}

