/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMPolyglotFromString.class)
public final class LLVMPolyglotFromStringNodeGen
extends LLVMPolyglotFromString
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMReadCharsetNode charset_;
    @Node.Child
    private LLVMPolyglotFromString.ReadBytesNode rawString_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMPolyglotFromStringNodeGen(LLVMReadCharsetNode charset, LLVMPolyglotFromString.ReadBytesNode rawString) {
        this.charset_ = charset;
        this.rawString_ = rawString;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object charsetValue_ = this.charset_.execute(frameValue);
        byte[] rawStringValue_ = this.rawString_.execute(frameValue, (LLVMReadCharsetNode.LLVMCharset)charsetValue_);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(charsetValue_, rawStringValue_);
        }
        if ((state_0 & 2) != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doFromString(charsetValue__, rawStringValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(charsetValue_, rawStringValue_);
    }

    private LLVMManagedPointer executeAndSpecialize(Object charsetValue, byte[] rawStringValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (charsetValue instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue_ = (LLVMReadCharsetNode.LLVMCharset)charsetValue;
            this.state_0_ = state_0 |= 2;
            return this.doFromString(charsetValue_, rawStringValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.charset_, this.rawString_}, new Object[]{charsetValue, rawStringValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPolyglotFromString create(LLVMReadCharsetNode charset, LLVMPolyglotFromString.ReadBytesNode rawString) {
        return new LLVMPolyglotFromStringNodeGen(charset, rawString);
    }

    @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
    static final class ReadZeroTerminatedBytesNodeGen
    extends LLVMPolyglotFromString.ReadZeroTerminatedBytesNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMReadCharsetNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ReadI8Data readI8_cache;
        @Node.Child
        private ReadI16Data readI16_cache;
        @Node.Child
        private ReadI32Data readI32_cache;
        @Node.Child
        private ReadI64Data readI64_cache;

        private ReadZeroTerminatedBytesNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        protected byte[] execute(VirtualFrame frameValue, LLVMReadCharsetNode.LLVMCharset child0Value) {
            int state_0 = this.state_0_;
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value, child1Value_);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isPointer(child1Value_)) {
                ReadI64Data s3_;
                ReadI32Data s2_;
                ReadI16Data s1_;
                ReadI8Data s0_;
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                if ((state_0 & 2) != 0 && (s0_ = this.readI8_cache) != null && child0Value.zeroTerminatorLen == 1) {
                    return this.doReadI8(child0Value, child1Value__, s0_.load_);
                }
                if ((state_0 & 4) != 0 && (s1_ = this.readI16_cache) != null && child0Value.zeroTerminatorLen == 2) {
                    return this.doReadI16(child0Value, child1Value__, s1_.load_);
                }
                if ((state_0 & 8) != 0 && (s2_ = this.readI32_cache) != null && child0Value.zeroTerminatorLen == 4) {
                    return this.doReadI32(child0Value, child1Value__, s2_.load_);
                }
                if ((state_0 & 0x10) != 0 && (s3_ = this.readI64_cache) != null && child0Value.zeroTerminatorLen == 8) {
                    return this.doReadI64(child0Value, child1Value__, s3_.load_, s3_.toNative_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, child1Value_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object child1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMReadCharsetNode.LLVMCharset) {
                LLVMReadCharsetNode.LLVMCharset child0Value_ = (LLVMReadCharsetNode.LLVMCharset)child0Value;
                if (LLVMTypes.isPointer(child1Value)) {
                    LLVMPointer child1Value_ = LLVMTypes.asPointer(child1Value);
                    if (child0Value_.zeroTerminatorLen == 1) {
                        ReadI8Data s0_ = (ReadI8Data)this.insert(new ReadI8Data());
                        s0_.load_ = (LLVMI8LoadNode.LLVMI8OffsetLoadNode)s0_.insert(LLVMI8LoadNode.LLVMI8OffsetLoadNode.create());
                        VarHandle.storeStoreFence();
                        this.readI8_cache = s0_;
                        this.state_0_ = state_0 |= 2;
                        return this.doReadI8(child0Value_, child1Value_, s0_.load_);
                    }
                    if (child0Value_.zeroTerminatorLen == 2) {
                        ReadI16Data s1_ = (ReadI16Data)this.insert(new ReadI16Data());
                        s1_.load_ = (LLVMI16LoadNode.LLVMI16OffsetLoadNode)s1_.insert(LLVMI16LoadNode.LLVMI16OffsetLoadNode.create());
                        VarHandle.storeStoreFence();
                        this.readI16_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        return this.doReadI16(child0Value_, child1Value_, s1_.load_);
                    }
                    if (child0Value_.zeroTerminatorLen == 4) {
                        ReadI32Data s2_ = (ReadI32Data)this.insert(new ReadI32Data());
                        s2_.load_ = (LLVMI32LoadNode.LLVMI32OffsetLoadNode)s2_.insert(LLVMI32LoadNode.LLVMI32OffsetLoadNode.create());
                        VarHandle.storeStoreFence();
                        this.readI32_cache = s2_;
                        this.state_0_ = state_0 |= 8;
                        return this.doReadI32(child0Value_, child1Value_, s2_.load_);
                    }
                    if (child0Value_.zeroTerminatorLen == 8) {
                        ReadI64Data s3_ = (ReadI64Data)this.insert(new ReadI64Data());
                        s3_.load_ = (LLVMI64LoadNode.LLVMI64OffsetLoadNode)s3_.insert(LLVMI64LoadNode.LLVMI64OffsetLoadNode.create());
                        LLVMToNativeNode toNative__ = (LLVMToNativeNode)s3_.insert(LLVMToNativeNodeGen.create());
                        Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s3_.toNative_ = toNative__;
                        VarHandle.storeStoreFence();
                        this.readI64_cache = s3_;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doReadI64(child0Value_, child1Value_, s3_.load_, toNative__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            ReadI8Data s0_ = (ReadI8Data)this.insert(new ReadI8Data());
            s0_.load_ = (LLVMI8LoadNode.LLVMI8OffsetLoadNode)s0_.insert(LLVMI8LoadNode.LLVMI8OffsetLoadNode.create());
            VarHandle.storeStoreFence();
            this.readI8_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.load_, (int)1));
            ((GenerateAOT.Provider)s0_.load_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            ReadI16Data s1_ = (ReadI16Data)this.insert(new ReadI16Data());
            s1_.load_ = (LLVMI16LoadNode.LLVMI16OffsetLoadNode)s1_.insert(LLVMI16LoadNode.LLVMI16OffsetLoadNode.create());
            VarHandle.storeStoreFence();
            this.readI16_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.load_, (int)1));
            ((GenerateAOT.Provider)s1_.load_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            ReadI32Data s2_ = (ReadI32Data)this.insert(new ReadI32Data());
            s2_.load_ = (LLVMI32LoadNode.LLVMI32OffsetLoadNode)s2_.insert(LLVMI32LoadNode.LLVMI32OffsetLoadNode.create());
            VarHandle.storeStoreFence();
            this.readI32_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.load_, (int)1));
            ((GenerateAOT.Provider)s2_.load_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            ReadI64Data s3_ = (ReadI64Data)this.insert(new ReadI64Data());
            s3_.load_ = (LLVMI64LoadNode.LLVMI64OffsetLoadNode)s3_.insert(LLVMI64LoadNode.LLVMI64OffsetLoadNode.create());
            LLVMToNativeNode toNative__ = (LLVMToNativeNode)s3_.insert(LLVMToNativeNodeGen.create());
            Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s3_.toNative_ = toNative__;
            VarHandle.storeStoreFence();
            this.readI64_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.load_, (int)1));
            ((GenerateAOT.Provider)s3_.load_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s3_.toNative_, (int)1));
            ((GenerateAOT.Provider)s3_.toNative_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.readI8_cache = null;
            this.readI16_cache = null;
            this.readI32_cache = null;
            this.readI64_cache = null;
        }

        @NeverDefault
        public static LLVMPolyglotFromString.ReadZeroTerminatedBytesNode create(LLVMReadCharsetNode child0, LLVMExpressionNode child1) {
            return new ReadZeroTerminatedBytesNodeGen(child0, child1);
        }

        @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI8Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8LoadNode.LLVMI8OffsetLoadNode load_;

            ReadI8Data() {
            }
        }

        @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI16Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16LoadNode.LLVMI16OffsetLoadNode load_;

            ReadI16Data() {
            }
        }

        @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI32Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32LoadNode.LLVMI32OffsetLoadNode load_;

            ReadI32Data() {
            }
        }

        @GeneratedBy(value=LLVMPolyglotFromString.ReadZeroTerminatedBytesNode.class)
        @DenyReplace
        private static final class ReadI64Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64LoadNode.LLVMI64OffsetLoadNode load_;
            @Node.Child
            LLVMToNativeNode toNative_;

            ReadI64Data() {
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotFromString.ReadBytesWithLengthNode.class)
    static final class ReadBytesWithLengthNodeGen
    extends LLVMPolyglotFromString.ReadBytesWithLengthNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMReadCharsetNode child0_;
        @Node.Child
        private LLVMExpressionNode string_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ReadBytesWithLengthNodeGen(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            this.child0_ = child0;
            this.string_ = string;
            this.len_ = len;
        }

        @Override
        protected byte[] execute(VirtualFrame frameValue, LLVMReadCharsetNode.LLVMCharset child0Value) {
            long lenValue_;
            int state_0 = this.state_0_;
            Object stringValue_ = this.string_.executeGeneric(frameValue);
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(child0Value, stringValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(child0Value, stringValue_, lenValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(stringValue_)) {
                LLVMPointer stringValue__ = LLVMTypes.asPointer(stringValue_);
                return this.doRead(child0Value, stringValue__, lenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, stringValue_, lenValue_);
        }

        private byte[] executeAndSpecialize(Object child0Value, Object stringValue, Object lenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (child0Value instanceof LLVMReadCharsetNode.LLVMCharset) {
                LLVMReadCharsetNode.LLVMCharset child0Value_ = (LLVMReadCharsetNode.LLVMCharset)child0Value;
                if (LLVMTypes.isPointer(stringValue)) {
                    LLVMPointer stringValue_ = LLVMTypes.asPointer(stringValue);
                    if (lenValue instanceof Long) {
                        long lenValue_ = (Long)lenValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doRead(child0Value_, stringValue_, lenValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.string_, this.len_}, new Object[]{child0Value, stringValue, lenValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMPolyglotFromString.ReadBytesWithLengthNode create(LLVMReadCharsetNode child0, LLVMExpressionNode string, LLVMExpressionNode len) {
            return new ReadBytesWithLengthNodeGen(child0, string, len);
        }
    }
}

