/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.StringJoiner;

public final class LLVMNativeCallUtils {
    static Object callNativeFunction(boolean enabled, SignatureLibrary signatureLib, Object signature, Object function, Object[] nativeArgs, LLVMFunctionDescriptor descriptor) {
        CompilerAsserts.partialEvaluationConstant((boolean)enabled);
        if (enabled && descriptor != null) {
            LLVMNativeCallUtils.traceNativeCall(LLVMContext.get((Node)signatureLib), descriptor);
        }
        try {
            return signatureLib.call(signature, function, nativeArgs);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Exception thrown by a callback during the native call " + String.valueOf(function) + LLVMNativeCallUtils.argsToString(nativeArgs)), (Throwable)e);
        }
    }

    static Object callNativeFunction(boolean enabled, InteropLibrary nativeCall, Object function, Object[] nativeArgs, LLVMFunctionDescriptor descriptor) {
        CompilerAsserts.partialEvaluationConstant((boolean)enabled);
        if (enabled && descriptor != null) {
            LLVMNativeCallUtils.traceNativeCall(LLVMContext.get((Node)nativeCall), descriptor);
        }
        try {
            return nativeCall.execute(function, nativeArgs);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Exception thrown by a callback during the native call " + String.valueOf(function) + LLVMNativeCallUtils.argsToString(nativeArgs)), (Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String argsToString(Object[] nativeArgs) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Object arg : nativeArgs) {
            joiner.add(arg.toString());
        }
        return joiner.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceNativeCall(LLVMContext context, LLVMFunctionDescriptor descriptor) {
        context.registerNativeCall(descriptor);
    }
}

