/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMToVectorNode
extends LLVMExpressionNode {
    protected static final int SHORTS_PER_INT = 2;
    protected static final int SHORTS_PER_LONG = 4;
    protected static final int SHORTS_PER_FLOAT = 2;
    protected static final int SHORTS_PER_DOUBLE = 4;
    protected static final int INTS_PER_LONG = 2;
    protected static final int INTS_PER_DOUBLE = 2;
    protected static final int FLOATS_PER_LONG = 2;
    protected static final int FLOATS_PER_DOUBLE = 2;

    protected abstract int getVectorLength();

    public static abstract class LLVMBitcastToDoubleVectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMDoubleVector doLong(long from) {
            return this.doDouble(Double.longBitsToDouble(from));
        }

        @Specialization
        protected LLVMDoubleVector doDouble(double from) {
            double[] vector = new double[]{from};
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 64 == 0) : "invalid vector size";
            assert (from.getLength() / 64 == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 64; ++j) {
                    value |= (from.getValue(i * 64 + j) ? 1L : 0L) << j;
                }
                vector[i] = Double.longBitsToDouble(value);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() % 8 == 0) : "invalid vector size";
            assert (from.getLength() / 8 == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 8; ++j) {
                    value |= (long)(from.getValue(i * 8 + j) & 0xFF) << j * 8;
                }
                vector[i] = Double.longBitsToDouble(value);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() % 4 == 0) : "invalid vector size";
            assert (from.getLength() / 4 == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 4; ++j) {
                    value |= (long)(from.getValue(i * 4 + j) & 0xFFFF) << j * 16;
                }
                vector[i] = Double.longBitsToDouble(value);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 2; ++j) {
                    value |= ((long)from.getValue(i * 2 + j) & 0xFFFFFFFFL) << j * 32;
                }
                vector[i] = Double.longBitsToDouble(value);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doFloatVector(LLVMFloatVector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 2; ++j) {
                    value |= ((long)Float.floatToIntBits(from.getValue(i * 2 + j)) & 0xFFFFFFFFL) << j * 32;
                }
                vector[i] = Double.longBitsToDouble(value);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = Double.longBitsToDouble(from.getValue(i));
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        protected LLVMDoubleVector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMBitcastToFloatVectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMFloatVector doInt(int from) {
            return this.doFloat(Float.intBitsToFloat(from));
        }

        @Specialization
        protected LLVMFloatVector doFloat(float from) {
            float[] vector = new float[]{from};
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 32 == 0) : "invalid vector size";
            assert (from.getLength() / 32 == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 32; ++j) {
                    value |= (from.getValue(i * 32 + j) ? 1 : 0) << j;
                }
                vector[i] = Float.intBitsToFloat(value);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() % 4 == 0) : "invalid vector size";
            assert (from.getLength() / 4 == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 4; ++j) {
                    value |= (from.getValue(i * 4 + j) & 0xFF) << j * 8;
                }
                vector[i] = Float.intBitsToFloat(value);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 2; ++j) {
                    value |= (from.getValue(i * 2 + j) & 0xFFFF) << j * 16;
                }
                vector[i] = Float.intBitsToFloat(value);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = Float.intBitsToFloat(from.getValue(i));
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        protected LLVMFloatVector doFloatVector(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = Float.intBitsToFloat((int)(from.getValue(i) >>> j * 32 & 0xFFFFFFFFL));
                }
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                long value = Double.doubleToRawLongBits(from.getValue(i));
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = Float.intBitsToFloat((int)(value >>> j * 32 & 0xFFFFFFFFL));
                }
            }
            return LLVMFloatVector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToPointerVectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            LLVMPointer[] vector = new LLVMPointer[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = LLVMNativePointer.create(from.getValue(i));
            }
            return LLVMPointerVector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToI64VectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMI64Vector doI64(long from) {
            long[] vector = new long[]{from};
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        protected LLVMI64Vector doDouble(double from) {
            return this.doI64(Double.doubleToRawLongBits(from));
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 64 == 0) : "invalid vector size";
            assert (from.getLength() / 64 == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 64; ++j) {
                    value |= (from.getValue(i * 64 + j) ? 1L : 0L) << j;
                }
                vector[i] = value;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() % 8 == 0) : "invalid vector size";
            assert (from.getLength() / 8 == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 8; ++j) {
                    value |= (long)(from.getValue(i * 8 + j) & 0xFF) << j * 8;
                }
                vector[i] = value;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() % 4 == 0) : "invalid vector size";
            assert (from.getLength() / 4 == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 4; ++j) {
                    value |= (long)(from.getValue(i * 4 + j) & 0xFFFF) << j * 16;
                }
                vector[i] = value;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long value = 0L;
                for (int j = 0; j < 2; ++j) {
                    value |= ((long)from.getValue(i * 2 + j) & 0xFFFFFFFFL) << j * 32;
                }
                vector[i] = value;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        protected LLVMI64Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = Double.doubleToRawLongBits(from.getValue(i));
            }
            return LLVMI64Vector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToI32VectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMI32Vector doI32(int from) {
            int[] vector = new int[]{from};
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        protected LLVMI32Vector doFloat(float from) {
            return this.doI32(Float.floatToRawIntBits(from));
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI64(long from) {
            assert (2 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (int)(from >>> i * 32 & 0xFFFFFFFFL);
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        protected LLVMI32Vector doDouble(double from) {
            return this.doI64(Double.doubleToRawLongBits(from));
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 32 == 0) : "invalid vector size";
            assert (from.getLength() / 32 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 32; ++j) {
                    value |= (from.getValue(i * 32 + j) ? 1 : 0) << j;
                }
                vector[i] = value;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() % 4 == 0) : "invalid vector size";
            assert (from.getLength() / 4 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 4; ++j) {
                    value |= (from.getValue(i * 4 + j) & 0xFF) << j * 8;
                }
                vector[i] = value;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value = 0;
                for (int j = 0; j < 2; ++j) {
                    value |= (from.getValue(i * 2 + j) & 0xFFFF) << j * 16;
                }
                vector[i] = value;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        protected LLVMI32Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = (int)(from.getValue(i) >>> j * 32 & 0xFFFFFFFFL);
                }
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doFloatVector(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int value;
                vector[i] = value = Float.floatToRawIntBits(from.getValue(i));
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                long value = Double.doubleToRawLongBits(from.getValue(i));
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = (int)(value >>> j * 32 & 0xFFFFFFFFL);
                }
            }
            return LLVMI32Vector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToI16VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        private LLVMI16Vector castFromLong(long from, int elem) {
            assert (elem == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)(from >>> i * 16 & 0xFFFFL);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        protected LLVMI16Vector doI16(short from) {
            short[] vector = new short[]{from};
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        protected LLVMI16Vector doI32(int from) {
            return this.castFromLong(from, 2);
        }

        @Specialization
        protected LLVMI16Vector doI64(long from) {
            return this.castFromLong(from, 4);
        }

        @Specialization
        protected LLVMI16Vector doFloat(float from) {
            return this.doI32(Float.floatToRawIntBits(from));
        }

        @Specialization
        protected LLVMI16Vector doDouble(double from) {
            return this.doI64(Double.doubleToRawLongBits(from));
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector do80BitFloat(LLVM80BitFloat from) {
            assert (5 == this.getVectorLength());
            byte[] vectorBytes = from.getBytes();
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)(Byte.toUnsignedInt(vectorBytes[i * 2]) | Byte.toUnsignedInt(vectorBytes[i * 2 + 1]) << 8);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 16 == 0) : "invalid vector size";
            assert (from.getLength() / 16 == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                short value = 0;
                for (int j = 0; j < 16; ++j) {
                    value = (short)(value | (short)((from.getValue(i * 16 + j) ? 1 : 0) << j));
                }
                vector[i] = value;
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() % 2 == 0) : "invalid vector size";
            assert (from.getLength() / 2 == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                short value = 0;
                for (int j = 0; j < 2; ++j) {
                    value = (short)(value | (short)((from.getValue(i * 2 + j) & 0xFF) << j * 8));
                }
                vector[i] = value;
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        protected LLVMI16Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = (short)(from.getValue(i) >>> j * 16 & 0xFFFF);
                }
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() * 4 == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    vector[i * 4 + j] = (short)(from.getValue(i) >>> j * 16 & 0xFFFFL);
                }
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() * 4 == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 4; ++i) {
                long value = Double.doubleToRawLongBits(from.getValue(i));
                for (int j = 0; j < 4; ++j) {
                    vector[i * 4 + j] = (short)(value >>> j * 16 & 0xFFFFL);
                }
            }
            return LLVMI16Vector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToI8VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        private LLVMI8Vector castFromLong(long from, int elem) {
            assert (elem == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)(from >>> i * 8 & 0xFFL);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        protected LLVMI8Vector doI8(byte from) {
            byte[] vector = new byte[]{from};
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        protected LLVMI8Vector doI16(short from) {
            return this.castFromLong(from, 2);
        }

        @Specialization
        protected LLVMI8Vector doI32(int from) {
            return this.castFromLong(from, 4);
        }

        @Specialization
        protected LLVMI8Vector doI64(long from) {
            return this.castFromLong(from, 8);
        }

        @Specialization
        protected LLVMI8Vector doFloat(float from) {
            return this.doI32(Float.floatToRawIntBits(from));
        }

        @Specialization
        protected LLVMI8Vector doDouble(double from) {
            return this.doI64(Double.doubleToRawLongBits(from));
        }

        @Specialization
        protected LLVMI8Vector do80BitFloat(LLVM80BitFloat from) {
            byte[] vector = from.getBytes();
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() % 8 == 0) : "invalid vector size";
            assert (from.getLength() / 8 == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                byte value = 0;
                for (int j = 0; j < 8; ++j) {
                    value = (byte)(value | (byte)((from.getValue(i * 8 + j) ? 1 : 0) << j));
                }
                vector[i] = value;
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        protected LLVMI8Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() * 2 == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    vector[i * 2 + j] = (byte)(from.getValue(i) >>> j * 8 & 0xFF);
                }
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() * 4 == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    vector[i * 4 + j] = (byte)(from.getValue(i) >>> j * 8 & 0xFF);
                }
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() * 8 == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    vector[i * 8 + j] = (byte)(from.getValue(i) >>> j * 8 & 0xFFL);
                }
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() * 8 == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 8; ++i) {
                long value = Double.doubleToRawLongBits(from.getValue(i));
                for (int j = 0; j < 8; ++j) {
                    vector[i * 8 + j] = (byte)(value >>> j * 8 & 0xFFL);
                }
            }
            return LLVMI8Vector.create(vector);
        }
    }

    public static abstract class LLVMBitcastToI1VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        private LLVMI1Vector castFromLong(long from, int elem) {
            assert (elem == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (from & 1L << i) != 0L;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        protected LLVMI1Vector doI1(boolean from) {
            boolean[] vector = new boolean[]{from};
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        protected LLVMI1Vector doI8(byte from) {
            return this.castFromLong(from, 8);
        }

        @Specialization
        protected LLVMI1Vector doI16(short from) {
            return this.castFromLong(from, 16);
        }

        @Specialization
        protected LLVMI1Vector doI32(int from) {
            return this.castFromLong(from, 32);
        }

        @Specialization
        protected LLVMI1Vector doI64(long from) {
            return this.castFromLong(from, 64);
        }

        @Specialization
        protected LLVMI1Vector doFloat(float from) {
            return this.doI32(Float.floatToRawIntBits(from));
        }

        @Specialization
        protected LLVMI1Vector doDouble(double from) {
            return this.doI64(Double.doubleToRawLongBits(from));
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector do80BitFloat(LLVM80BitFloat from) {
            assert (80 == this.getVectorLength());
            byte[] vectorBytes = from.getBytes();
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    vector[i * 8 + j] = (vectorBytes[i] & 1 << j) != 0;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        protected LLVMI1Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() * 8 == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    vector[i * 8 + j] = (from.getValue(i) & 1 << j) != 0;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() * 16 == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    vector[i * 16 + j] = (from.getValue(i) & 1 << j) != 0;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() * 32 == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    vector[i * 32 + j] = (from.getValue(i) & 1 << j) != 0;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() * 64 == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    vector[i * 64 + j] = (from.getValue(i) & 1L << j) != 0L;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() * 64 == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength() / 64; ++i) {
                long value = Double.doubleToRawLongBits(from.getValue(i));
                for (int j = 0; j < 64; ++j) {
                    vector[i * 64 + j] = (value & 1L << j) != 0L;
                }
            }
            return LLVMI1Vector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToDoubleVectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? -1.0 : 0.0;
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            double[] vector = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization
        protected LLVMDoubleVector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMSignedCastToFloatVectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? -1.0f : 0.0f;
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization
        protected LLVMFloatVector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            float[] vector = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (float)from.getValue(i);
            }
            return LLVMFloatVector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToI64VectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? -1L : 0L;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        protected LLVMI64Vector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (long)from.getValue(i);
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (long)from.getValue(i);
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doPointer(LLVMPointerVector from, @Cached LLVMToNativeNode toNativeNode) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = toNativeNode.executeWithTarget(from.getValue(i)).asNative();
            }
            return LLVMI64Vector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToI32VectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? -1 : 0;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        protected LLVMI32Vector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (int)from.getValue(i);
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (int)from.getValue(i);
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (int)from.getValue(i);
            }
            return LLVMI32Vector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToI16VectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)(from.getValue(i) ? -1 : 0);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        protected LLVMI16Vector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)from.getValue(i);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)from.getValue(i);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)from.getValue(i);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)from.getValue(i);
            }
            return LLVMI16Vector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToI8VectorNode
    extends LLVMToVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)(from.getValue(i) ? -1 : 0);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        protected LLVMI8Vector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)from.getValue(i);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)from.getValue(i);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)from.getValue(i);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)from.getValue(i);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)from.getValue(i);
            }
            return LLVMI8Vector.create(vector);
        }
    }

    public static abstract class LLVMSignedCastToI1VectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMI1Vector doI1(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI8(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (from.getValue(i) & 1) != 0;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI16(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (from.getValue(i) & 1) != 0;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI32(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (from.getValue(i) & 1) != 0;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI64(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (from.getValue(i) & 1L) != 0L;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doFloat(LLVMFloatVector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) != 0.0f;
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doDouble(LLVMDoubleVector from) {
            assert (from.getLength() == this.getVectorLength());
            boolean[] vector = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) != 0.0;
            }
            return LLVMI1Vector.create(vector);
        }
    }
}

