/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeField(name="slot", type=int.class)
public abstract class LLVMAMD64ReadAddressNode
extends LLVMExpressionNode {
    protected abstract int getSlot();

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected long readI64(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getLong(this.getSlot());
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected LLVMPointer readPointer(VirtualFrame frame) throws FrameSlotTypeException {
        return LLVMPointer.cast(frame.getObject(this.getSlot()));
    }

    @Specialization(replaces={"readI64", "readPointer"})
    protected Object readGeneric(VirtualFrame frame) {
        return frame.getValue(this.getSlot());
    }
}

