/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateLibrary
@GenerateAOT
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=LLVMManagedAccessDefaults.VirtualAlloc.class), @GenerateLibrary.DefaultExport(value=LLVMManagedAccessDefaults.FallbackWrite.class)})
public abstract class LLVMManagedWriteLibrary
extends Library {
    private static final LibraryFactory<LLVMManagedWriteLibrary> FACTORY = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    @GenerateLibrary.Abstract
    public boolean isWritable(Object receiver) {
        return false;
    }

    public abstract void writeI8(Object var1, long var2, byte var4);

    public abstract void writeI16(Object var1, long var2, short var4);

    public abstract void writeI32(Object var1, long var2, int var4);

    public void writeFloat(Object receiver, long offset, float value) {
        this.writeI32(receiver, offset, Float.floatToRawIntBits(value));
    }

    public void writeI64(Object receiver, long offset, long value) {
        this.writeGenericI64(receiver, offset, value);
    }

    public abstract void writeGenericI64(Object var1, long var2, Object var4);

    public void writeDouble(Object receiver, long offset, double value) {
        this.writeI64(receiver, offset, Double.doubleToRawLongBits(value));
    }

    public void writePointer(Object receiver, long offset, LLVMPointer value) {
        this.writeGenericI64(receiver, offset, value);
    }

    public static LibraryFactory<LLVMManagedWriteLibrary> getFactory() {
        return FACTORY;
    }
}

