/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@GenerateUncached
public abstract class ToLLVM
extends LLVMNode {
    private static final UnsupportedMessageException REWRITE = UnsupportedMessageException.create();

    public abstract Object executeWithType(Object var1, LLVMInteropType.Value var2, ForeignToLLVM.ForeignToLLVMType var3);

    @Specialization(guards={"incomingType != null", "incomingType.getSize() == targetType.getSizeInBytes()"}, rewriteOn={UnsupportedMessageException.class})
    Object doConvert(Object value, LLVMInteropType.Value incomingType, ForeignToLLVM.ForeignToLLVMType targetType, @Cached ReadValue read, @Cached ConvertValue convert) throws UnsupportedMessageException {
        Object incoming = read.execute(value, incomingType);
        return convert.execute(incoming, targetType);
    }

    @Specialization(guards={"incomingType != null"}, replaces={"doConvert"})
    Object doConvertTypeMismatch(Object value, LLVMInteropType.Value incomingType, ForeignToLLVM.ForeignToLLVMType targetType, @Cached ReadValue read, @Cached ConvertValue convert, @Cached ReadUnknown readUnknown) {
        if (incomingType.getSize() == (long)targetType.getSizeInBytes()) {
            try {
                return this.doConvert(value, incomingType, targetType, read, convert);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        return readUnknown.executeWithType(value, targetType);
    }

    @Specialization(guards={"incomingType == null"})
    static Object doUnknownType(Object value, LLVMInteropType.Value incomingType, ForeignToLLVM.ForeignToLLVMType targetType, @Cached ReadUnknown read) {
        return read.executeWithType(value, targetType);
    }

    @GenerateUncached
    @ImportStatic(value={LLVMInteropType.ValueKind.class})
    static abstract class ReadValue
    extends LLVMNode {
        ReadValue() {
        }

        protected abstract Object execute(Object var1, LLVMInteropType.Value var2) throws UnsupportedMessageException;

        @Specialization(limit="3", guards={"incomingType.kind == I1"})
        @GenerateAOT.Exclude
        static boolean doI1(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.isBoolean(value)) {
                throw REWRITE;
            }
            return interop.asBoolean(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == I8"})
        @GenerateAOT.Exclude
        static byte doI8(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInByte(value)) {
                throw REWRITE;
            }
            return interop.asByte(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == I16"})
        @GenerateAOT.Exclude
        static short doI16(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInShort(value)) {
                throw REWRITE;
            }
            return interop.asShort(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == I32"})
        @GenerateAOT.Exclude
        static int doI32(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInInt(value)) {
                throw REWRITE;
            }
            return interop.asInt(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == I64"})
        @GenerateAOT.Exclude
        static long doI64(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInLong(value)) {
                throw REWRITE;
            }
            return interop.asLong(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == FLOAT"})
        @GenerateAOT.Exclude
        static float doFloat(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInFloat(value)) {
                throw REWRITE;
            }
            return interop.asFloat(value);
        }

        @Specialization(limit="3", guards={"incomingType.kind == DOUBLE"})
        @GenerateAOT.Exclude
        static double doDouble(Object value, LLVMInteropType.Value incomingType, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            if (!interop.fitsInDouble(value)) {
                throw REWRITE;
            }
            return interop.asDouble(value);
        }

        @Specialization(guards={"incomingType.kind == POINTER"})
        static LLVMPointer doPointer(Object value, LLVMInteropType.Value incomingType, @Cached WrapPointer wrap) {
            return wrap.execute(value, incomingType.baseType);
        }
    }

    @GenerateUncached
    @ImportStatic(value={ForeignToLLVM.ForeignToLLVMType.class})
    static abstract class ConvertValue
    extends LLVMNode {
        ConvertValue() {
        }

        protected abstract Object execute(Object var1, ForeignToLLVM.ForeignToLLVMType var2);

        @Specialization(guards={"targetType == I1"})
        static boolean doI1(boolean value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == I8"})
        static byte doI8(byte value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == I16"})
        static short doI16(short value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == I32"})
        static int doI32(int value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == I32"})
        static int doI32(float value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return Float.floatToRawIntBits(value);
        }

        @Specialization(guards={"targetType == I64"})
        static long doI64(long value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == I64"})
        static long doI64(double value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return Double.doubleToRawLongBits(value);
        }

        @Specialization(guards={"targetType == I64"})
        static LLVMPointer doI64(LLVMPointer value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == FLOAT"})
        static float doFloat(float value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == FLOAT"})
        static float doFloat(int value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return Float.intBitsToFloat(value);
        }

        @Specialization(guards={"targetType == DOUBLE"})
        static double doDouble(double value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == DOUBLE"})
        static double doDouble(long value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return Double.longBitsToDouble(value);
        }

        @Specialization(guards={"targetType == DOUBLE"})
        double doDouble(LLVMPointer value, ForeignToLLVM.ForeignToLLVMType targetType) {
            throw new LLVMPolyglotException((Node)this, "Cannot convert a pointer to %s", new Object[]{targetType});
        }

        @Specialization(guards={"targetType == POINTER"})
        static LLVMPointer doPointer(LLVMPointer value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return value;
        }

        @Specialization(guards={"targetType == POINTER"})
        static LLVMPointer doPointer(long value, ForeignToLLVM.ForeignToLLVMType targetType) {
            return LLVMNativePointer.create(value);
        }

        @Specialization(guards={"targetType == POINTER"})
        LLVMPointer doPointer(double value, ForeignToLLVM.ForeignToLLVMType targetType) {
            throw new LLVMPolyglotException((Node)this, "Cannot convert a double to %s", new Object[]{targetType});
        }
    }

    @GenerateUncached
    @ImportStatic(value={ForeignToLLVM.ForeignToLLVMType.class})
    static abstract class ReadUnknown
    extends LLVMNode {
        ReadUnknown() {
        }

        protected abstract Object executeWithType(Object var1, ForeignToLLVM.ForeignToLLVMType var2);

        @Specialization(guards={"isI1(targetType)"})
        static boolean toI1(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToI1()", uncached="getSlowPath()") ForeignToLLVM toI1) {
            return LLVMTypesGen.asBoolean(toI1.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isI8(targetType)"})
        static byte toI8(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToI8()", uncached="getSlowPath()") ForeignToLLVM toI8) {
            return LLVMTypesGen.asByte(toI8.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isI16(targetType)"})
        static short toI16(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToI16()", uncached="getSlowPath()") ForeignToLLVM toI16) {
            return LLVMTypesGen.asShort(toI16.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isI32(targetType)"})
        static int toI32(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToI32()", uncached="getSlowPath()") ForeignToLLVM toI32) {
            return LLVMTypesGen.asInteger(toI32.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isI64(targetType)"})
        static Object toI64(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToI64()", uncached="getSlowPath()") ForeignToLLVM toI64) {
            return toI64.executeWithForeignToLLVMType(value, null, targetType);
        }

        @Specialization(guards={"isFloat(targetType)"})
        static float toFloat(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToFloat()", uncached="getSlowPath()") ForeignToLLVM toFloat) {
            return LLVMTypesGen.asFloat(toFloat.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isDouble(targetType)"})
        static double toDouble(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToDouble()", uncached="getSlowPath()") ForeignToLLVM toDouble) {
            return LLVMTypesGen.asDouble(toDouble.executeWithForeignToLLVMType(value, null, targetType));
        }

        @Specialization(guards={"isPointer(targetType)"})
        static Object toPointer(Object value, ForeignToLLVM.ForeignToLLVMType targetType, @Cached(value="createToPointer()", uncached="getSlowPath()") ForeignToLLVM toPointer) {
            return toPointer.executeWithForeignToLLVMType(value, null, targetType);
        }

        static boolean isI1(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.I1;
        }

        static boolean isI8(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.I8;
        }

        static boolean isI16(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.I16;
        }

        static boolean isI32(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.I32;
        }

        static boolean isI64(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.I64;
        }

        static boolean isFloat(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.FLOAT;
        }

        static boolean isDouble(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.DOUBLE;
        }

        static boolean isPointer(ForeignToLLVM.ForeignToLLVMType targetType) {
            return targetType == ForeignToLLVM.ForeignToLLVMType.POINTER;
        }

        protected ForeignToLLVM createToI1() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I1);
        }

        protected ForeignToLLVM createToI8() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I8);
        }

        protected ForeignToLLVM createToI16() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I16);
        }

        protected ForeignToLLVM createToI32() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I32);
        }

        protected ForeignToLLVM createToI64() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I64);
        }

        protected ForeignToLLVM createToFloat() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.FLOAT);
        }

        protected ForeignToLLVM createToDouble() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.DOUBLE);
        }

        protected ForeignToLLVM createToPointer() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER);
        }
    }

    @GenerateUncached
    static abstract class WrapPointer
    extends LLVMNode {
        WrapPointer() {
        }

        protected abstract LLVMPointer execute(Object var1, LLVMInteropType.Structured var2);

        @Specialization
        LLVMPointer doPointer(LLVMPointer pointer, LLVMInteropType.Structured type) {
            return pointer;
        }

        static boolean isPointer(Object value) {
            return LLVMPointer.isInstance(value);
        }

        @Specialization(limit="3", guards={"!isPointer(value)", "type != null", "!nativeTypes.hasNativeType(value)"})
        @GenerateAOT.Exclude
        LLVMPointer doTyped(Object value, LLVMInteropType.Structured type, @CachedLibrary(value="value") NativeTypeLibrary nativeTypes) {
            return LLVMManagedPointer.create(LLVMTypedForeignObject.create(value, type));
        }

        @Specialization(limit="3", guards={"!isPointer(value)", "type == null || nativeTypes.hasNativeType(value)"})
        @GenerateAOT.Exclude
        LLVMPointer doUntyped(Object value, LLVMInteropType.Structured type, @CachedLibrary(value="value") NativeTypeLibrary nativeTypes) {
            assert (type == null || nativeTypes.hasNativeType(value));
            return LLVMManagedPointer.create(value);
        }
    }
}

