/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

@GeneratedBy(value=LLVMInteropType.class)
public final class LLVMInteropTypeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMInteropTypeGen() {
    }

    static {
        LibraryExport.register(LLVMInteropType.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=LLVMInteropType.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMInteropType.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMInteropType);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMInteropType);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMInteropType.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends LLVMInteropType> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMInteropType)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).isMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).getMetaSimpleName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).getMetaSimpleName();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).isMetaInstance(instance);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=LLVMInteropType.class)
        public static class Cached
        extends InteropLibrary {
            private final Class<? extends LLVMInteropType> receiverClass_;

            protected Cached(Object receiver) {
                LLVMInteropType castReceiver = (LLVMInteropType)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getMetaSimpleName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getMetaSimpleName();
            }

            public boolean isMetaInstance(Object receiver, Object instance) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isMetaInstance(instance);
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).toDisplayString(allowSideEffects);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropType.class)
    public static class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMInteropType.class, false, false, 0);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMInteropType);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMInteropType);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMInteropType.class)
        public static class Uncached
        extends LLVMAsForeignLibrary
        implements UnadoptableNode {
            private final Class<? extends LLVMInteropType> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMInteropType)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)receiver).isForeign();
            }
        }

        @GeneratedBy(value=LLVMInteropType.class)
        public static class Cached
        extends LLVMAsForeignLibrary {
            private final Class<? extends LLVMInteropType> receiverClass_;

            protected Cached(Object receiver) {
                LLVMInteropType castReceiver = (LLVMInteropType)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInteropType)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isForeign();
            }
        }
    }
}

