/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.llvm.runtime.floating.BinaryHelper;

final class FloatHelper {
    static final int FLOAT_SIGN_POS = 31;
    static final int FLOAT_FRACTION_BIT_WIDTH = 23;
    static final float POSITIVE_ZERO = 0.0f;
    static final float NEGATIVE_ZERO = -0.0f;
    static final float NaN = Float.NaN;
    static final float NEGATIVE_INFINITY = Float.NEGATIVE_INFINITY;
    static final float POSITIVE_INFINITY = Float.POSITIVE_INFINITY;
    static final int FRACTION_MASK = BinaryHelper.getBitMask(23);

    FloatHelper() {
    }

    static boolean isPositiveZero(float val) {
        return Float.floatToIntBits(0.0f) == Float.floatToIntBits(val);
    }

    static boolean isNegativeZero(float val) {
        return Float.floatToIntBits(-0.0f) == Float.floatToIntBits(val);
    }

    static boolean isPositiveInfinty(float val) {
        return val == Float.POSITIVE_INFINITY;
    }

    static boolean isNegativeInfinity(float val) {
        return val == Float.NEGATIVE_INFINITY;
    }

    static boolean isNaN(float val) {
        return Float.isNaN(val);
    }

    static int getUnbiasedExponent(float val) {
        return Math.getExponent(val);
    }
}

