/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class LLVMSourceEnumLikeType
extends LLVMSourceType {
    private final Map<Long, String> values;

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceEnumLikeType(Supplier<String> nameSupplier, long size, long align, long offset, LLVMSourceLocation location) {
        this(nameSupplier, size, align, offset, new HashMap<Long, String>(), location);
    }

    private LLVMSourceEnumLikeType(Supplier<String> nameSupplier, long size, long align, long offset, Map<Long, String> values, LLVMSourceLocation location) {
        super(nameSupplier, size, align, offset, location);
        this.values = values;
    }

    public void addValue(long id, String representation) {
        CompilerAsserts.neverPartOfCompilation();
        this.values.put(id, representation);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getElementName(long i) {
        return this.values.get(i);
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return new LLVMSourceEnumLikeType(this::getName, this.getSize(), this.getAlign(), this.getOffset(), this.values, this.getLocation());
    }

    @Override
    public boolean isEnum() {
        return true;
    }
}

