/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public final class DebugExprException
extends LLVMException {
    private static final long serialVersionUID = -5083864640686842678L;

    private DebugExprException(LLVMExpressionNode operation, String message) {
        super(operation, message);
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugExprException typeError(LLVMExpressionNode operation, Object ... members) {
        StringBuilder sb = new StringBuilder();
        sb.append("unexpected type ");
        if (members != null && members.length > 0 && members[0] != null) {
            sb.append("of \"");
            sb.append(members[0].toString());
            sb.append("\"");
            for (int i = 1; i < members.length; ++i) {
                sb.append(", \"");
                sb.append(members[i].toString());
                sb.append("\"");
            }
        }
        if (operation != null) {
            sb.append("at ");
            sb.append(((Object)((Object)operation)).getClass().getSimpleName());
        }
        return new DebugExprException(operation, sb.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugExprException symbolNotFound(LLVMExpressionNode operation, String name, Object receiver) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" not found");
        if (receiver != null) {
            sb.append(" as member of ");
            sb.append(receiver.toString());
        }
        return new DebugExprException(operation, sb.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugExprException nullObject(String description) {
        return new DebugExprException(null, "member at " + description + " is not available");
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugExprException create(LLVMExpressionNode operation, String message, Object ... args) {
        return new DebugExprException(operation, String.format(message, args));
    }
}

