/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExpressionPair;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.List;

public abstract class DebugExprFunctionCallNode
extends LLVMExpressionNode {
    private final String functionName;
    @Node.Children
    private final LLVMExpressionNode[] arguments;
    private final Object scope;

    public DebugExprFunctionCallNode(String functionName, List<DebugExpressionPair> arguments, Object scope) {
        this.functionName = functionName;
        this.scope = scope;
        this.arguments = new LLVMExpressionNode[arguments.size()];
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = arguments.get(i).getNode();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public DebugExprType getType() {
        InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        if (library.isMemberReadable(this.scope, this.functionName)) {
            try {
                LLVMManagedPointer pointer;
                Object member = library.readMember(this.scope, this.functionName);
                if (LLVMManagedPointer.isInstance(member) && (pointer = LLVMManagedPointer.cast(member)).getOffset() == 0L) {
                    member = pointer.getObject();
                }
                if (member instanceof LLVMFunctionDescriptor) {
                    LLVMFunctionDescriptor ldv = (LLVMFunctionDescriptor)member;
                    Type returnType = ldv.getLLVMFunction().getType().getReturnType();
                    DebugExprType t = DebugExprType.getTypeFromLLVMType(returnType);
                    return t;
                }
                throw DebugExprException.create(this, "variable %s does not point to a function", this.functionName);
            }
            catch (UnsupportedMessageException e) {
                throw DebugExprException.create(this, "error while accessing function %s", this.functionName);
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                // empty catch block
            }
        }
        throw DebugExprException.symbolNotFound(this, this.functionName, null);
    }

    @Specialization
    Object doCall(VirtualFrame frame) {
        InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        if (library.isMemberExisting(this.scope, this.functionName)) {
            try {
                Object member = library.readMember(this.scope, this.functionName);
                if (library.isExecutable(member)) {
                    try {
                        Object[] argumentArr = new Object[this.arguments.length];
                        for (int i = 0; i < this.arguments.length; ++i) {
                            argumentArr[i] = this.arguments[i].executeGeneric(frame);
                        }
                        return library.execute(member, argumentArr);
                    }
                    catch (UnsupportedTypeException e) {
                        throw DebugExprException.create(this, "actual and formal parameters of %s do not match", this.functionName);
                    }
                    catch (ArityException e) {
                        throw DebugExprException.create(this, "%s requires %d argument(s) but got %d", this.functionName, e.getExpectedMinArity(), e.getActualArity());
                    }
                }
                throw DebugExprException.create(this, "%s is not invocable", this.functionName);
            }
            catch (UnsupportedMessageException e1) {
                throw DebugExprException.create(this, "Error while accessing function %s", this.functionName);
            }
            catch (UnknownIdentifierException e1) {
                throw DebugExprException.symbolNotFound(this, e1.getUnknownIdentifier(), this.functionName);
            }
        }
        throw DebugExprException.symbolNotFound(this, this.functionName, null);
    }
}

