/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.math.BigInteger;

public abstract class LLVMIVarBit {
    public abstract LLVMIVarBit copy();

    public abstract byte getByteValue();

    public abstract byte getZeroExtendedByteValue();

    public abstract short getShortValue();

    public abstract short getZeroExtendedShortValue();

    public abstract int getIntValue();

    public abstract int getZeroExtendedIntValue();

    public abstract long getLongValue();

    public abstract long getZeroExtendedLongValue();

    public abstract int getBitSize();

    public abstract byte[] getBytes();

    public abstract LLVMIVarBit add(LLVMIVarBit var1);

    public abstract LLVMIVarBit mul(LLVMIVarBit var1);

    public abstract LLVMIVarBit sub(LLVMIVarBit var1);

    public abstract LLVMIVarBit div(LLVMIVarBit var1);

    public abstract LLVMIVarBit rem(LLVMIVarBit var1);

    public abstract LLVMIVarBit unsignedRem(LLVMIVarBit var1);

    public abstract LLVMIVarBit unsignedDiv(LLVMIVarBit var1);

    public abstract boolean isEqual(LLVMIVarBit var1);

    public abstract LLVMIVarBit and(LLVMIVarBit var1);

    public abstract LLVMIVarBit or(LLVMIVarBit var1);

    public abstract LLVMIVarBit xor(LLVMIVarBit var1);

    public abstract LLVMIVarBit leftShift(LLVMIVarBit var1);

    public abstract LLVMIVarBit logicalRightShift(LLVMIVarBit var1);

    public abstract LLVMIVarBit arithmeticRightShift(LLVMIVarBit var1);

    public abstract int signedCompare(LLVMIVarBit var1);

    public abstract int unsignedCompare(LLVMIVarBit var1);

    public abstract boolean isZero();

    public abstract BigInteger getDebugValue(boolean var1);

    public static LLVMIVarBit create(int bits, byte[] loadedBytes, int loadedArrBits, boolean signExtend) {
        if (bits <= 64) {
            return new LLVMIVarBitSmall(bits, loadedBytes, loadedArrBits, signExtend);
        }
        return new LLVMIVarBitLarge(bits, loadedBytes, loadedArrBits, signExtend);
    }

    public static LLVMIVarBit create(int bits, long loadedValue, int loadedArrBits, boolean signExtend) {
        if (bits <= 64) {
            return new LLVMIVarBitSmall(bits, loadedValue);
        }
        return new LLVMIVarBitLarge(bits, LLVMIVarBit.longToArray(loadedValue), loadedArrBits, signExtend);
    }

    public static LLVMIVarBit createZeroExt(int bits, byte from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.byteToArray(from), 8, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, short from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.shortToArray(from), 16, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, int from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.intToArray(from), 32, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, long from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.longToArray(from), 64, false);
    }

    public static LLVMIVarBit fromBigInteger(int bits, BigInteger from) {
        assert (bits > 64);
        return LLVMIVarBitLarge.asIVar(bits, from);
    }

    public static LLVMIVarBit fromByte(int bits, byte from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.byteToArray(from), 8, true);
    }

    public static LLVMIVarBit fromShort(int bits, short from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.shortToArray(from), 16, true);
    }

    public static LLVMIVarBit fromInt(int bits, int from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.intToArray(from), 32, true);
    }

    public static LLVMIVarBit fromLong(int bits, long from) {
        return LLVMIVarBit.create(bits, LLVMIVarBit.longToArray(from), 64, true);
    }

    private static byte[] byteToArray(byte from) {
        return new byte[]{from};
    }

    private static byte[] shortToArray(short from) {
        byte[] array = new byte[2];
        ByteArraySupport.bigEndian().putShort(array, 0, from);
        return array;
    }

    private static byte[] intToArray(int from) {
        byte[] array = new byte[4];
        ByteArraySupport.bigEndian().putInt(array, 0, from);
        return array;
    }

    private static byte[] longToArray(long from) {
        byte[] array = new byte[8];
        ByteArraySupport.bigEndian().putLong(array, 0, from);
        return array;
    }

    @ExplodeLoop
    public static LLVMIVarBit fromI1Vector(int bits, LLVMI1Vector from) {
        CompilerAsserts.partialEvaluationConstant((int)bits);
        if (bits <= 64) {
            long value = 0L;
            for (int i = 0; i < bits; ++i) {
                if (!from.getValue(i)) continue;
                value |= (long)(1 << i);
            }
            return LLVMIVarBitSmall.create(bits, value, bits, false);
        }
        byte[] value = new byte[bits + 7 >> 3];
        for (int i = 0; i < bits; ++i) {
            if (!from.getValue(i)) continue;
            int n = value.length - 1 - (i >> 3);
            value[n] = (byte)(value[n] | (byte)(1 << (i & 7)));
        }
        return LLVMIVarBitLarge.create(bits, value, bits, false);
    }
}

