/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public class LLVMAlias
extends LLVMSymbol {
    private final LLVMSymbol target;

    public LLVMAlias(String name, LLVMSymbol target, boolean exported) {
        super(name, IDGenerater.INVALID_ID, -1, exported, false);
        this.target = target instanceof LLVMAlias ? ((LLVMAlias)target).getTarget() : target;
    }

    public LLVMSymbol getTarget() {
        return this.target;
    }

    @Override
    public boolean isFunction() {
        return this.target.isFunction();
    }

    @Override
    public boolean isGlobalVariable() {
        return this.target.isGlobalVariable();
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public LLVMFunction asFunction() {
        return this.target.asFunction();
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        return this.target.asGlobalVariable();
    }

    public String toString() {
        return super.getName() + " -> " + this.target.toString();
    }

    public static LLVMSymbol resolveAlias(LLVMSymbol symbol) {
        CompilerAsserts.partialEvaluationConstant((Object)symbol);
        if (symbol.isAlias()) {
            return ((LLVMAlias)symbol).getTarget();
        }
        return symbol;
    }

    @Override
    public boolean isElemPtrExpression() {
        return this.target.isElemPtrExpression();
    }

    @Override
    public LLVMElemPtrSymbol asElemPtrExpression() {
        return this.target.asElemPtrExpression();
    }

    @Override
    public LLVMThreadLocalSymbol asThreadLocalSymbol() {
        return this.target.asThreadLocalSymbol();
    }

    @Override
    public boolean isThreadLocalSymbol() {
        return this.target.isThreadLocalSymbol();
    }
}

