/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.util;

import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SymbolNameMangling {
    private static final String MANGLED_PREFIX = "\u0001";
    private static final BiFunction<Linkage, String, String> DEFAULT_DEMANGLER = (linkage, name) -> name;
    private static final BiFunction<Linkage, String, String> DEMANGLE_ELF = (linkage, name) -> {
        if (linkage == Linkage.PRIVATE && name.startsWith(".L")) {
            return name.substring(2);
        }
        return name;
    };
    private static final BiFunction<Linkage, String, String> DEMANGLE_MIPS = (linkage, name) -> {
        if (linkage == Linkage.PRIVATE && name.startsWith("$")) {
            return name.substring(1);
        }
        return name;
    };
    private static final BiFunction<Linkage, String, String> DEMANGLE_MACHO = (linkage, name) -> {
        String demangled = name;
        if (demangled.startsWith("_")) {
            demangled = demangled.substring(1);
        }
        if (linkage == Linkage.LINKER_PRIVATE || linkage == Linkage.LINKER_PRIVATE_WEAK) {
            if (demangled.startsWith("l")) {
                demangled = demangled.substring(1);
            }
        } else if (linkage == Linkage.PRIVATE && demangled.startsWith("L")) {
            demangled = demangled.substring(1);
        }
        return demangled;
    };
    private static final BiFunction<Linkage, String, String> DEMANGLE_WINDOWS_COFF = (linkage, name) -> {
        if (linkage == Linkage.PRIVATE && name.startsWith(".L")) {
            return name.substring(2);
        }
        if (name.contains("@")) {
            throw new LLVMParserException("TODO: Functions with __stdcall, __fastcall, and __vectorcall have custom mangling that appends @N where N is the number of bytes used to pass parameters.");
        }
        if (name.startsWith("?")) {
            throw new LLVMParserException("TODO:C++ symbols starting with ? are not mangled in any way.");
        }
        return name;
    };
    private static final Pattern LAYOUT_MANGLING_PATTERN = Pattern.compile(".*m:(?<mangling>[\\w]).*");

    private static void demangle(List<? extends GlobalSymbol> list, BiFunction<Linkage, String, String> demangler) {
        for (GlobalSymbol globalSymbol : list) {
            String name = globalSymbol.getName();
            if (name.startsWith(MANGLED_PREFIX)) {
                name = demangler.apply(globalSymbol.getLinkage(), name.substring(MANGLED_PREFIX.length()));
            }
            globalSymbol.setName(name);
        }
    }

    public static void demangleGlobals(ModelModule model) {
        BiFunction<Linkage, String, String> demangler = SymbolNameMangling.getDemangler(model);
        SymbolNameMangling.demangle(model.getGlobalVariables(), demangler);
        SymbolNameMangling.demangle(model.getAliases(), demangler);
        SymbolNameMangling.demangle(model.getDeclaredFunctions(), demangler);
        SymbolNameMangling.demangle(model.getDefinedFunctions(), demangler);
    }

    private static BiFunction<Linkage, String, String> getDemangler(ModelModule module) {
        Matcher matcher = LAYOUT_MANGLING_PATTERN.matcher(module.getTargetDataLayout());
        if (matcher.matches()) {
            String mangling;
            switch (mangling = matcher.group("mangling")) {
                case "e": {
                    return DEMANGLE_ELF;
                }
                case "m": {
                    return DEMANGLE_MIPS;
                }
                case "o": {
                    return DEMANGLE_MACHO;
                }
                case "w": {
                    return DEMANGLE_WINDOWS_COFF;
                }
            }
            throw new LLVMParserException("Unsupported mangling in TargetDataLayout: " + mangling);
        }
        return DEFAULT_DEMANGLER;
    }
}

