/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Collection;
import java.util.Collections;

public final class ExtractValueInstruction
extends ValueInstruction {
    private SymbolImpl aggregate;
    private final Collection<Long> indices;

    private ExtractValueInstruction(Type type, Collection<Long> indices) {
        super(type);
        this.indices = indices;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getAggregate() {
        return this.aggregate;
    }

    public Collection<Long> getIndices() {
        return this.indices;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.aggregate == original) {
            this.aggregate = replacement;
        }
    }

    public static ExtractValueInstruction create(SymbolImpl aggreggate, Type type, int index) {
        ExtractValueInstruction inst = new ExtractValueInstruction(type, Collections.singletonList(Long.valueOf(index)));
        inst.aggregate = aggreggate;
        return inst;
    }

    public static ExtractValueInstruction fromSymbols(SymbolTable symbols, Type type, int aggregate, Collection<Long> indices) {
        ExtractValueInstruction inst = new ExtractValueInstruction(type, indices);
        inst.aggregate = symbols.getForwardReferenced(aggregate, inst);
        return inst;
    }
}

