/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.integer;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;

public final class IntegerConstant
extends AbstractConstant {
    private final long value;

    public IntegerConstant(Type type, long value) {
        super(type);
        this.value = value;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        try {
            if (this.getType().getBitSize() == 1L) {
                return this.value == 0L ? "false" : "true";
            }
        }
        catch (Type.TypeOverflowException typeOverflowException) {
            // empty catch block
        }
        return String.valueOf(this.value);
    }

    public static IntegerConstant createFromData(Type type, RecordBuffer buffer) {
        assert (type instanceof PrimitiveType || type instanceof VariableBitWidthType);
        try {
            long bits = type.getBitSize();
            long d = buffer.read();
            if (bits > 1L && bits < 64L) {
                d = IntegerConstant.extendSign(bits, d);
            }
            return new IntegerConstant(type, d);
        }
        catch (Type.TypeOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static long extendSign(long bits, long value) {
        long v = value;
        long mask = ((1L << (int)bits) - 1L ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        if ((v & mask) != 0L) {
            v |= mask;
        }
        return v;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        Type type = this.getType();
        long lVal = this.getValue();
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return CommonNodeFactory.createSimpleConstantNoArray(lVal != 0L, type);
                }
                case I8: {
                    return CommonNodeFactory.createSimpleConstantNoArray((byte)lVal, type);
                }
                case I16: {
                    return CommonNodeFactory.createSimpleConstantNoArray((short)lVal, type);
                }
                case I32: {
                    return CommonNodeFactory.createSimpleConstantNoArray((int)lVal, type);
                }
                case I64: {
                    return CommonNodeFactory.createSimpleConstantNoArray(lVal, type);
                }
            }
            throw new LLVMParserException("Unsupported IntegerConstant: " + String.valueOf(type));
        }
        if (type instanceof VariableBitWidthType) {
            return CommonNodeFactory.createSimpleConstantNoArray(lVal, type);
        }
        throw new LLVMParserException("Unsupported IntegerConstant: " + String.valueOf(type));
    }

    @Override
    public void addToBuffer(Constant.Buffer buffer, LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) throws Type.TypeOverflowException {
        if (this.getType() instanceof PrimitiveType) {
            switch (((PrimitiveType)this.getType()).getPrimitiveKind()) {
                case I1: {
                    buffer.getBuffer().put(this.value != 0L ? (byte)1 : 0);
                    return;
                }
                case I8: {
                    buffer.getBuffer().put((byte)this.value);
                    return;
                }
                case I16: {
                    buffer.getBuffer().putShort((short)this.value);
                    return;
                }
                case I32: {
                    buffer.getBuffer().putInt((int)this.value);
                    return;
                }
                case I64: {
                    buffer.getBuffer().putLong(this.value);
                    return;
                }
            }
        }
        super.addToBuffer(buffer, runtime, dataLayout, stackFactory);
    }
}

