/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.listeners.OperandBundleTags;
import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceFunction;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.enums.Visibility;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FunctionDefinition
extends FunctionSymbol
implements Constant,
MetadataAttachmentHolder {
    public static final InstructionBlock[] EMPTY = new InstructionBlock[0];
    private final List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
    private final OperandBundleTags operandBundleTags;
    private final Visibility visibility;
    private List<MDAttachment> mdAttachments = null;
    private SourceFunction sourceFunction = SourceFunction.DEFAULT;
    private InstructionBlock[] blocks = EMPTY;
    private int currentBlock = 0;

    private FunctionDefinition(FunctionType type, String name, Linkage linkage, Visibility visibility, AttributesCodeEntry paramAttr, int index, OperandBundleTags operandBundleTags) {
        super(type, name, linkage, paramAttr, index);
        this.visibility = visibility;
        this.operandBundleTags = operandBundleTags;
    }

    public FunctionDefinition(FunctionType type, Linkage linkage, Visibility visibility, AttributesCodeEntry paramAttr, int index, OperandBundleTags operandBundleTags) {
        this(type, "<anon>", linkage, visibility, paramAttr, index, operandBundleTags);
    }

    @Override
    public boolean hasAttachedMetadata() {
        return this.mdAttachments != null;
    }

    public OperandBundleTags getOperandBundleTags() {
        return this.operandBundleTags;
    }

    @Override
    public List<MDAttachment> getAttachedMetadata() {
        if (this.mdAttachments == null) {
            this.mdAttachments = new ArrayList<MDAttachment>(1);
        }
        return this.mdAttachments;
    }

    public String getSourceName() {
        String scopeName = this.sourceFunction.getName();
        return "<anon>".equals(scopeName) ? null : scopeName;
    }

    public String getDisplayName() {
        if (this.mdAttachments != null && this.mdAttachments.size() > 0) {
            for (MDAttachment mdAttachment : this.mdAttachments) {
                MDSubprogram mdSubprogram;
                if (!(mdAttachment.getValue() instanceof MDSubprogram) || !((mdSubprogram = (MDSubprogram)mdAttachment.getValue()).getName() instanceof MDString)) continue;
                return ((MDString)mdSubprogram.getName()).getString();
            }
        }
        return this.getSourceName();
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(FunctionVisitor visitor) {
        for (InstructionBlock block : this.blocks) {
            visitor.visit(block);
        }
    }

    public void allocateBlocks(int count) {
        this.blocks = new InstructionBlock[count];
        for (int i = 0; i < count; ++i) {
            this.blocks[i] = new InstructionBlock(i);
        }
    }

    public FunctionParameter createParameter(Type t) {
        int argIndex = this.parameters.size();
        AttributesGroup attrGroup = this.getParameterAttributesGroup(argIndex);
        FunctionParameter parameter = new FunctionParameter(t, attrGroup, argIndex);
        this.parameters.add(parameter);
        return parameter;
    }

    public InstructionBlock generateBlock() {
        return this.blocks[this.currentBlock++];
    }

    public InstructionBlock getBlock(long idx) {
        CompilerAsserts.neverPartOfCompilation();
        return this.blocks[(int)idx];
    }

    public List<InstructionBlock> getBlocks() {
        CompilerAsserts.neverPartOfCompilation();
        return Arrays.asList(this.blocks);
    }

    public List<FunctionParameter> getParameters() {
        CompilerAsserts.neverPartOfCompilation();
        return this.parameters;
    }

    public void nameBlock(int index, String argName) {
        this.blocks[index].setName(argName);
    }

    public void onAfterParse() {
        this.blocks = EMPTY;
        this.currentBlock = 0;
        this.mdAttachments = null;
        this.sourceFunction.clearLocals();
        this.parameters.clear();
    }

    public int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        CompilerAsserts.neverPartOfCompilation();
        return super.equals(obj);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("%s %s {...}", this.getType(), this.getName());
    }

    public LLVMSourceLocation getLexicalScope() {
        return this.sourceFunction != null ? this.sourceFunction.getLexicalScope() : null;
    }

    public SourceFunction getSourceFunction() {
        return this.sourceFunction;
    }

    public void setSourceFunction(SourceFunction sourceFunction) {
        this.sourceFunction = sourceFunction;
    }

    @Override
    public boolean isExported() {
        return Linkage.isExported(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isOverridable() {
        return Linkage.isOverridable(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isExternal() {
        return Linkage.isExternal(this.getLinkage());
    }

    @Override
    public boolean isExternalWeak() {
        return this.getLinkage() == Linkage.EXTERN_WEAK;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMFunction value = runtime.lookupFunction(this.getName());
        return CommonNodeFactory.createLiteral(value, this.getType());
    }
}

