/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamedLocation;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDSubprogram
extends MDNamedLocation
implements MDBaseNode {
    private final boolean isLocalToUnit;
    private final boolean isDefinedInCompileUnit;
    private final long scopeLine;
    private final long virtuality;
    private final long virtualIndex;
    private final long flags;
    private final boolean isOptimized;
    private MDBaseNode displayName;
    private MDBaseNode linkageName;
    private MDBaseNode type;
    private MDBaseNode containingType;
    private MDBaseNode templateParams;
    private MDBaseNode declaration;
    private MDBaseNode function;
    private MDBaseNode compileUnit;
    private static final int ARGINDEX_32_SCOPE = 2;
    private static final int ARGINDEX_32_NAME = 3;
    private static final int ARGINDEX_32_DISPLAYNAME = 4;
    private static final int ARGINDEX_32_LINKAGENAME = 5;
    private static final int ARGINDEX_32_FILE = 6;
    private static final int ARGINDEX_32_LINE = 7;
    private static final int ARGINDEX_32_TYPE = 8;
    private static final int ARGINDEX_32_LOCALTOUNIT = 9;
    private static final int ARGINDEX_32_DEFINEDINCOMPILEUNIT = 10;
    private static final int ARGINDEX_32_VIRTUALITY = 11;
    private static final int ARGINDEX_32_VIRTUALINDEX = 12;
    private static final int ARGINDEX_32_CONTAININGTYPE = 13;
    private static final int ARGINDEX_32_FLAGS = 14;
    private static final int ARGINDEX_3_OPTIMIZED = 15;
    private static final int ARGINDEX_32_FN = 16;
    private static final int ARGINDEX_32_TEMPLATEPARAMS = 17;
    private static final int ARGINDEX_32_DECLARATION = 18;
    private static final int ARGINDEX_32_SCOPELINE = 20;

    private MDSubprogram(long line, boolean isLocalToUnit, boolean isDefinedInCompileUnit, long scopeLine, long virtuality, long virtualIndex, long flags, boolean isOptimized) {
        super(line);
        this.isLocalToUnit = isLocalToUnit;
        this.isDefinedInCompileUnit = isDefinedInCompileUnit;
        this.scopeLine = scopeLine;
        this.virtuality = virtuality;
        this.virtualIndex = virtualIndex;
        this.flags = flags;
        this.isOptimized = isOptimized;
        this.displayName = MDVoidNode.INSTANCE;
        this.linkageName = MDVoidNode.INSTANCE;
        this.type = MDVoidNode.INSTANCE;
        this.containingType = MDVoidNode.INSTANCE;
        this.templateParams = MDVoidNode.INSTANCE;
        this.declaration = MDVoidNode.INSTANCE;
        this.function = MDVoidNode.INSTANCE;
        this.compileUnit = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getDisplayName() {
        return this.displayName;
    }

    public MDBaseNode getLinkageName() {
        return this.linkageName;
    }

    public MDBaseNode getType() {
        return this.type;
    }

    public boolean isLocalToUnit() {
        return this.isLocalToUnit;
    }

    public boolean isDefinedInCompileUnit() {
        return this.isDefinedInCompileUnit;
    }

    public long getScopeLine() {
        return this.scopeLine;
    }

    public MDBaseNode getContainingType() {
        return this.containingType;
    }

    public long getVirtuality() {
        return this.virtuality;
    }

    public long getVirtualIndex() {
        return this.virtualIndex;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public MDBaseNode getTemplateParams() {
        return this.templateParams;
    }

    public MDBaseNode getDeclaration() {
        return this.declaration;
    }

    public void setFunction(MDBaseNode function) {
        this.function = function;
    }

    public MDBaseNode getFunction() {
        return this.function;
    }

    public MDBaseNode getCompileUnit() {
        return this.compileUnit;
    }

    public void setCompileUnit(MDBaseNode compileUnit) {
        this.compileUnit = compileUnit;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.displayName == oldValue) {
            this.displayName = newValue;
        }
        if (this.linkageName == oldValue) {
            this.linkageName = newValue;
        }
        if (this.type == oldValue) {
            this.type = newValue;
        }
        if (this.containingType == oldValue) {
            this.containingType = newValue;
        }
        if (this.templateParams == oldValue) {
            this.templateParams = newValue;
        }
        if (this.declaration == oldValue) {
            this.declaration = newValue;
        }
        if (this.function == oldValue) {
            this.function = newValue;
        }
        if (this.compileUnit == oldValue) {
            this.compileUnit = newValue;
        }
    }

    public static MDSubprogram createNewFormat(long[] args, MetadataValueList md) {
        long virtuality;
        boolean optimized;
        boolean definedInCompileUnit;
        boolean localToCompileUnit;
        boolean hasDistinctFlags;
        boolean bl = hasDistinctFlags = (args[0] & 4L) != 0L;
        if (hasDistinctFlags) {
            long newFormatFlags = args[9];
            localToCompileUnit = (newFormatFlags & 4L) != 0L;
            definedInCompileUnit = (newFormatFlags & 8L) != 0L;
            optimized = (newFormatFlags & 0x10L) != 0L;
            virtuality = newFormatFlags & 3L;
        } else {
            localToCompileUnit = args[7] == 1L;
            definedInCompileUnit = args[8] == 1L;
            optimized = args[14] == 1L;
            virtuality = args[11];
        }
        boolean hasUnit = (args[0] & 2L) != 0L;
        boolean hasFunction = false;
        int offsetA = 0;
        int offsetB = 0;
        if (!hasDistinctFlags) {
            offsetA = 2;
            offsetB = 2;
            if (args.length != 19) {
                hasFunction = !hasUnit;
                ++offsetB;
            }
        }
        long line = args[5];
        long scopeLine = args[7 + offsetA];
        long virtualIndex = args[10 + offsetA];
        long flags = args[11 + offsetA];
        MDSubprogram subprogram = new MDSubprogram(line, localToCompileUnit, definedInCompileUnit, scopeLine, virtuality, virtualIndex, flags, optimized);
        subprogram.setScope(md.getNullable(args[1], subprogram));
        subprogram.setName(md.getNullable(args[2], subprogram));
        subprogram.linkageName = md.getNullable(args[3], subprogram);
        subprogram.setFile(md.getNullable(args[4], subprogram));
        subprogram.type = md.getNullable(args[6], subprogram);
        subprogram.containingType = md.getNullable(args[8 + offsetA], subprogram);
        subprogram.templateParams = md.getNullable(args[13 + offsetB], subprogram);
        subprogram.declaration = md.getNullable(args[14 + offsetB], subprogram);
        if (hasUnit) {
            subprogram.compileUnit = md.getNullable(args[12 + offsetB], subprogram);
        }
        if (hasFunction) {
            subprogram.function = md.getNullable(args[12 + offsetB], subprogram);
        }
        return subprogram;
    }

    public static MDSubprogram create32(long[] args, Metadata md) {
        long line = ParseUtil.asInt(args, 7, md);
        boolean localToCompileUnit = ParseUtil.asBoolean(args, 9, md);
        boolean definedInCompileUnit = ParseUtil.asBoolean(args, 10, md);
        long virtuality = ParseUtil.asInt(args, 11, md);
        long virtualIndex = ParseUtil.asInt(args, 12, md);
        long flags = ParseUtil.asInt(args, 14, md);
        boolean optimized = ParseUtil.asBoolean(args, 15, md);
        long scopeLine = ParseUtil.asLong(args, 20, md);
        MDSubprogram subprogram = new MDSubprogram(line, localToCompileUnit, definedInCompileUnit, scopeLine, virtuality, virtualIndex, flags, optimized);
        subprogram.setScope(ParseUtil.resolveReference(args, 2, subprogram, md));
        subprogram.setName(ParseUtil.resolveReference(args, 3, subprogram, md));
        subprogram.displayName = ParseUtil.resolveReference(args, 4, subprogram, md);
        subprogram.linkageName = ParseUtil.resolveReference(args, 5, subprogram, md);
        subprogram.setFile(ParseUtil.resolveReference(args, 6, subprogram, md));
        subprogram.type = ParseUtil.resolveReference(args, 8, subprogram, md);
        subprogram.containingType = ParseUtil.resolveReference(args, 13, subprogram, md);
        subprogram.templateParams = ParseUtil.resolveReference(args, 17, subprogram, md);
        subprogram.declaration = ParseUtil.resolveReference(args, 18, subprogram, md);
        subprogram.function = ParseUtil.resolveSymbol(args, 16, md);
        return subprogram;
    }
}

