/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.scanner.BitStream;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class MDString
implements MDBaseNode {
    private final String s;
    private static final int STRINGS_ARGINDEX_COUNT = 0;
    private static final int STRINGS_ARGINDEX_STROFFSET = 1;
    private static final int STRINGS_ARGOFFSET_BLOB = 2;
    private static final int STRINGS_SIZE_WIDTH = 6;

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    private MDString(String s) {
        this.s = s;
    }

    public String getString() {
        return this.s;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
    }

    public String toString() {
        return String.format("!\"%s\"", this.s);
    }

    public static MDString create(RecordBuffer buffer) {
        return new MDString(buffer.readUnicodeString());
    }

    public static MDString[] createFromBlob(long[] args) {
        long count = args[0];
        MDString[] strings = new MDString[Math.toIntExact(count)];
        BitStream blob = BitStream.createFromBlob(args, 2);
        long strOffset = args[1] * 8L;
        long lenOffset = 0L;
        int i = 0;
        while ((long)i < count) {
            long size = blob.readVBR(lenOffset, 6);
            lenOffset += BitStream.widthVBR(size, 6L);
            byte[] bytes = new byte[(int)size];
            int j = 0;
            while (size > 0L) {
                bytes[j++] = (byte)blob.read(strOffset, 8);
                --size;
                strOffset += 8L;
            }
            strings[i] = new MDString(new String(bytes));
            ++i;
        }
        return strings;
    }

    public static String getIfInstance(MDBaseNode strNode) {
        if (strNode instanceof MDString) {
            return ((MDString)strNode).getString();
        }
        return null;
    }
}

