/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.llvm.parser.elf.ElfDynamicSection;
import com.oracle.truffle.llvm.parser.elf.ElfHeader;
import com.oracle.truffle.llvm.parser.elf.ElfReader;
import com.oracle.truffle.llvm.parser.elf.ElfSectionHeaderTable;
import org.graalvm.polyglot.io.ByteSequence;

public final class ElfFile {
    private final ElfHeader header;
    private final ElfSectionHeaderTable sectionHeaderTable;
    private final ElfDynamicSection dynamicSection;

    private ElfFile(ElfHeader header, ElfSectionHeaderTable sectionHeaderTable, ElfDynamicSection dynamicSection) {
        this.header = header;
        this.sectionHeaderTable = sectionHeaderTable;
        this.dynamicSection = dynamicSection;
    }

    public static ElfFile create(ByteSequence data) {
        ElfReader reader = ElfReader.create(data);
        ElfHeader header = ElfHeader.create(reader);
        ElfSectionHeaderTable sectionHeaderTable = ElfSectionHeaderTable.create(header, reader);
        ElfDynamicSection dynamicSection = ElfDynamicSection.create(sectionHeaderTable, reader);
        return new ElfFile(header, sectionHeaderTable, dynamicSection);
    }

    public ElfHeader getHeader() {
        return this.header;
    }

    public ElfDynamicSection getDynamicSection() {
        return this.dynamicSection;
    }

    public ElfSectionHeaderTable getSectionHeaderTable() {
        return this.sectionHeaderTable;
    }
}

