/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.coff;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.coff.CoffFile;
import com.oracle.truffle.llvm.parser.coff.ExportTable;
import com.oracle.truffle.llvm.parser.coff.ImageImportData;
import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.io.ByteSequence;

public final class PEFile {
    private static final short IMAGE_DOS_SIGNATURE = 23117;
    private static final int IMAGE_NT_SIGNATURE = 17744;
    private static final int OFFSET_TO_PE_SIGNATURE = 60;
    private final CoffFile coffFile;
    private ImageImportData importData = null;
    private ExportTable exportTable = null;

    private PEFile(CoffFile coffFile) {
        this.coffFile = coffFile;
        this.loadImportData();
        this.loadExportData();
    }

    public CoffFile getCoffFile() {
        return this.coffFile;
    }

    public static PEFile create(Source source, ByteSequence bytes) {
        ObjectFileReader reader = new ObjectFileReader(bytes, true);
        short machine = reader.getShort();
        if (machine != 23117) {
            throw new LLVMParserException("Invalid MS DOS file!");
        }
        reader.setPosition(60);
        int peOffset = reader.getInt();
        reader.setPosition(peOffset);
        int reSignature = reader.getInt();
        if (reSignature != 17744) {
            throw new LLVMParserException("No PE Signature found in MS DOS Executable!");
        }
        return new PEFile(CoffFile.create(source, bytes, reader));
    }

    public CoffFile.ImageOptionNT64Header getOptionHeader() {
        CoffFile.ImageOptionHeader header = this.coffFile.getOptionHeader();
        if (header == null) {
            return null;
        }
        if (header instanceof CoffFile.ImageOptionNT64Header) {
            return (CoffFile.ImageOptionNT64Header)header;
        }
        throw new LLVMParserException(String.format("Unsupported PE File Coff option header: %s.", header.getClass().toString()));
    }

    private ImageDataDirectorySection getImageDataDirectory(CoffFile.ImageOptionNT64Header.ImageDataIndex optionHeaderIndex, String sectionName) {
        CoffFile.ImageSectionHeader imageSection;
        CoffFile.ImageOptionNT64Header header = this.getOptionHeader();
        if (header != null) {
            CoffFile.ImageDataDirectory importDirectory = header.getDirectory(optionHeaderIndex);
            if (importDirectory.getSize() == 0) {
                return null;
            }
            if (importDirectory != null) {
                CoffFile.ImageSectionHeader sectionHeader = this.coffFile.lookupOffset(importDirectory.getVirtualAddress());
                return new ImageDataDirectorySection(sectionHeader, importDirectory.getVirtualAddress() - sectionHeader.virtualAddress, importDirectory.getSize());
            }
        }
        if ((imageSection = this.coffFile.getSection(sectionName)) != null) {
            return new ImageDataDirectorySection(imageSection);
        }
        return null;
    }

    private ObjectFileReader getImageData(CoffFile.ImageOptionNT64Header.ImageDataIndex optionHeaderIndex, String sectionName) {
        ImageDataDirectorySection dataDirectorySection = this.getImageDataDirectory(optionHeaderIndex, sectionName);
        if (dataDirectorySection != null) {
            return dataDirectorySection.getReader(this.coffFile);
        }
        return null;
    }

    private ObjectFileReader getImportDataReader() {
        return this.getImageData(CoffFile.ImageOptionNT64Header.ImageDataIndex.ImportTable, ".idata");
    }

    private void loadImportData() {
        ObjectFileReader reader = this.getImportDataReader();
        this.importData = reader == null ? null : ImageImportData.create(this.coffFile, reader);
    }

    private void loadExportData() {
        ImageDataDirectorySection section = this.getImageDataDirectory(CoffFile.ImageOptionNT64Header.ImageDataIndex.ExportTable, ".edata");
        this.exportTable = section == null ? ExportTable.EMPTY : ExportTable.create(this.coffFile, section);
    }

    public List<String> getImportLibraries() {
        ArrayList<String> libraries = new ArrayList<String>();
        if (this.importData == null) {
            return libraries;
        }
        for (ImageImportData.ImageImportDescriptor importDescriptor : this.importData.directoryTable) {
            libraries.add(importDescriptor.name);
        }
        return libraries;
    }

    public ExportTable getExportTable() {
        return this.exportTable;
    }

    public static final class ImageDataDirectorySection {
        final CoffFile.ImageSectionHeader header;
        final int offset;
        final int length;

        private ImageDataDirectorySection(CoffFile.ImageSectionHeader header) {
            this(header, 0, header.virtualSize);
        }

        private ImageDataDirectorySection(CoffFile.ImageSectionHeader header, int offset, int length) {
            this.header = header;
            this.offset = offset;
            this.length = length;
        }

        public boolean isRVAInBounds(int rva) {
            return rva >= this.header.virtualAddress + this.offset && rva <= this.header.virtualAddress + this.offset + this.length;
        }

        public ObjectFileReader getReader(CoffFile file) {
            ObjectFileReader reader = file.getSectionReader(this.header);
            reader.setPosition(this.offset);
            return reader;
        }
    }
}

