/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=ManagedMemMoveHelperNode.class)
final class ManagedMemMoveHelperNodeGen
extends ManagedMemMoveHelperNode
implements GenerateAOT.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private ManagedMemMoveHelperNodeGen(ManagedMemMoveHelperNode.MemReadHelperNode read, ManagedMemMoveHelperNode.MemWriteHelperNode write) {
        super(read, write);
    }

    @Override
    Object execute(LLVMPointer arg0Value, LLVMPointer arg1Value, int arg2Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }
        if ((state_0 & 0xA) != 0) {
            if ((state_0 & 2) != 0) {
                try {
                    return this.moveUnitLong(arg0Value, arg1Value, arg2Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    return ex.getResult();
                }
            }
            if ((state_0 & 8) != 0) {
                return this.moveUnitGeneric(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, LLVMPointer arg1Value, int arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((state_0 & 8) == 0 && (state_0 & 4) == 0) {
            this.state_0_ = state_0 |= 2;
            try {
                return this.moveUnitLong(arg0Value, arg1Value, arg2Value);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return ex.getResult();
            }
        }
        state_0 &= 0xFFFFFFFD;
        this.state_0_ = state_0 |= 8;
        return this.moveUnitGeneric(arg0Value, arg1Value, arg2Value);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xA) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xA & (state_0 & 0xA) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ &= 0xFFFFFFFD;
        this.state_0_ |= 8;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static ManagedMemMoveHelperNode create(ManagedMemMoveHelperNode.MemReadHelperNode read, ManagedMemMoveHelperNode.MemWriteHelperNode write) {
        return new ManagedMemMoveHelperNodeGen(read, write);
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI64.class)
    static final class MemWriteI64NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI64
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemWriteI64NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 2) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doLong(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.doManaged(arg0Value_, arg1Value, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 2) != 0) {
                    this.doLong(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 4) != 0) {
                    this.doManaged(arg0Value_, arg1Value, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 4) == 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    this.doLong(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ &= 0xFFFFFFFD;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteI64 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI64NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI32.class)
    static final class MemWriteI32NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI32
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemWriteI32NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteI32 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI32NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI16.class)
    static final class MemWriteI16NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI16
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemWriteI16NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteI16 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI16NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI8.class)
    static final class MemWriteI8NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI8
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemWriteI8NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    this.doManaged(arg0Value_, arg1Value_, arg2Value);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteI8 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI8NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteNative.class)
    static final class MemWriteNativeNodeGen
    extends ManagedMemMoveHelperNode.MemWriteNative
    implements GenerateAOT.Provider {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private NativeSupportSharedWrapper nativeSupport;

        private MemWriteNativeNodeGen() {
        }

        @Override
        void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 0x1FE) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 0x1E) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    if ((state_0 & 2) != 0 && arg2Value == 1) {
                        this.doNativeI8(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && arg2Value == 2) {
                        this.doNativeI16(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if ((state_0 & 8) != 0 && arg2Value == 4) {
                        this.doNativeI32(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if ((state_0 & 0x10) != 0 && arg2Value == 8) {
                        this.doNativeI64(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
                if ((state_0 & 0x1E0) != 0 && LLVMTypes.isPointer(arg1Value)) {
                    NativeSupportSharedWrapper nativeSupport_wrapper;
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if ((state_0 & 0x20) != 0 && (nativeSupport_wrapper = this.nativeSupport) != null && arg2Value == 1) {
                        this.doObjectI8(arg0Value_, arg1Value_, arg2Value, nativeSupport_wrapper.delegate);
                        return;
                    }
                    if ((state_0 & 0x40) != 0 && (nativeSupport_wrapper = this.nativeSupport) != null && arg2Value == 2) {
                        this.doObjectI16(arg0Value_, arg1Value_, arg2Value, nativeSupport_wrapper.delegate);
                        return;
                    }
                    if ((state_0 & 0x80) != 0 && (nativeSupport_wrapper = this.nativeSupport) != null && arg2Value == 4) {
                        this.doObjectI32(arg0Value_, arg1Value_, arg2Value, nativeSupport_wrapper.delegate);
                        return;
                    }
                    if ((state_0 & 0x100) != 0 && (nativeSupport_wrapper = this.nativeSupport) != null && arg2Value == 8) {
                        this.doObjectI64(arg0Value_, arg1Value_, arg2Value, nativeSupport_wrapper.delegate);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 2) != 0 && arg2Value == 1) {
                    this.doNativeI8(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 4) != 0 && arg2Value == 2) {
                    this.doNativeI16(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 8) != 0 && arg2Value == 4) {
                    this.doNativeI32(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                if ((state_0 & 0x10) != 0 && arg2Value == 8) {
                    this.doNativeI64(arg0Value_, arg1Value, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    if (arg2Value == 1) {
                        this.state_0_ = state_0 |= 2;
                        this.doNativeI8(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if (arg2Value == 2) {
                        this.state_0_ = state_0 |= 4;
                        this.doNativeI16(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if (arg2Value == 4) {
                        this.state_0_ = state_0 |= 8;
                        this.doNativeI32(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                    if (arg2Value == 8) {
                        this.state_0_ = state_0 |= 0x10;
                        this.doNativeI64(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if (arg2Value == 1) {
                        NativeSupportSharedWrapper nativeSupport_wrapper = this.nativeSupport;
                        LLVMNativePointerSupport nativeSupport_ = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
                        if (nativeSupport_wrapper == null) {
                            nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                            VarHandle.storeStoreFence();
                            nativeSupport_wrapper.delegate = nativeSupport_;
                            VarHandle.storeStoreFence();
                            this.nativeSupport = nativeSupport_wrapper;
                        }
                        this.state_0_ = state_0 |= 0x20;
                        this.doObjectI8(arg0Value_, arg1Value_, arg2Value, nativeSupport_);
                        return;
                    }
                    if (arg2Value == 2) {
                        NativeSupportSharedWrapper nativeSupport_wrapper = this.nativeSupport;
                        LLVMNativePointerSupport nativeSupport_1 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
                        if (nativeSupport_wrapper == null) {
                            nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                            VarHandle.storeStoreFence();
                            nativeSupport_wrapper.delegate = nativeSupport_1;
                            VarHandle.storeStoreFence();
                            this.nativeSupport = nativeSupport_wrapper;
                        }
                        this.state_0_ = state_0 |= 0x40;
                        this.doObjectI16(arg0Value_, arg1Value_, arg2Value, nativeSupport_1);
                        return;
                    }
                    if (arg2Value == 4) {
                        NativeSupportSharedWrapper nativeSupport_wrapper = this.nativeSupport;
                        LLVMNativePointerSupport nativeSupport_2 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
                        if (nativeSupport_wrapper == null) {
                            nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                            VarHandle.storeStoreFence();
                            nativeSupport_wrapper.delegate = nativeSupport_2;
                            VarHandle.storeStoreFence();
                            this.nativeSupport = nativeSupport_wrapper;
                        }
                        this.state_0_ = state_0 |= 0x80;
                        this.doObjectI32(arg0Value_, arg1Value_, arg2Value, nativeSupport_2);
                        return;
                    }
                    if (arg2Value == 8) {
                        NativeSupportSharedWrapper nativeSupport_wrapper = this.nativeSupport;
                        LLVMNativePointerSupport nativeSupport_3 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
                        if (nativeSupport_wrapper == null) {
                            nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                            VarHandle.storeStoreFence();
                            nativeSupport_wrapper.delegate = nativeSupport_3;
                            VarHandle.storeStoreFence();
                            this.nativeSupport = nativeSupport_wrapper;
                        }
                        this.state_0_ = state_0 |= 0x100;
                        this.doObjectI64(arg0Value_, arg1Value_, arg2Value, nativeSupport_3);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FE & (state_0 & 0x1FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            NativeSupportSharedWrapper nativeSupport_wrapper = this.nativeSupport;
            LLVMNativePointerSupport nativeSupport_ = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
            if (nativeSupport_wrapper == null) {
                nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                VarHandle.storeStoreFence();
                nativeSupport_wrapper.delegate = nativeSupport_;
                VarHandle.storeStoreFence();
                this.nativeSupport = nativeSupport_wrapper;
            }
            this.state_0_ |= 0x20;
            nativeSupport_wrapper = this.nativeSupport;
            LLVMNativePointerSupport nativeSupport_1 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
            if (nativeSupport_wrapper == null) {
                nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                VarHandle.storeStoreFence();
                nativeSupport_wrapper.delegate = nativeSupport_1;
                VarHandle.storeStoreFence();
                this.nativeSupport = nativeSupport_wrapper;
            }
            this.state_0_ |= 0x40;
            nativeSupport_wrapper = this.nativeSupport;
            LLVMNativePointerSupport nativeSupport_2 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
            if (nativeSupport_wrapper == null) {
                nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                VarHandle.storeStoreFence();
                nativeSupport_wrapper.delegate = nativeSupport_2;
                VarHandle.storeStoreFence();
                this.nativeSupport = nativeSupport_wrapper;
            }
            this.state_0_ |= 0x80;
            nativeSupport_wrapper = this.nativeSupport;
            LLVMNativePointerSupport nativeSupport_3 = nativeSupport_wrapper != null ? nativeSupport_wrapper.delegate : (LLVMNativePointerSupport)this.insert(LLVMNativePointerSupport.create());
            if (nativeSupport_wrapper == null) {
                nativeSupport_wrapper = (NativeSupportSharedWrapper)this.insert(new NativeSupportSharedWrapper());
                VarHandle.storeStoreFence();
                nativeSupport_wrapper.delegate = nativeSupport_3;
                VarHandle.storeStoreFence();
                this.nativeSupport = nativeSupport_wrapper;
            }
            this.state_0_ |= 0x100;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.nativeSupport = null;
            this.nativeSupport = null;
            this.nativeSupport = null;
            this.nativeSupport = null;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteNative create() {
            return new MemWriteNativeNodeGen();
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemWriteNative getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteNative.class)
        @DenyReplace
        private static final class NativeSupportSharedWrapper
        extends Node {
            @Node.Child
            private LLVMNativePointerSupport delegate;

            private NativeSupportSharedWrapper() {
            }
        }

        @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteNative.class)
        @DenyReplace
        private static final class Uncached
        extends ManagedMemMoveHelperNode.MemWriteNative {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void executeGeneric(LLVMPointer arg0Value, Object arg1Value, int arg2Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        if (arg2Value == 1) {
                            this.doNativeI8(arg0Value_, arg1Value_, arg2Value);
                            return;
                        }
                        if (arg2Value == 2) {
                            this.doNativeI16(arg0Value_, arg1Value_, arg2Value);
                            return;
                        }
                        if (arg2Value == 4) {
                            this.doNativeI32(arg0Value_, arg1Value_, arg2Value);
                            return;
                        }
                        if (arg2Value == 8) {
                            this.doNativeI64(arg0Value_, arg1Value_, arg2Value);
                            return;
                        }
                    }
                    if (LLVMTypes.isPointer(arg1Value)) {
                        LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                        if (arg2Value == 1) {
                            this.doObjectI8(arg0Value_, arg1Value_, arg2Value, LLVMNativePointerSupport.getUncached());
                            return;
                        }
                        if (arg2Value == 2) {
                            this.doObjectI16(arg0Value_, arg1Value_, arg2Value, LLVMNativePointerSupport.getUncached());
                            return;
                        }
                        if (arg2Value == 4) {
                            this.doObjectI32(arg0Value_, arg1Value_, arg2Value, LLVMNativePointerSupport.getUncached());
                            return;
                        }
                        if (arg2Value == 8) {
                            this.doObjectI64(arg0Value_, arg1Value_, arg2Value, LLVMNativePointerSupport.getUncached());
                            return;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg2Value == 1) {
                        this.doNativeI8(arg0Value_, arg1Value, arg2Value);
                        return;
                    }
                    if (arg2Value == 2) {
                        this.doNativeI16(arg0Value_, arg1Value, arg2Value);
                        return;
                    }
                    if (arg2Value == 4) {
                        this.doNativeI32(arg0Value_, arg1Value, arg2Value);
                        return;
                    }
                    if (arg2Value == 8) {
                        this.doNativeI64(arg0Value_, arg1Value, arg2Value);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI64.class)
    static final class MemReadI64NodeGen
    extends ManagedMemMoveHelperNode.MemReadI64
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemReadI64NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0xA) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 2) != 0) {
                    try {
                        return this.doLong(arg0Value_, arg1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        return ex.getResult();
                    }
                }
                if ((state_0 & 8) != 0) {
                    return this.doGeneric(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 8) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(arg0Value, arg1Value));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                try {
                    return this.doLong(arg0Value_, arg1Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    return LLVMTypesGen.expectLong(ex.getResult());
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 8) == 0 && (state_0 & 4) == 0) {
                    this.state_0_ = state_0 |= 2;
                    try {
                        return this.doLong(arg0Value_, arg1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        return ex.getResult();
                    }
                }
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 8;
                return this.doGeneric(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xA) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xA & (state_0 & 0xA) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ &= 0xFFFFFFFD;
            this.state_0_ |= 8;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadI64 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI64NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI32.class)
    static final class MemReadI32NodeGen
    extends ManagedMemMoveHelperNode.MemReadI32
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemReadI32NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_0_ = state_0 |= 2;
                return this.doManaged(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadI32 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI32NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI16.class)
    static final class MemReadI16NodeGen
    extends ManagedMemMoveHelperNode.MemReadI16
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemReadI16NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_0_ = state_0 |= 2;
                return this.doManaged(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadI16 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI16NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI8.class)
    static final class MemReadI8NodeGen
    extends ManagedMemMoveHelperNode.MemReadI8
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemReadI8NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doDefault(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doDefault(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_0_ = state_0 |= 2;
                return this.doDefault(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadI8 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI8NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadNative.class)
    static final class MemReadNativeNodeGen
    extends ManagedMemMoveHelperNode.MemReadNative
    implements GenerateAOT.Provider {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private MemReadNativeNodeGen() {
        }

        @Override
        Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 2) != 0 && arg1Value == 1) {
                    return this.doNativeI8(arg0Value_, arg1Value);
                }
                if ((state_0 & 4) != 0 && arg1Value == 2) {
                    return this.doNativeI16(arg0Value_, arg1Value);
                }
                if ((state_0 & 8) != 0 && arg1Value == 4) {
                    return this.doNativeI32(arg0Value_, arg1Value);
                }
                if ((state_0 & 0x10) != 0 && arg1Value == 8) {
                    return this.doNativeI64(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state_0 & 2) != 0 && arg1Value == 1) {
                    return this.doNativeI8(arg0Value_, arg1Value);
                }
                if ((state_0 & 4) != 0 && arg1Value == 2) {
                    return this.doNativeI16(arg0Value_, arg1Value);
                }
                if ((state_0 & 8) != 0 && arg1Value == 4) {
                    return this.doNativeI32(arg0Value_, arg1Value);
                }
                if ((state_0 & 0x10) != 0 && arg1Value == 8) {
                    return this.doNativeI64(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (arg1Value == 1) {
                    this.state_0_ = state_0 |= 2;
                    return this.doNativeI8(arg0Value_, arg1Value);
                }
                if (arg1Value == 2) {
                    this.state_0_ = state_0 |= 4;
                    return this.doNativeI16(arg0Value_, arg1Value);
                }
                if (arg1Value == 4) {
                    this.state_0_ = state_0 |= 8;
                    return this.doNativeI32(arg0Value_, arg1Value);
                }
                if (arg1Value == 8) {
                    this.state_0_ = state_0 |= 0x10;
                    return this.doNativeI64(arg0Value_, arg1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1E) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1E & (state_0 & 0x1E) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadNative create() {
            return new MemReadNativeNodeGen();
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.MemReadNative getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadNative.class)
        @DenyReplace
        private static final class Uncached
        extends ManagedMemMoveHelperNode.MemReadNative {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object executeGeneric(LLVMPointer arg0Value, int arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value == 1) {
                        return this.doNativeI8(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 2) {
                        return this.doNativeI16(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 4) {
                        return this.doNativeI32(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 8) {
                        return this.doNativeI64(arg0Value_, arg1Value);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(LLVMPointer arg0Value, int arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value == 1) {
                        return this.doNativeI8(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 2) {
                        return this.doNativeI16(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 4) {
                        return this.doNativeI32(arg0Value_, arg1Value);
                    }
                    if (arg1Value == 8) {
                        return this.doNativeI64(arg0Value_, arg1Value);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.UnitSizeNode.class)
    static final class UnitSizeNodeGen
    extends ManagedMemMoveHelperNode.UnitSizeNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private UnitSizeNodeGen() {
        }

        private boolean fallbackGuard_(int state_0, ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            return (state_0 & 0x10) != 0 || !arg0Value.supportsUnitSize(1) || !this.isDivisible(arg1Value, 1);
        }

        @Override
        int execute(ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0x3E) != 0) {
                if ((state_0 & 2) != 0 && arg0Value.supportsUnitSize(8) && this.isDivisible(arg1Value, 8)) {
                    return this.do8(arg0Value, arg1Value);
                }
                if ((state_0 & 4) != 0 && arg0Value.supportsUnitSize(4) && this.isDivisible(arg1Value, 4)) {
                    return this.do4(arg0Value, arg1Value);
                }
                if ((state_0 & 8) != 0 && arg0Value.supportsUnitSize(2) && this.isDivisible(arg1Value, 2)) {
                    return this.do2(arg0Value, arg1Value);
                }
                if ((state_0 & 0x10) != 0 && arg0Value.supportsUnitSize(1) && this.isDivisible(arg1Value, 1)) {
                    return this.do1(arg0Value, arg1Value);
                }
                if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    return this.doError(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 0x1C) == 0 && arg0Value.supportsUnitSize(8) && this.isDivisible(arg1Value, 8)) {
                this.state_0_ = state_0 |= 2;
                return this.do8(arg0Value, arg1Value);
            }
            if ((state_0 & 0x18) == 0 && arg0Value.supportsUnitSize(4) && this.isDivisible(arg1Value, 4)) {
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return this.do4(arg0Value, arg1Value);
            }
            if ((state_0 & 0x10) == 0 && arg0Value.supportsUnitSize(2) && this.isDivisible(arg1Value, 2)) {
                state_0 &= 0xFFFFFFF9;
                this.state_0_ = state_0 |= 8;
                return this.do2(arg0Value, arg1Value);
            }
            if (arg0Value.supportsUnitSize(1) && this.isDivisible(arg1Value, 1)) {
                state_0 &= 0xFFFFFFF1;
                this.state_0_ = state_0 |= 0x10;
                return this.do1(arg0Value, arg1Value);
            }
            this.state_0_ = state_0 |= 0x20;
            return this.doError(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3E) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x3E & (state_0 & 0x3E) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ &= 0xFFFFFFF1;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedMemMoveHelperNode.UnitSizeNode create() {
            return new UnitSizeNodeGen();
        }
    }
}

