/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

public abstract class LLVMAArch64_NeonNodes {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMAArch64_Uqsub
    extends LLVMBuiltin {
        final int vectorSize;

        public LLVMAArch64_Uqsub(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        protected LLVMI8Vector doOp(LLVMI8Vector v1, LLVMI8Vector v2) {
            assert (v1.getLength() == v2.getLength());
            assert (v1.getLength() == this.vectorSize);
            byte[] result = new byte[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                result[i] = LLVMAArch64_Uqsub.clampUnsigned(Byte.toUnsignedInt(v1.getValue(i)) - Byte.toUnsignedInt(v2.getValue(i)));
            }
            return LLVMI8Vector.create(result);
        }

        private static byte clampUnsigned(int value) {
            if (value > 255) {
                return -1;
            }
            if (value < 0) {
                return 0;
            }
            return (byte)value;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAArch64_Umaxv
    extends LLVMBuiltin {
        final int vectorSize;

        public LLVMAArch64_Umaxv(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        protected int doOp(LLVMI8Vector v) {
            assert (v.getLength() == this.vectorSize);
            int max = 0;
            for (int i = 0; i < this.vectorSize; ++i) {
                int val = Byte.toUnsignedInt(v.getValue(i));
                max = Math.max(max, val);
            }
            return max;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMAArch64_Tbl2
    extends LLVMBuiltin {
        final int vectorSize;

        public LLVMAArch64_Tbl2(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        protected LLVMI8Vector doOp(LLVMI8Vector source1, LLVMI8Vector source2, LLVMI8Vector selector) {
            assert (source1.getLength() == selector.getLength());
            assert (source1.getLength() == source2.getLength());
            assert (source1.getLength() == this.vectorSize);
            byte[] result = new byte[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                byte index = selector.getValue(i);
                result[i] = index < 0 || index >= 2 * this.vectorSize ? (byte)0 : (index < this.vectorSize ? source1.getValue(index) : source2.getValue(index - this.vectorSize));
            }
            return LLVMI8Vector.create(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMAArch64_Tbl1
    extends LLVMBuiltin {
        final int vectorSize;

        public LLVMAArch64_Tbl1(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        protected LLVMI8Vector doOp(LLVMI8Vector source, LLVMI8Vector selector) {
            assert (source.getLength() == selector.getLength());
            assert (source.getLength() == this.vectorSize);
            byte[] result = new byte[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                byte index = selector.getValue(i);
                result[i] = index < 0 || index >= this.vectorSize ? (byte)0 : source.getValue(index);
            }
            return LLVMI8Vector.create(result);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMAArch64_Ld2
    extends LLVMBuiltin {
        final int vectorSize;
        final int elementSize;

        public LLVMAArch64_Ld2(int vectorSize, int elementSize) {
            assert (vectorSize % 8 == 0);
            this.vectorSize = vectorSize;
            this.elementSize = elementSize;
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointer doOp(LLVMPointer retStackSpace, LLVMPointer srcAddress, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadNodeV1, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadNodeV2, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeNodeV1, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeNodeV2) {
            if (this.elementSize != 1) {
                CompilerDirectives.transferToInterpreter();
                throw CompilerDirectives.shouldNotReachHere((String)("Not implemented yet. elementSize=" + this.elementSize));
            }
            long targetOffset = 0L;
            for (int i = 0; i < 2 * this.vectorSize; i += 2 * this.elementSize) {
                byte v1 = loadNodeV1.executeWithTarget(srcAddress, i);
                storeNodeV1.executeWithTarget(retStackSpace, targetOffset, v1);
                byte v2 = loadNodeV2.executeWithTarget(srcAddress, i + this.elementSize);
                storeNodeV2.executeWithTarget(retStackSpace, targetOffset + (long)this.vectorSize, v2);
                ++targetOffset;
            }
            return retStackSpace;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMAArch64_Ld1x2
    extends LLVMBuiltin {
        final int vectorSize;

        public LLVMAArch64_Ld1x2(int vectorSize) {
            assert (vectorSize % 8 == 0);
            this.vectorSize = vectorSize;
        }

        @Specialization
        protected LLVMPointer doOp(LLVMPointer retStackSpace, LLVMPointer srcAddress, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadNode, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode) {
            for (int i = 0; i < 2 * this.vectorSize; i += 8) {
                Object value = loadNode.executeWithTargetGeneric(srcAddress, i);
                storeNode.executeWithTargetGeneric(retStackSpace, i, value);
            }
            return retStackSpace;
        }
    }
}

