/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToVarINode.class)
public final class LLVMToVarINodeGen
extends LLVMToVarINode
implements GenerateAOT.Provider {
    private final int bits;
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private PointerData pointer_cache;

    private LLVMToVarINodeGen(LLVMExpressionNode fromNode, int bits) {
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    private LLVMToVarINodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
        super(isRecursive);
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    protected LLVMIVarBit executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            PointerData s0_ = this.pointer_cache;
            if (s0_ != null) {
                assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                return this.doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if (!this.isRecursive) {
                PointerData s0_ = (PointerData)this.insert(new PointerData());
                s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                this.state_0_ = state_0 |= 2;
                return this.doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        if (!this.isRecursive) {
            PointerData s0_ = (PointerData)this.insert(new PointerData());
            s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
            s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
            VarHandle.storeStoreFence();
            this.pointer_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.toNative_, (int)1));
            ((GenerateAOT.Provider)s0_.toNative_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s0_.recursive_, (int)1));
            ((GenerateAOT.Provider)s0_.recursive_).prepareForAOT(language, root);
            this.state_0_ |= 2;
        }
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMToVarINode create(LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(fromNode, bits);
    }

    @NeverDefault
    public static LLVMToVarINode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(isRecursive, fromNode, bits);
    }

    @GeneratedBy(value=LLVMToVarINode.class)
    @DenyReplace
    private static final class PointerData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMToNativeNode toNative_;
        @Node.Child
        LLVMToVarINode recursive_;

        PointerData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMBitcastToIVarNode.class)
    public static final class LLVMBitcastToIVarNodeGen
    extends LLVMToVarINode.LLVMBitcastToIVarNode
    implements GenerateAOT.Provider {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMBitcastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x40) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFA) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x1FF6) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x1FEE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x1FDE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1FBE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x1EFE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0x1DFE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x100) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x200) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FFE) != 0) {
                Object fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doBoolean(fromNodeValue__2);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__3);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__4);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__5);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__6);
                }
                if ((state_0 & 0x80) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_);
                    return this.doIVarBit((LLVMIVarBit)fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__7);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__8 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__8);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80BitFloat((LLVM80BitFloat)fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.do128BitFloat((LLVM128BitFloat)fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s0_ = (PointerData)this.insert(new PointerData());
                    s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    this.state_0_ = state_0 |= 2;
                    return this.doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doBoolean(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI64(fromNodeValue_);
            }
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                state_0 |= lLVMIVarBitCast0 << 13;
                this.state_0_ = state_0 |= 0x80;
                return this.doIVarBit(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x100;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.do128BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doI1Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FFE & (state_0 & 0x1FFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s0_ = (PointerData)this.insert(new PointerData());
                s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert (NodeUtil.assertRecursion((Node)s0_.toNative_, (int)1));
                ((GenerateAOT.Provider)s0_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s0_.recursive_, (int)1));
                ((GenerateAOT.Provider)s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 2;
            }
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0xE000;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMBitcastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMBitcastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(value=LLVMToVarINode.LLVMBitcastToIVarNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToVarINode recursive_;

            PointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMUnsignedCastToIVarNode.class)
    public static final class LLVMUnsignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMUnsignedCastToIVarNode
    implements GenerateAOT.Provider {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMUnsignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x40) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FA) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x1F6) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x1EE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x1DE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1BE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            return this.executeGeneric_generic5(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FE) != 0) {
                Object fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doBoolean(fromNodeValue__2);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__3);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__4);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__5);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__6);
                }
                if ((state_0 & 0x80) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return this.doIVarBit((LLVMIVarBitLarge)fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                    return this.doIVarBit((LLVMIVarBitSmall)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Object fromNodeValue_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s0_ = (PointerData)this.insert(new PointerData());
                    s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    this.state_0_ = state_0 |= 2;
                    return this.doPointer((LLVMPointer)fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doBoolean(fromNodeValue_2);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_3 = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI8(fromNodeValue_3);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_4 = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI16(fromNodeValue_4);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_5 = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI32(fromNodeValue_5);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_6 = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI64(fromNodeValue_6);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                this.state_0_ = state_0 |= 0x80;
                return this.doIVarBit((LLVMIVarBitLarge)fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                this.state_0_ = state_0 |= 0x100;
                return this.doIVarBit((LLVMIVarBitSmall)fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FE & (state_0 & 0x1FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s0_ = (PointerData)this.insert(new PointerData());
                s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert (NodeUtil.assertRecursion((Node)s0_.toNative_, (int)1));
                ((GenerateAOT.Provider)s0_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s0_.recursive_, (int)1));
                ((GenerateAOT.Provider)s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 2;
            }
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMUnsignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMUnsignedCastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(value=LLVMToVarINode.LLVMUnsignedCastToIVarNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToVarINode recursive_;

            PointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMSignedCastToIVarNode.class)
    public static final class LLVMSignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMSignedCastToIVarNode
    implements GenerateAOT.Provider {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMSignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x40) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FA) == 0 && (state_0 & 0x7FE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x7F6) == 0 && (state_0 & 0x7FE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x7EE) == 0 && (state_0 & 0x7FE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x7DE) == 0 && (state_0 & 0x7FE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x7BE) == 0 && (state_0 & 0x7FE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            return this.executeGeneric_generic5(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x7FE) != 0) {
                Object fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doBoolean(fromNodeValue__2);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__3);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__4);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__5);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__6);
                }
                if ((state_0 & 0x80) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return this.doIVarBit((LLVMIVarBitLarge)fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                    return this.doIVarBit((LLVMIVarBitSmall)fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80BitFloat((LLVM80BitFloat)fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.do128BitFloat((LLVM128BitFloat)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Object fromNodeValue_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s0_ = (PointerData)this.insert(new PointerData());
                    s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    this.state_0_ = state_0 |= 2;
                    return this.doPointer((LLVMPointer)fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doBoolean(fromNodeValue_2);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_3 = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI8(fromNodeValue_3);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_4 = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI16(fromNodeValue_4);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_5 = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI32(fromNodeValue_5);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_6 = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI64(fromNodeValue_6);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                this.state_0_ = state_0 |= 0x80;
                return this.doIVarBit((LLVMIVarBitLarge)fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                this.state_0_ = state_0 |= 0x100;
                return this.doIVarBit((LLVMIVarBitSmall)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.do80BitFloat((LLVM80BitFloat)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                fromNodeValue_ = (LLVM128BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.do128BitFloat((LLVM128BitFloat)fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7FE & (state_0 & 0x7FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s0_ = (PointerData)this.insert(new PointerData());
                s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s0_.recursive_ = (LLVMToVarINode)s0_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert (NodeUtil.assertRecursion((Node)s0_.toNative_, (int)1));
                ((GenerateAOT.Provider)s0_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s0_.recursive_, (int)1));
                ((GenerateAOT.Provider)s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 2;
            }
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMSignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMToVarINode.LLVMSignedCastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(value=LLVMToVarINode.LLVMSignedCastToIVarNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToVarINode recursive_;

            PointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }
}

