/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ReadAddressNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64ReadAddressNode.class)
public final class LLVMAMD64ReadAddressNodeGen
extends LLVMAMD64ReadAddressNode
implements GenerateAOT.Provider {
    private final int slot;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMAMD64ReadAddressNodeGen(int slot) {
        this.slot = slot;
    }

    @Override
    protected int getSlot() {
        return this.slot;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue);
        }
        if ((state_0 & 0x1A) != 0) {
            if ((state_0 & 2) != 0) {
                try {
                    return this.readI64(frameValue);
                }
                catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    return this.executeAndSpecialize(frameValue);
                }
            }
            if ((state_0 & 0x10) != 0) {
                try {
                    return this.readPointer(frameValue);
                }
                catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFEF;
                    this.state_0_ = state_0 |= 0x20;
                    return this.executeAndSpecialize(frameValue);
                }
            }
            if ((state_0 & 8) != 0) {
                return this.readGeneric(frameValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 8) != 0) {
            return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(frameValue));
        }
        if ((state_0 & 2) != 0) {
            try {
                return this.readI64(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(frameValue));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(this.executeAndSpecialize(frameValue));
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((state_0 & 8) == 0 && (state_0 & 4) == 0) {
            this.state_0_ = state_0 |= 2;
            try {
                return this.readI64(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return this.executeAndSpecialize(frameValue);
            }
        }
        if ((state_0 & 8) == 0 && (state_0 & 0x20) == 0) {
            this.state_0_ = state_0 |= 0x10;
            try {
                return this.readPointer(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFEF;
                this.state_0_ = state_0 |= 0x20;
                return this.executeAndSpecialize(frameValue);
            }
        }
        state_0 &= 0xFFFFFFED;
        this.state_0_ = state_0 |= 8;
        return this.readGeneric(frameValue);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1A) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x1A & (state_0 & 0x1A) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ &= 0xFFFFFFED;
        this.state_0_ |= 8;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64ReadAddressNode create(int slot) {
        return new LLVMAMD64ReadAddressNodeGen(slot);
    }
}

