/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignDirectSuperElemPtrNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetSuperElemPtrNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignVirtualSuperElemPtrNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import org.graalvm.collections.Pair;

@GenerateUncached
public abstract class LLVMResolveForeignClassChainNode
extends LLVMNode {
    public abstract LLVMPointer execute(LLVMPointer var1, String var2, LLVMInteropType var3) throws UnknownIdentifierException;

    @Specialization(guards={"ident.equals(cachedIdent)", "clazz==cachedClazz"})
    public LLVMPointer doClassResolvingCached(LLVMPointer receiver, String ident, LLVMInteropType.Clazz clazz, @Cached(value="ident", allowUncached=true) String cachedIdent, @Cached(value="clazz", allowUncached=true) LLVMInteropType.Clazz cachedClazz, @Cached LLVMForeignVirtualSuperElemPtrNode virtualSuperElemPtrNode, @Cached LLVMForeignDirectSuperElemPtrNode directSuperElemPtrNode, @Cached(value="clazz.getSuperOffsetInformation(ident)", allowUncached=true) Pair<long[], LLVMInteropType.Struct> p, @Cached(value="p.getLeft()") long[] offsetInformation) {
        LLVMPointer curReceiver = receiver;
        for (long val : offsetInformation) {
            LLVMForeignGetSuperElemPtrNode access = (val & 1L) == 1L ? virtualSuperElemPtrNode : directSuperElemPtrNode;
            curReceiver = access.execute(curReceiver, val >> 1);
        }
        return curReceiver.export(p.getRight() == null ? clazz : (LLVMInteropType)p.getRight());
    }

    @Specialization(replaces={"doClassResolvingCached"})
    public LLVMPointer doClazzResolving(LLVMPointer receiver, String ident, LLVMInteropType.Clazz clazz, @Cached LLVMForeignVirtualSuperElemPtrNode virtualSuperElemPtrNode, @Cached LLVMForeignDirectSuperElemPtrNode directSuperElemPtrNode) throws UnknownIdentifierException {
        LLVMPointer curReceiver = receiver;
        Pair<long[], LLVMInteropType.Struct> p = clazz.getSuperOffsetInformation(ident);
        for (long val : (long[])p.getLeft()) {
            LLVMForeignGetSuperElemPtrNode access = (val & 1L) == 1L ? virtualSuperElemPtrNode : directSuperElemPtrNode;
            curReceiver = access.execute(curReceiver, val >> 1);
        }
        return curReceiver.export(p.getRight() == null ? clazz : (LLVMInteropType)p.getRight());
    }

    static boolean isClazzType(Object o) {
        return o instanceof LLVMInteropType.Clazz;
    }

    @Specialization(guards={"!isClazzType(type)"})
    public LLVMPointer doNothing(LLVMPointer receiver, String ident, LLVMInteropType type) {
        return receiver;
    }
}

