/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignIntrinsicCallNode
extends RootNode {
    @Node.Child
    LLVMExpressionNode intrinsicNode;
    @Node.Child
    LLVMDataEscapeNode dataEscape;
    private final LLVMInteropType.Structured retType;

    public static LLVMForeignIntrinsicCallNode create(LLVMLanguage language, LLVMFunctionCode.Intrinsic intrinsic, FunctionType type, LLVMInteropType.Function interopType) {
        int argCount = interopType.getNumberOfParameters() + 1;
        LLVMExpressionNode[] args = new LLVMExpressionNode[argCount];
        args[0] = null;
        for (int i = 1; i < argCount; ++i) {
            LLVMInteropType.Value argType = (LLVMInteropType.Value)interopType.getParameter(i - 1);
            args[i] = new ForeignIntrinsicArgNode(i - 1, argType);
        }
        LLVMExpressionNode intrinsicNode = intrinsic.createIntrinsicNode(args, type.getArgumentTypes().toArray(Type.EMPTY_ARRAY));
        return new LLVMForeignIntrinsicCallNode(language, intrinsicNode, (LLVMInteropType.Value)interopType.getReturnType());
    }

    protected LLVMForeignIntrinsicCallNode(LLVMLanguage language, LLVMExpressionNode intrinsic, LLVMInteropType.Value retType) {
        super((TruffleLanguage)language);
        this.intrinsicNode = intrinsic;
        this.dataEscape = LLVMDataEscapeNode.create(retType.kind.foreignToLLVMType);
        this.retType = retType.baseType;
    }

    public Object execute(VirtualFrame frame) {
        Object ret = this.intrinsicNode.executeGeneric(frame);
        return this.dataEscape.executeWithType(ret, this.retType);
    }

    static class ForeignIntrinsicArgNode
    extends LLVMExpressionNode {
        private final int argIdx;
        @Node.Child
        ForeignToLLVM toLLVM;

        ForeignIntrinsicArgNode(int argIdx, LLVMInteropType.Value argType) {
            this.argIdx = argIdx;
            this.toLLVM = CommonNodeFactory.createForeignToLLVM(argType);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.toLLVM.executeWithTarget(frame.getArguments()[this.argIdx]);
        }
    }
}

