/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.CXXDemangler;
import com.oracle.truffle.llvm.initialization.LoadDependencyNode;
import com.oracle.truffle.llvm.initialization.LoadModulesNode;
import com.oracle.truffle.llvm.initialization.LoadNativeNode;
import com.oracle.truffle.llvm.parser.LLVMParser;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.runtime.CmdlineLibraryLocator;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.target.TargetTriple;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.graalvm.polyglot.io.ByteSequence;

final class ParserDriver {
    private final LLVMContext context;
    private final LLVMLanguage language;
    private final IDGenerater.BitcodeID bitcodeID;
    private final ArrayList<LoadDependencyNode> libraryDependencies = new ArrayList();
    static final String SULONG_RENAME_MARKER = "___sulong_import_";
    static final int SULONG_RENAME_MARKER_LEN = "___sulong_import_".length();

    public static CallTarget parse(LLVMContext context, IDGenerater.BitcodeID bitcodeID, Source source) {
        return new ParserDriver(context, bitcodeID).parseWithDependencies(source);
    }

    private ParserDriver(LLVMContext context, IDGenerater.BitcodeID bitcodeID) {
        this.context = context;
        this.language = context.getLanguage();
        this.bitcodeID = bitcodeID;
    }

    private CallTarget parseWithDependencies(Source source) {
        if (!source.hasBytes()) {
            if (source.hasCharacters()) {
                throw new LLVMParserException("Unexpected character-based source with mime type: " + source.getMimeType());
            }
            throw new LLVMParserException("Should not reach here: Source is neither char-based nor byte-based!");
        }
        ByteSequence bytes = source.getBytes();
        return this.parseWithDependencies(source, bytes);
    }

    private CallTarget parseWithDependencies(Source source, ByteSequence bytes) {
        this.insertDefaultDependencies(source.getName());
        LLVMParserResult result = this.parseLibraryWithSource(source, bytes);
        if (result == null) {
            TruffleFile file = this.createNativeTruffleFile(source.getName(), source.getPath());
            if (file == null) {
                return RootNode.createConstantNode((Object)0).getCallTarget();
            }
            return this.createNativeLibraryCallTarget(file);
        }
        if (result.getRuntime().isInternal()) {
            String libraryName = ParserDriver.getSimpleLibraryName(result.getRuntime().getLibraryName());
            this.language.addInternalFileScope(libraryName, result.getRuntime().getFileScope());
            if (libraryName.equals("libsulong")) {
                this.language.setDefaultBitcode(result.getDataLayout(), TargetTriple.create(result.getTargetTriple().toString()));
            }
            this.resolveRenamedSymbols(result);
        }
        ParserDriver.addExternalSymbolsToScopes(result);
        return this.createLibraryCallTarget(result.getRuntime().getLibraryName(), result, source);
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleFile createNativeTruffleFile(String libName, String libPath) {
        NativeContextExtension nativeContextExtension = this.context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null) {
            TruffleFile file = DefaultLibraryLocator.INSTANCE.locateFile(this.context, libName, "<native library>");
            if (file == null) {
                LibraryLocator.traceDelegateNative(this.context, libPath);
                file = this.context.getEnv().getInternalTruffleFile(libPath);
            }
            return file;
        }
        return null;
    }

    private void insertDefaultDependencies(String currentLib) {
        String[] sulongLibraryNames;
        for (String sulongLibraryName : sulongLibraryNames = this.language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()) {
            if (currentLib.equals(sulongLibraryName)) continue;
            this.libraryDependencies.add(LoadDependencyNode.create(sulongLibraryName, LLVMContext.InternalLocator.INSTANCE, "<internal library>"));
        }
        List<String> externals = SulongEngineOption.getPolyglotOptionExternalLibraries(this.context.getEnv());
        for (String externalLibraryName : externals) {
            if (currentLib.equals(externalLibraryName)) continue;
            this.libraryDependencies.add(LoadDependencyNode.create(externalLibraryName, CmdlineLibraryLocator.INSTANCE, "<command-line library>"));
        }
    }

    private void registerRenamed(String name, GlobalSymbol external, RegisterRenamed result) {
        int idx = name.indexOf(95, SULONG_RENAME_MARKER_LEN);
        if (idx > 0) {
            String lib = name.substring(SULONG_RENAME_MARKER_LEN, idx);
            LLVMScope scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
            if (scope == null) {
                try {
                    String libName = lib + "." + this.language.getCapability(PlatformCapability.class).getLibrarySuffix();
                    Source source = LLVMContext.InternalLocator.INSTANCE.locateSource(this.context, libName, "<default bitcode library>");
                    this.context.getEnv().parseInternal(source, new String[0]);
                    scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (scope == null) {
                throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found during symbol renaming", external.getName(), lib));
            }
            String originalName = name.substring(idx + 1);
            result.register(scope, originalName, lib);
        }
    }

    protected void resolveRenamedSymbols(LLVMParserResult parserResult) {
        String name;
        for (GlobalVariable globalVariable : parserResult.getExternalGlobals()) {
            name = globalVariable.getName();
            if (!name.startsWith(SULONG_RENAME_MARKER)) continue;
            this.registerRenamed(name, globalVariable, (scope, originalName, lib) -> ParserDriver.createNewGlobal(scope, originalName, parserResult, globalVariable, lib, name));
        }
        ListIterator<FunctionSymbol> it = parserResult.getExternalFunctions().listIterator();
        while (it.hasNext()) {
            FunctionSymbol functionSymbol = it.next();
            name = functionSymbol.getName();
            if (name.startsWith(SULONG_RENAME_MARKER)) {
                this.registerRenamed(name, functionSymbol, (scope, originalName, lib) -> ParserDriver.createNewFunction(scope, originalName, parserResult, functionSymbol, lib, name, it));
                continue;
            }
            if (!CXXDemangler.isRenamedNamespaceSymbol(name)) continue;
            ArrayList<String> namespaces = CXXDemangler.decodeNamespace(name);
            String lib2 = CXXDemangler.getAndRemoveLibraryName(namespaces);
            LLVMScope scope2 = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib2));
            if (scope2 == null) {
                try {
                    String libName = lib2 + "." + this.language.getCapability(PlatformCapability.class).getLibrarySuffix();
                    Source source = LLVMContext.InternalLocator.INSTANCE.locateSource(this.context, libName, "<default bitcode library>");
                    this.context.getEnv().parseInternal(source, new String[0]);
                    scope2 = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib2));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (scope2 == null) {
                throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found during symbol renaming", functionSymbol.getName(), lib2));
            }
            String originalName2 = CXXDemangler.encodeNamespace(namespaces);
            ParserDriver.createNewFunction(scope2, originalName2, parserResult, functionSymbol, lib2, name, it);
        }
    }

    private static void createNewFunction(LLVMScope scope, String originalName, LLVMParserResult parserResult, FunctionSymbol external, String lib, String name, ListIterator<FunctionSymbol> it) {
        LLVMFunction originalSymbol = scope.getFunction(originalName);
        if (originalSymbol == null) {
            throw new LLVMLinkerException(String.format("The symbol %s could not be imported because the symbol %s was not found in library %s", external.getName(), originalName, lib));
        }
        LLVMFunction newFunction = LLVMFunction.create(name, originalSymbol.getFunction(), originalSymbol.getType(), parserResult.getRuntime().getBitcodeID(), external.getIndex(), external.isExported(), parserResult.getRuntime().getPath(), external.isExternalWeak());
        parserResult.getRuntime().getFileScope().register(newFunction);
        if (external.isExported()) {
            parserResult.getRuntime().getPublicFileScope().register(newFunction);
        }
        it.remove();
        parserResult.getDefinedFunctions().add(external);
    }

    private static void createNewGlobal(LLVMScope scope, String originalName, LLVMParserResult parserResult, GlobalVariable external, String lib, String name) {
        LLVMGlobal originalSymbol = scope.getGlobalVariable(originalName);
        if (originalSymbol == null) {
            throw new LLVMLinkerException(String.format("The symbol %s could not be imported because the symbol %s was not found in library %s", external.getName(), originalName, lib));
        }
        LLVMAlias newGlobal = new LLVMAlias(name, originalSymbol, false);
        parserResult.getRuntime().getFileScope().register(newGlobal);
    }

    private static String getSimpleLibraryName(String name) {
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        String substring = name.substring(0, index);
        if (substring.equals("sulong")) {
            return "libsulong";
        }
        return substring;
    }

    private static TargetTriple getTargetTriple(ModelModule module) {
        com.oracle.truffle.llvm.parser.model.target.TargetTriple parsedTargetTriple = module.getTargetInformation(com.oracle.truffle.llvm.parser.model.target.TargetTriple.class);
        if (parsedTargetTriple != null) {
            return TargetTriple.create(parsedTargetTriple.toString());
        }
        return null;
    }

    private LLVMParserResult parseBinary(BinaryParserResult binaryParserResult) {
        ModelModule module = new ModelModule();
        Source source = binaryParserResult.getSource();
        LLVMScanner.parseBitcode(binaryParserResult.getBitcode(), module, source);
        DataLayout targetDataLayout = new DataLayout(module.getTargetDataLayout(), "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f16:16:16-f32:32:32-f64:64:64-f128:128:128");
        this.verifyBitcodeSource(source, targetDataLayout, ParserDriver.getTargetTriple(module));
        NodeFactory nodeFactory = this.context.getLanguage().getActiveConfiguration().createNodeFactory(this.language, targetDataLayout);
        LLVMScope publicFileScope = new LLVMScope();
        LLVMScope fileScope = new LLVMScope();
        LLVMParserRuntime runtime = new LLVMParserRuntime(fileScope, publicFileScope, nodeFactory, this.bitcodeID, source, binaryParserResult.getLibraryName(), ParserDriver.getSourceFilesWithChecksums(this.context.getEnv(), module), binaryParserResult.getLocator());
        LLVMParser parser = new LLVMParser(source, runtime);
        LLVMParserResult result = parser.parse(module, targetDataLayout);
        binaryParserResult.getExportSymbolsMapper().registerExports(fileScope, publicFileScope);
        this.createDebugInfo(module, new LLVMSymbolReadResolver(runtime, null, GetStackSpaceFactory.createAllocaFactory(), targetDataLayout, false));
        return result;
    }

    private void verifyBitcodeSource(Source source, DataLayout targetDataLayout, TargetTriple targetTriple) {
        if (targetDataLayout.getByteOrder() != ByteOrder.LITTLE_ENDIAN) {
            throw new LLVMParserException("Byte order " + targetDataLayout.getByteOrder() + " of file " + source.getPath() + " is not supported");
        }
        boolean verifyBitcode = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.VERIFY_BITCODE);
        TargetTriple defaultTargetTriple = this.language.getDefaultTargetTriple();
        if (defaultTargetTriple == null && !source.isInternal()) {
            throw new IllegalStateException("No default target triple.");
        }
        if (defaultTargetTriple != null && targetTriple != null && !defaultTargetTriple.matches(targetTriple)) {
            TruffleLogger logger = TruffleLogger.getLogger((String)"llvm", (String)"BitcodeVerifier");
            String exceptionMessage = "Mismatching target triple (expected " + defaultTargetTriple + ", got " + targetTriple + ")";
            logger.severe(exceptionMessage);
            logger.severe("Source " + source.getPath());
            logger.severe("See https://www.graalvm.org/reference-manual/llvm/Compiling/ for more details");
            logger.severe("To silence this message, set --log." + logger.getName() + ".level=OFF");
            if (verifyBitcode) {
                logger.severe("To make this error non-fatal, set --llvm.verifyBitcode=false");
                throw new LLVMParserException(exceptionMessage);
            }
        }
    }

    private static List<LLVMSourceFileReference> getSourceFilesWithChecksums(TruffleLanguage.Env env, ModelModule module) {
        List<LLVMSourceFileReference> sourceWithChecksum;
        if (SulongEngineOption.shouldVerifyCompileUnitChecksums(env) && !(sourceWithChecksum = module.getSourceFileReferences().stream().filter(f -> f.getChecksumKind() != LLVMSourceFileReference.ChecksumKind.CSK_None).collect(Collectors.toList())).isEmpty()) {
            return sourceWithChecksum;
        }
        return null;
    }

    private void createDebugInfo(ModelModule model, LLVMSymbolReadResolver symbolResolver) {
        LLVMSourceContext sourceContext = this.context.getSourceContext();
        model.getSourceGlobals().forEach((symbol, irValue) -> {
            try {
                LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)irValue);
                LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, irValue instanceof GlobalVariable);
                sourceContext.registerStatic((LLVMSourceSymbol)symbol, value);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        model.getSourceStaticMembers().forEach((type, symbol) -> {
            LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)symbol);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, symbol instanceof GlobalVariable);
            type.setValue(value);
        });
    }

    private LLVMParserResult parseLibraryWithSource(Source source, ByteSequence bytes) {
        BinaryParserResult binaryParserResult = BinaryParser.parse(bytes, source, this.context);
        if (binaryParserResult != null) {
            this.context.addLibraryPaths(binaryParserResult.getLibraryPaths());
            this.processDependencies(binaryParserResult.getLibraryName(), source.isInternal(), binaryParserResult);
            return this.parseBinary(binaryParserResult);
        }
        LibraryLocator.traceDelegateNative(this.context, source);
        return null;
    }

    private void processDependencies(String libraryName, boolean isInternal, BinaryParserResult binaryParserResult) {
        for (String lib : this.context.preprocessDependencies(binaryParserResult.getLibraries(), libraryName, isInternal)) {
            if (libraryName.equals(lib)) continue;
            this.libraryDependencies.add(LoadDependencyNode.create(lib, binaryParserResult.getLocator(), lib));
        }
    }

    private static void addExternalSymbolsToScopes(LLVMParserResult parserResult) {
        LLVMScope fileScope = parserResult.getRuntime().getFileScope();
        for (FunctionSymbol function : parserResult.getExternalFunctions()) {
            if (fileScope.contains(function.getName())) continue;
            fileScope.register(LLVMFunction.create(function.getName(), new LLVMFunctionCode.UnresolvedFunction(), function.getType(), parserResult.getRuntime().getBitcodeID(), function.getIndex(), false, parserResult.getRuntime().getPath(), function.isExternalWeak()));
        }
        for (GlobalVariable global : parserResult.getExternalGlobals()) {
            if (fileScope.contains(global.getName())) continue;
            if (global.isThreadLocal()) {
                fileScope.register(LLVMThreadLocalSymbol.create(global.getName(), global.getSourceSymbol(), parserResult.getRuntime().getBitcodeID(), global.getIndex(), global.isExported(), global.isExternalWeak()));
                continue;
            }
            fileScope.register(LLVMGlobal.create(global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly(), global.getIndex(), parserResult.getRuntime().getBitcodeID(), false, global.isExternalWeak()));
        }
    }

    private CallTarget createLibraryCallTarget(String name, LLVMParserResult parserResult, Source source) {
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return RootNode.createConstantNode((Object)0).getCallTarget();
        }
        boolean lazyParsing = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LAZY_PARSING) != false && (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.AOTCacheStore) == false;
        LoadModulesNode loadModules = LoadModulesNode.create(name, parserResult, lazyParsing, parserResult.getRuntime().isInternal(), this.libraryDependencies, source, this.language);
        return loadModules.getCallTarget();
    }

    private CallTarget createNativeLibraryCallTarget(TruffleFile file) {
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return RootNode.createConstantNode((Object)0).getCallTarget();
        }
        LoadNativeNode loadNative = LoadNativeNode.create(this.language, file);
        return loadNative.getCallTarget();
    }

    @FunctionalInterface
    private static interface RegisterRenamed {
        public void register(LLVMScope var1, String var2, String var3);
    }
}

