/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMVectorizedGetElementPtrNode
extends LLVMExpressionNode {
    final long typeWidth;
    final Type targetType;

    public LLVMVectorizedGetElementPtrNode(long typeWidth, Type targetType) {
        this.typeWidth = typeWidth;
        this.targetType = targetType;
    }

    @Specialization
    protected LLVMPointerVector doLong(LLVMPointerVector addrs, LLVMI64Vector vals) {
        assert (addrs.getLength() == vals.getLength());
        LLVMPointer[] results = new LLVMPointer[addrs.getLength()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = addrs.getElement(i).increment(this.typeWidth * vals.getValue(i));
        }
        return LLVMPointerVector.create(results);
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class IndexVectorBroadcastNode
    extends LLVMExpressionNode {
        final int vectorLength;

        public IndexVectorBroadcastNode(int vectorLength) {
            this.vectorLength = vectorLength;
        }

        @Specialization
        LLVMI64Vector doInt(int index) {
            long[] indexes = new long[this.vectorLength];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = index;
            }
            return LLVMI64Vector.create(indexes);
        }

        @Specialization
        LLVMI64Vector doLong(long index) {
            long[] indexes = new long[this.vectorLength];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = index;
            }
            return LLVMI64Vector.create(indexes);
        }

        @Specialization
        LLVMI64Vector doShort(short index) {
            long[] indexes = new long[this.vectorLength];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = index;
            }
            return LLVMI64Vector.create(indexes);
        }

        @Specialization
        LLVMI64Vector doByte(byte index) {
            long[] indexes = new long[this.vectorLength];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = index;
            }
            return LLVMI64Vector.create(indexes);
        }

        @Specialization
        LLVMI64Vector doBoolean(boolean index) {
            long[] indexes = new long[this.vectorLength];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = index ? 1L : 0L;
            }
            return LLVMI64Vector.create(indexes);
        }

        @Specialization
        LLVMI64Vector doPointer(LLVMPointer basePointer, @Cached LLVMToNativeNode toNative) {
            long[] pointers = new long[this.vectorLength];
            long baseNativePointer = toNative.executeWithTarget(basePointer).asNative();
            for (int i = 0; i < pointers.length; ++i) {
                pointers[i] = baseNativePointer;
            }
            return LLVMI64Vector.create(pointers);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class ResultVectorBroadcastNode
    extends LLVMExpressionNode {
        final int vectorLength;

        public ResultVectorBroadcastNode(int vectorLength) {
            this.vectorLength = vectorLength;
        }

        @Specialization
        LLVMPointerVector doPointer(LLVMPointer basePointer) {
            LLVMPointer[] pointers = new LLVMPointer[this.vectorLength];
            for (int i = 0; i < pointers.length; ++i) {
                pointers[i] = basePointer;
            }
            return LLVMPointerVector.create(pointers);
        }
    }
}

