/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNodeFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
final class FallbackReadGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private FallbackReadGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.FallbackRead.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedReadLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, Object.class, true, false, 0);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadI8NodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadI16NodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadI32NodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readI64(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI64(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadI64NodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadI64NodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadFloatNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadDoubleNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, LLVMReadFromForeignObjectNodeFactory.ForeignReadPointerNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadI8Node readI8Node__readI8_readNode_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadI16Node readI16Node__readI16_readNode_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadI32Node readI32Node__readI32_readNode_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadFloatNode readFloatNode__readFloat_readNode_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadDoubleNode readDoubleNode__readDouble_readNode_;
            @Node.Child
            private LLVMReadFromForeignObjectNode.ForeignReadPointerNode readPointerNode__readPointer_readNode_;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create(receiver);
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != this.dynamicDispatchTarget_) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public boolean isReadable(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                InteropLibrary interop__ = this.receiverInteropLibrary_;
                return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, interop__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public byte readI8(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadI8Node readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (readNode__ = this.readI8Node__readI8_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadI8Node readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadI8Node)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadI8NodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readI8(Object, long, ForeignReadI8Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI8Node__readI8_readNode_ = readNode__;
                this.state_0_ = state_0 |= 1;
                return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, readNode__);
            }

            @Override
            public short readI16(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadI16Node readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (readNode__ = this.readI16Node__readI16_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadI16Node readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadI16Node)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadI16NodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readI16(Object, long, ForeignReadI16Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI16Node__readI16_readNode_ = readNode__;
                this.state_0_ = state_0 |= 2;
                return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, readNode__);
            }

            @Override
            public int readI32(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadI32Node readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (readNode__ = this.readI32Node__readI32_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32Node_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadI32Node readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadI32Node)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadI32NodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readI32(Object, long, ForeignReadI32Node)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readI32Node__readI32_readNode_ = readNode__;
                this.state_0_ = state_0 |= 4;
                return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, readNode__);
            }

            @Override
            public long readI64(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64_;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (readI64_ = this.readI64) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI64(arg0Value, arg1Value, readI64_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private long readI64Node_AndSpecialize(Object arg0Value, long arg1Value) throws UnexpectedResultException {
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64_;
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64__shared = this.readI64;
                if (readI64__shared != null) {
                    readI64_ = readI64__shared;
                } else {
                    readI64_ = (LLVMReadFromForeignObjectNode.ForeignReadI64Node)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadI64NodeGen.create());
                    if (readI64_ == null) {
                        throw new IllegalStateException("Specialization 'readI64(Object, long, ForeignReadI64Node)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.readI64 == null) {
                    VarHandle.storeStoreFence();
                    this.readI64 = readI64_;
                }
                this.state_0_ = state_0 |= 8;
                return LLVMManagedAccessDefaults.FallbackRead.readI64(arg0Value, arg1Value, readI64_);
            }

            @Override
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64_;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (readI64_ = this.readI64) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, readI64_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64Node_AndSpecialize(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64_;
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadI64Node readI64__shared = this.readI64;
                if (readI64__shared != null) {
                    readI64_ = readI64__shared;
                } else {
                    readI64_ = (LLVMReadFromForeignObjectNode.ForeignReadI64Node)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadI64NodeGen.create());
                    if (readI64_ == null) {
                        throw new IllegalStateException("Specialization 'readGenericI64(Object, long, ForeignReadI64Node)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.readI64 == null) {
                    VarHandle.storeStoreFence();
                    this.readI64 = readI64_;
                }
                this.state_0_ = state_0 |= 0x10;
                return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, readI64_);
            }

            @Override
            public float readFloat(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadFloatNode readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (readNode__ = this.readFloatNode__readFloat_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadFloatNode readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadFloatNode)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadFloatNodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readFloat(Object, long, ForeignReadFloatNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readFloatNode__readFloat_readNode_ = readNode__;
                this.state_0_ = state_0 |= 0x20;
                return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, readNode__);
            }

            @Override
            public double readDouble(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadDoubleNode readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (readNode__ = this.readDoubleNode__readDouble_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadDoubleNode readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadDoubleNode)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadDoubleNodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readDouble(Object, long, ForeignReadDoubleNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readDoubleNode__readDouble_readNode_ = readNode__;
                this.state_0_ = state_0 |= 0x40;
                return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, readNode__);
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                LLVMReadFromForeignObjectNode.ForeignReadPointerNode readNode__;
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (readNode__ = this.readPointerNode__readPointer_readNode_) != null) {
                    return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, readNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerNode_AndSpecialize(Object arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                LLVMReadFromForeignObjectNode.ForeignReadPointerNode readNode__ = (LLVMReadFromForeignObjectNode.ForeignReadPointerNode)this.insert(LLVMReadFromForeignObjectNodeFactory.ForeignReadPointerNodeGen.create());
                Objects.requireNonNull(readNode__, "Specialization 'readPointer(Object, long, ForeignReadPointerNode)' cache 'readNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readPointerNode__readPointer_readNode_ = readNode__;
                this.state_0_ = state_0 |= 0x80;
                return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, readNode__);
            }
        }
    }
}

