/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceClassLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceInheritanceType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMethodType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=false)})
public abstract class LLVMInteropType
implements TruffleObject {
    public static final Value UNKNOWN = Value.primitive(null, 0L);
    public static final Buffer BUFFER = new Buffer();
    private final long size;

    private LLVMInteropType(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public Array toArray(long length) {
        return new Array(this, this.size, length);
    }

    @ExportMessage
    boolean isForeign() {
        return false;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaSimpleName"), @ExportMessage(name="getMetaQualifiedName")})
    @CompilerDirectives.TruffleBoundary
    Object getMetaSimpleName() {
        return this.toString();
    }

    @ExportMessage
    boolean isMetaInstance(Object instance) {
        if (LLVMPointer.isInstance(instance)) {
            return LLVMPointer.cast(instance).getExportType() == this;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public final String toString() {
        return this.toString((EconomicSet<LLVMInteropType>)EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE));
    }

    @ExportMessage
    final boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    final Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    protected abstract String toString(EconomicSet<LLVMInteropType> var1);

    public static final class Array
    extends Structured {
        public final LLVMInteropType elementType;
        public final long elementSize;
        public final long length;

        Array(InteropTypeRegistry.Register elementType, long elementSize, long length) {
            super(elementSize * length);
            this.elementType = elementType.get(this);
            this.elementSize = elementSize;
            this.length = length;
        }

        private Array(LLVMInteropType elementType, long elementSize, long length) {
            super(elementSize * length);
            this.elementType = elementType;
            this.elementSize = elementSize;
            this.length = length;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return "<recursive array type>";
            }
            visited.add((Object)this);
            return String.format("%s[%d]", this.elementType.toString(visited), this.length);
        }
    }

    public static final class Value
    extends LLVMInteropType {
        public final ValueKind kind;
        public final Structured baseType;

        private static Value primitive(ValueKind kind, long size) {
            return new Value(kind, null, size);
        }

        public static Value pointer(Structured baseType, long size) {
            return new Value(ValueKind.POINTER, baseType, size);
        }

        private Value(ValueKind kind, Structured baseType, long size) {
            super(size);
            this.kind = kind;
            this.baseType = baseType;
        }

        public int getSizeInBytes() {
            return this.kind.foreignToLLVMType.getSizeInBytes();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return String.format("<recursive %s>", this.kind.name());
            }
            visited.add((Object)this);
            if (this.baseType == null) {
                return this.kind.name();
            }
            return this.baseType.toString(visited) + "*";
        }
    }

    public static enum ValueKind {
        I1(ForeignToLLVM.ForeignToLLVMType.I1),
        I8(ForeignToLLVM.ForeignToLLVMType.I8),
        I16(ForeignToLLVM.ForeignToLLVMType.I16),
        I32(ForeignToLLVM.ForeignToLLVMType.I32),
        I64(ForeignToLLVM.ForeignToLLVMType.I64),
        FLOAT(ForeignToLLVM.ForeignToLLVMType.FLOAT),
        DOUBLE(ForeignToLLVM.ForeignToLLVMType.DOUBLE),
        FP80(ForeignToLLVM.ForeignToLLVMType.FP80),
        POINTER(ForeignToLLVM.ForeignToLLVMType.POINTER),
        FP128(ForeignToLLVM.ForeignToLLVMType.FP128);

        public final Value type;
        public final ForeignToLLVM.ForeignToLLVMType foreignToLLVMType;

        private ValueKind(ForeignToLLVM.ForeignToLLVMType foreignToLLVMType) {
            this.foreignToLLVMType = foreignToLLVMType;
            this.type = Value.primitive(this, foreignToLLVMType.getSizeInBytes());
        }
    }

    public static final class Buffer
    extends LLVMInteropType {
        private final boolean isWritable;

        public Buffer() {
            this(true, 0L);
        }

        public Buffer(boolean isWritable, long length) {
            super(length);
            this.isWritable = isWritable;
        }

        public boolean isWritable() {
            return this.isWritable;
        }

        @Override
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            return "buffer";
        }
    }

    public static final class InteropTypeRegistry {
        private final EconomicMap<LLVMSourceType, LLVMInteropType> typeCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);

        public synchronized LLVMInteropType get(LLVMSourceType type) {
            if (type == null) {
                return UNKNOWN;
            }
            LLVMSourceType actual = type.getActualType();
            if (this.typeCache.containsKey((Object)actual)) {
                return (LLVMInteropType)this.typeCache.get((Object)actual);
            }
            LLVMInteropType ret = this.convert(actual);
            this.typeCache.put((Object)actual, (Object)ret);
            return ret;
        }

        private LLVMInteropType convert(LLVMSourceType type) {
            if (type instanceof LLVMSourcePointerType) {
                return this.convertPointer((LLVMSourcePointerType)type);
            }
            if (type instanceof LLVMSourceBasicType) {
                return InteropTypeRegistry.convertBasic((LLVMSourceBasicType)type);
            }
            return this.convertStructured(type);
        }

        private Structured getStructured(LLVMSourceType type) {
            LLVMSourceType actual = type.getActualType();
            if (this.typeCache.containsKey((Object)actual)) {
                LLVMInteropType ret = (LLVMInteropType)this.typeCache.get((Object)actual);
                if (ret instanceof Structured) {
                    return (Structured)ret;
                }
                return null;
            }
            return this.convertStructured(actual);
        }

        private Structured convertStructured(LLVMSourceType type) {
            if (type instanceof LLVMSourceArrayLikeType) {
                return this.convertArray((LLVMSourceArrayLikeType)type);
            }
            if (type instanceof LLVMSourceClassLikeType) {
                return this.convertClass((LLVMSourceClassLikeType)type);
            }
            if (type instanceof LLVMSourceStructLikeType) {
                return this.convertStructuredStruct((LLVMSourceStructLikeType)type);
            }
            if (type instanceof LLVMSourceFunctionType) {
                return this.convertFunction((LLVMSourceFunctionType)type);
            }
            return null;
        }

        private Array convertArray(LLVMSourceArrayLikeType type) {
            LLVMSourceType base = type.getBaseType();
            return new Array(new Register(type, base), base.getSize() / 8L, type.getLength());
        }

        private Structured convertStructuredStruct(LLVMSourceStructLikeType type) {
            Struct struct;
            Structured ret = struct = this.convertStruct(type);
            if (struct.name.equals("struct polyglot_instant")) {
                ret = new Instant(struct);
            } else if (struct.name.equals("struct tm")) {
                ret = new TimeInfo(struct);
            }
            if (ret != struct) {
                this.typeCache.put((Object)type, (Object)ret);
            }
            return ret;
        }

        private Struct convertStruct(LLVMSourceStructLikeType type) {
            Struct ret = new Struct(type.getName(), new StructMember[type.getDynamicElementCount()], type.getSize() / 8L);
            this.typeCache.put((Object)type, (Object)ret);
            for (int i = 0; i < ret.members.length; ++i) {
                LLVMSourceMemberType member = type.getDynamicElement(i);
                LLVMSourceType memberType = member.getElementType();
                long startOffset = member.getOffset() / 8L;
                long endOffset = startOffset + (memberType.getSize() + 7L) / 8L;
                ret.members[i] = new StructMember(ret, member.getName(), startOffset, endOffset, this.get(memberType), false);
            }
            return ret;
        }

        private Clazz convertClass(LLVMSourceClassLikeType type) {
            int i;
            Clazz ret = new Clazz(type.getName(), new StructMember[type.getDynamicElementCount()], new Method[type.getMethodCount()], type.getSize() / 8L);
            this.typeCache.put((Object)type, (Object)ret);
            for (i = 0; i < ret.members.length; ++i) {
                LLVMSourceMemberType member = type.getDynamicElement(i);
                LLVMSourceType memberType = member.getElementType();
                boolean isInheritanceType = member instanceof LLVMSourceInheritanceType;
                if (isInheritanceType) {
                    assert (memberType instanceof LLVMSourceStructLikeType);
                    LLVMSourceStructLikeType sourceSuperType = (LLVMSourceStructLikeType)memberType;
                    if (!this.typeCache.containsKey((Object)sourceSuperType)) {
                        this.convertStructured(sourceSuperType);
                    }
                    Struct superType = (Struct)this.typeCache.get((Object)sourceSuperType);
                    ret.addSuperType(superType, member.getOffset(), ((LLVMSourceInheritanceType)member).isVirtual());
                }
                long startOffset = member.getOffset() / 8L;
                long endOffset = startOffset + (memberType.getSize() + 7L) / 8L;
                ret.members[i] = new StructMember(ret, member.getName(), startOffset, endOffset, this.get(memberType), isInheritanceType);
            }
            for (i = 0; i < ret.methods.length; ++i) {
                ret.methods[i] = this.convertMethod(type.getMethod(i), ret);
            }
            ret.buildVTable();
            return ret;
        }

        private Function convertFunction(LLVMSourceFunctionType functionType) {
            List<LLVMSourceType> parameterTypes = functionType.getParameterTypes();
            LLVMInteropType[] interopParameterTypes = new LLVMInteropType[parameterTypes.size()];
            Function interopFunctionType = new Function(new Register(functionType, functionType.getReturnType()), interopParameterTypes, false);
            this.typeCache.put((Object)functionType, (Object)interopFunctionType);
            for (int i = 0; i < interopParameterTypes.length; ++i) {
                interopParameterTypes[i] = this.get(parameterTypes.get(i));
            }
            return interopFunctionType;
        }

        private Method convertMethod(LLVMSourceMethodType sourceMethod, Clazz clazz) {
            List<LLVMSourceType> parameterTypes = sourceMethod.getParameterTypes();
            LLVMInteropType[] interopParameterTypes = new LLVMInteropType[parameterTypes.size()];
            Method interopMethodType = new Method(clazz, sourceMethod.getName(), sourceMethod.getLinkageName(), new Register(sourceMethod, sourceMethod.getReturnType()), interopParameterTypes, sourceMethod.getVirtualIndex());
            this.typeCache.put((Object)sourceMethod, (Object)interopMethodType);
            for (int i = 0; i < interopParameterTypes.length; ++i) {
                interopParameterTypes[i] = this.get(parameterTypes.get(i));
            }
            return interopMethodType;
        }

        private static Value convertBasic(LLVMSourceBasicType type) {
            switch (type.getKind()) {
                case ADDRESS: {
                    return ValueKind.POINTER.type;
                }
                case BOOLEAN: {
                    return ValueKind.I1.type;
                }
                case FLOATING: {
                    switch ((int)type.getSize()) {
                        case 32: {
                            return ValueKind.FLOAT.type;
                        }
                        case 64: {
                            return ValueKind.DOUBLE.type;
                        }
                        case 128: {
                            if (LLVMLanguage.get(null).getCapability(PlatformCapability.class).getDoubleLongSize() == 80) {
                                return ValueKind.FP80.type;
                            }
                            if (LLVMLanguage.get(null).getCapability(PlatformCapability.class).getDoubleLongSize() != 128) break;
                            return ValueKind.FP128.type;
                        }
                    }
                    break;
                }
                case SIGNED: 
                case SIGNED_CHAR: 
                case UNSIGNED: 
                case UNSIGNED_CHAR: {
                    switch ((int)type.getSize()) {
                        case 1: {
                            return ValueKind.I1.type;
                        }
                        case 8: {
                            return ValueKind.I8.type;
                        }
                        case 16: {
                            return ValueKind.I16.type;
                        }
                        case 32: {
                            return ValueKind.I32.type;
                        }
                        case 64: {
                            return ValueKind.I64.type;
                        }
                    }
                }
            }
            return UNKNOWN;
        }

        private Value convertPointer(LLVMSourcePointerType type) {
            return Value.pointer(this.getStructured(type.getBaseType()), type.getSize() / 8L);
        }

        private final class Register {
            private final LLVMSourceType source;
            private final LLVMSourceType target;

            private Register(LLVMSourceType source, LLVMSourceType target) {
                this.source = source;
                this.target = target;
            }

            LLVMInteropType get(LLVMInteropType self) {
                return this.get(self, false);
            }

            LLVMInteropType get(LLVMInteropType self, boolean isMethod) {
                if (!isMethod) {
                    assert (!InteropTypeRegistry.this.typeCache.containsKey((Object)this.source));
                    InteropTypeRegistry.this.typeCache.put((Object)this.source, (Object)self);
                }
                return InteropTypeRegistry.this.get(this.target);
            }
        }
    }

    public static final class Method
    extends Function {
        private final Clazz clazz;
        private final String name;
        private final String linkageName;
        private final long virtualIndex;

        Method(Clazz clazz, String name, String linkageName, InteropTypeRegistry.Register returnType, LLVMInteropType[] parameterTypes, long virtualIndex) {
            super(returnType, parameterTypes, true);
            this.clazz = clazz;
            this.name = name;
            this.linkageName = linkageName;
            this.virtualIndex = virtualIndex;
        }

        public Clazz getObjectClass() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public String getLinkageName() {
            return this.linkageName;
        }

        public long getVirtualIndex() {
            return this.virtualIndex;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return "<recursive function type>";
            }
            visited.add((Object)this);
            return String.format("%s %s(%s)", this.returnType == null ? "void" : this.returnType.toString(visited), this.name, Arrays.stream(this.parameterTypes).map(t -> t == null ? "<null>" : t.toString(visited)).collect(Collectors.joining(", ")));
        }
    }

    public static class Function
    extends Structured {
        final LLVMInteropType returnType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final LLVMInteropType[] parameterTypes;

        Function(InteropTypeRegistry.Register returnType, LLVMInteropType[] parameterTypes, boolean isMethod) {
            super(0L);
            this.returnType = returnType.get(this, isMethod);
            this.parameterTypes = parameterTypes;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return "<recursive function type>";
            }
            visited.add((Object)this);
            return String.format("%s(%s)", this.returnType == null ? "void" : this.returnType.toString(visited), Arrays.stream(this.parameterTypes).map(t -> t == null ? "<null>" : t.toString(visited)).collect(Collectors.joining(", ")));
        }

        public LLVMInteropType getReturnType() {
            return this.returnType;
        }

        public LLVMInteropType getParameter(int i) {
            return this.parameterTypes[i];
        }

        public int getNumberOfParameters() {
            return this.parameterTypes.length;
        }
    }

    public static class SpecialStructAccessor {
        public final String name;
        public final long startOffset;
        public final long endOffset;
        public final LLVMInteropType type;
        public final SpecialStructGetter getter;

        public SpecialStructAccessor(String name, long startOffset, long endOffset, LLVMInteropType type, SpecialStructGetter getter) {
            this.name = name;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
            this.getter = getter;
        }

        boolean contains(long offset) {
            return this.startOffset <= offset && this.startOffset == this.endOffset | offset < this.endOffset;
        }
    }

    @FunctionalInterface
    public static interface SpecialStructGetter {
        public Object get(Object var1, InteropLibrary var2) throws UnsupportedMessageException;
    }

    public static final class StructMember {
        public final Struct struct;
        public final String name;
        public final long startOffset;
        public final long endOffset;
        public final LLVMInteropType type;
        public final boolean isInheritanceMember;

        StructMember(Struct struct, String name, long startOffset, long endOffset, LLVMInteropType type, boolean isInheritanceMember) {
            this.struct = struct;
            this.name = name;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
            this.isInheritanceMember = isInheritanceMember;
        }

        boolean contains(long offset) {
            return this.startOffset <= offset && this.startOffset == this.endOffset | offset < this.endOffset;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RemoveSelfArgument
    implements TruffleObject {
        private final Object foreignMethodObject;

        RemoveSelfArgument(Object foreignMethodObject) {
            this.foreignMethodObject = foreignMethodObject;
        }

        @ExportMessage
        boolean isExecutable() {
            return InteropLibrary.getUncached((Object)this.foreignMethodObject).isExecutable(this.foreignMethodObject);
        }

        @ExportMessage
        Object execute(Object[] arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            Object[] newArguments = new Object[arguments.length - 1];
            for (int i = 1; i < arguments.length; ++i) {
                newArguments[i - 1] = arguments[i];
            }
            return InteropLibrary.getUncached((Object)this.foreignMethodObject).execute(this.foreignMethodObject, newArguments);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class VTableObjectPair
    implements TruffleObject {
        private final VTable vtable;
        final Object foreign;

        private VTableObjectPair(VTable vtable, Object foreign) {
            this.vtable = vtable;
            this.foreign = foreign;
        }

        public static VTableObjectPair create(VTable vtable, Object foreign) {
            return new VTableObjectPair(vtable, foreign);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        Object readArrayElement(long index, @CachedLibrary(value="this.foreign") InteropLibrary foreignInterop) throws UnsupportedMessageException, InvalidArrayIndexException {
            Method m = this.vtable.findMethod(index);
            if (m == null) {
                throw InvalidArrayIndexException.create((long)index);
            }
            String methodName = m.getName();
            try {
                Object readMember = foreignInterop.readMember(this.foreign, methodName);
                return new RemoveSelfArgument(readMember);
            }
            catch (UnknownIdentifierException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                String msg = String.format("External method %s (identifier \"%s\") not found in type %s", methodName, e.getUnknownIdentifier(), this.foreign.getClass().getSimpleName());
                throw new IllegalStateException(msg);
            }
        }

        @ExportMessage
        long getArraySize() {
            return this.vtable.table.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < this.getArraySize();
        }
    }

    public static final class VTable {
        final Method[] table;
        final Clazz clazz;

        VTable(Clazz clazz) {
            this.clazz = clazz;
            int maxIndex = -1;
            HashMap<Integer, Method> map = new HashMap<Integer, Method>();
            LinkedList<Clazz> list = new LinkedList<Clazz>(clazz.getSuperClasses());
            list.add(0, clazz);
            do {
                Clazz c = (Clazz)list.remove(0);
                list.addAll(c.getSuperClasses());
                for (Method m : c.methods) {
                    if (m == null || m.getVirtualIndex() < 0L) continue;
                    int idx = Type.toUnsignedInt(m.virtualIndex);
                    map.putIfAbsent(idx, m);
                    maxIndex = Math.max(maxIndex, idx);
                }
            } while (list.size() > 0);
            this.table = new Method[maxIndex + 1];
            for (Map.Entry entry : map.entrySet()) {
                this.table[((Integer)entry.getKey()).intValue()] = (Method)entry.getValue();
            }
        }

        public Method findMethod(long virtualIndex) {
            if (Long.compareUnsigned(virtualIndex, this.table.length) >= 0) {
                return null;
            }
            return this.table[Type.toUnsignedInt(virtualIndex)];
        }
    }

    public static final class Clazz
    extends Struct {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Method[] methods;
        private SortedSet<TypeInheritance> superTypes;
        private VTable vtable;
        private boolean virtualMethodsInitialized;
        private boolean virtualMethods;

        Clazz(String name, StructMember[] members, Method[] methods, long size) {
            super(name, members, size);
            this.methods = methods;
            this.vtable = null;
            this.virtualMethodsInitialized = false;
            this.superTypes = new TreeSet<TypeInheritance>((a, b) -> a.compareTo((TypeInheritance)b));
        }

        public void addSuperType(Struct superclass, long offset, boolean virtual) {
            this.superTypes.add(new TypeInheritance(superclass, offset, virtual));
        }

        public Method getMethod(int i) {
            return this.methods[i];
        }

        public int getMethodCount() {
            return this.methods.length;
        }

        @CompilerDirectives.TruffleBoundary
        public Method findMethod(String memberName) {
            for (Method method : this.methods) {
                if (method.getName().equals(memberName)) {
                    return method;
                }
                if (!method.getLinkageName().equals(memberName)) continue;
                return method;
            }
            for (TypeInheritance ci : this.superTypes) {
                Method method;
                if (!ci.isClass() || (method = ci.getSuperClass().findMethod(memberName)) == null) continue;
                return method;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public Pair<long[], Struct> getSuperOffsetInformation(String ident) throws UnknownIdentifierException {
            for (StructMember member : this.members) {
                if (!member.name.equals(ident)) continue;
                return Pair.create((Object)new long[0], (Object)this);
            }
            Pair<LinkedList<Long>, Struct> pair = this.getMemberAccessList(ident);
            if (pair == null) {
                throw UnknownIdentifierException.create((String)ident);
            }
            long[] arr = ((LinkedList)pair.getLeft()).stream().mapToLong(l -> l).toArray();
            return Pair.create((Object)arr, (Object)((Struct)pair.getRight()));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Pair<LinkedList<Long>, Struct> getMemberAccessList(String ident) throws UnknownIdentifierException {
            for (StructMember member : this.members) {
                if (!member.name.equals(ident)) continue;
                return Pair.create(new LinkedList(), (Object)this);
            }
            for (TypeInheritance ci : this.superTypes) {
                Pair<LinkedList<Long>, Struct> pair = ci.superType.getMemberAccessList(ident);
                if (pair == null) continue;
                for (StructMember member : this.members) {
                    if (!member.type.equals(ci.superType)) continue;
                    long offset = ci.virtual ? ci.offset : member.startOffset;
                    offset <<= 1;
                    ((LinkedList)pair.getLeft()).addFirst(offset |= ci.virtual ? 1L : 0L);
                    return pair;
                }
            }
            return null;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public StructMember findMember(String memberName) {
            for (StructMember member : this.members) {
                if (!member.name.equals(memberName)) continue;
                return member;
            }
            for (TypeInheritance ci : this.superTypes) {
                StructMember member = ci.superType.findMember(memberName);
                if (member == null) continue;
                return member;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public String[] getVtableAccessNames() {
            if (!this.hasVirtualMethods()) {
                throw new IllegalStateException("vtable of given LLVMInteropType.Clazz type does not exist");
            }
            ArrayList<String> list = new ArrayList<String>();
            StructMember structMember = this.findMember(0);
            list.add(structMember.name);
            while (structMember.type instanceof Clazz) {
                structMember = ((Clazz)structMember.type).findMember(0);
                list.add(structMember.name);
            }
            return list.toArray(new String[0]);
        }

        public Set<Struct> getSuperTypes() {
            return new HashSet<Struct>(this.superTypes.stream().map(ci -> ci.superType).collect(Collectors.toSet()));
        }

        public Set<Clazz> getSuperClasses() {
            return new HashSet<Clazz>(this.superTypes.stream().filter(TypeInheritance::isClass).map(TypeInheritance::getSuperClass).collect(Collectors.toSet()));
        }

        @CompilerDirectives.TruffleBoundary
        private void initVirtualMethods() {
            this.virtualMethodsInitialized = true;
            for (Method m : this.methods) {
                if (m.getVirtualIndex() < 0L) continue;
                this.virtualMethods = true;
                return;
            }
            for (TypeInheritance ci : this.superTypes) {
                if (!ci.isClass() || !ci.getSuperClass().hasVirtualMethods()) continue;
                this.virtualMethods = true;
                return;
            }
            this.virtualMethods = false;
        }

        @Idempotent
        public boolean hasVirtualMethods() {
            if (!this.virtualMethodsInitialized) {
                this.initVirtualMethods();
            }
            return this.virtualMethods;
        }

        public VTable getVTable() {
            if (this.vtable == null) {
                this.buildVTable();
            }
            return this.vtable;
        }

        @CompilerDirectives.TruffleBoundary
        public void buildVTable() {
            this.virtualMethodsInitialized = false;
            if (this.vtable == null && this.hasVirtualMethods()) {
                for (TypeInheritance ci : this.superTypes) {
                    if (!ci.isClass()) continue;
                    ci.getSuperClass().buildVTable();
                }
                this.vtable = new VTable(this);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public Method findMethodByArgumentsWithSelf(String memberName, Object[] arguments) throws ArityException {
            int expectedArgCount = -1;
            for (Method method : this.methods) {
                if (method.getName().equals(memberName)) {
                    LLVMInteropType[] types = method.parameterTypes;
                    if (types.length + 1 == arguments.length) {
                        return method;
                    }
                    expectedArgCount = types.length;
                    continue;
                }
                if (!method.getLinkageName().equals(memberName)) continue;
                return method;
            }
            for (TypeInheritance ci : this.superTypes) {
                Method m;
                if (!ci.isClass() || (m = ci.getSuperClass().findMethodByArgumentsWithSelf(memberName, arguments)) == null) continue;
                return m;
            }
            if (expectedArgCount >= 0) {
                throw ArityException.create((int)expectedArgCount, (int)expectedArgCount, (int)(arguments.length - 1));
            }
            return null;
        }
    }

    public static final class TypeInheritance
    implements Comparable<TypeInheritance> {
        public final Struct superType;
        public final long offset;
        public final boolean virtual;

        public TypeInheritance(Struct superType, long offset, boolean virtual) {
            this.superType = superType;
            this.offset = offset;
            this.virtual = virtual;
        }

        @Override
        public int compareTo(TypeInheritance other) {
            if (this.virtual == other.virtual) {
                return Long.compare(this.offset, other.offset);
            }
            return this.virtual ? 1 : -1;
        }

        public boolean isClass() {
            return this.superType instanceof Clazz;
        }

        Clazz getSuperClass() {
            assert (this.isClass());
            return (Clazz)this.superType;
        }
    }

    public static class TimeInfo
    extends SpecialStruct {
        public TimeInfo(Struct struct) {
            super("TimeInfo", struct, new SpecialStructAccessor[]{TimeInfo.accessorForField(struct, "tm_hour", (foreign, interop) -> interop.asTime(foreign).getHour()), TimeInfo.accessorForField(struct, "tm_min", (foreign, interop) -> interop.asTime(foreign).getMinute()), TimeInfo.accessorForField(struct, "tm_sec", (foreign, interop) -> interop.asTime(foreign).getSecond()), TimeInfo.accessorForField(struct, "tm_mday", (foreign, interop) -> interop.asDate(foreign).getDayOfMonth()), TimeInfo.accessorForField(struct, "tm_mon", (foreign, interop) -> interop.asDate(foreign).getMonthValue() - 1), TimeInfo.accessorForField(struct, "tm_year", (foreign, interop) -> interop.asDate(foreign).getYear() - 1900), TimeInfo.accessorForField(struct, "tm_wday", (foreign, interop) -> TimeInfo.getWDay(interop.asDate(foreign))), TimeInfo.accessorForField(struct, "tm_yday", (foreign, interop) -> TimeInfo.getYDay(interop.asDate(foreign)))});
        }

        @CompilerDirectives.TruffleBoundary
        static int getWDay(LocalDate date) {
            return date.getDayOfWeek().ordinal() % 7;
        }

        @CompilerDirectives.TruffleBoundary
        static int getYDay(LocalDate date) {
            return date.getDayOfYear() - 1;
        }
    }

    public static class Instant
    extends SpecialStruct {
        public Instant(Struct struct) {
            super("Instant", struct, new SpecialStructAccessor[]{Instant.accessorForField(struct, "seconds", (foreign, interop) -> interop.asInstant(foreign).getEpochSecond())});
        }
    }

    public static abstract class SpecialStruct
    extends Structured {
        final Struct struct;
        final String name;
        final SpecialStructAccessor[] accessors;

        protected SpecialStruct(String name, Struct struct, SpecialStructAccessor[] accessors) {
            super(struct.getSize());
            this.struct = struct;
            this.name = name;
            this.accessors = accessors;
        }

        public Struct getStruct() {
            return this.struct;
        }

        SpecialStructAccessor findAccessor(long offset) {
            for (SpecialStructAccessor accessor : this.accessors) {
                if (!accessor.contains(offset)) continue;
                return accessor;
            }
            return null;
        }

        protected static SpecialStructAccessor accessorForField(Struct struct, String memberName, SpecialStructGetter getter) {
            StructMember field = struct.findMember(memberName);
            return new SpecialStructAccessor(memberName, field.startOffset, field.endOffset, field.type, getter);
        }

        @Override
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            return this.name;
        }
    }

    public static class Struct
    extends Structured {
        protected final String name;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final StructMember[] members;

        Struct(String name, StructMember[] members, long size) {
            super(size);
            this.name = name;
            this.members = members;
        }

        public StructMember getMember(int i) {
            return this.members[i];
        }

        @CompilerDirectives.TruffleBoundary
        public StructMember findMember(String memberName) {
            for (StructMember member : this.members) {
                if (!member.name.equals(memberName)) continue;
                return member;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public StructMember findMember(int startOffset) {
            for (StructMember member : this.members) {
                if (member.startOffset != (long)startOffset) continue;
                return member;
            }
            return null;
        }

        public int getMemberCount() {
            return this.members.length;
        }

        @Override
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            return this.name;
        }

        protected Pair<LinkedList<Long>, Struct> getMemberAccessList(String ident) throws UnknownIdentifierException {
            for (StructMember member : this.members) {
                if (!member.name.equals(ident)) continue;
                return Pair.create(new LinkedList(), (Object)this);
            }
            return null;
        }
    }

    public static abstract class Structured
    extends LLVMInteropType {
        Structured(long size) {
            super(size);
        }
    }
}

