/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.target;

import java.util.Objects;

public final class TargetTriple {
    private static final String MACOSX_SYSTEM_NAME = "macosx";
    private static final String MSVC_ABI = "msvc";
    private final String triple;
    private final String arch;
    private final String vendor;
    private final String systemName;
    private final String systemVersion;
    private final String abi;

    public static TargetTriple create(String triple) {
        String systemVersion;
        String systemName;
        String abi;
        String[] s = triple.split("-", 4);
        if (s.length < 3) {
            throw new IllegalArgumentException("Malformed target-triple string: " + triple);
        }
        String arch = s[0];
        String vendor = s[1];
        String system = s[2];
        String string = abi = s.length == 4 ? s[3] : null;
        if (system.startsWith(MACOSX_SYSTEM_NAME)) {
            systemName = MACOSX_SYSTEM_NAME;
            systemVersion = system.substring(MACOSX_SYSTEM_NAME.length());
        } else {
            systemName = system;
            systemVersion = null;
        }
        if (abi != null && abi.startsWith(MSVC_ABI)) {
            String[] abiParts = abi.split("[.]", 2);
            abi = abiParts[0];
        }
        return new TargetTriple(triple, arch, vendor, systemName, systemVersion, abi);
    }

    private TargetTriple(String triple, String arch, String vendor, String systemName, String systemVersion, String abi) {
        this.triple = triple;
        this.arch = arch;
        this.vendor = vendor;
        this.systemName = systemName;
        this.systemVersion = systemVersion;
        this.abi = abi;
    }

    public String toString() {
        return this.triple;
    }

    public boolean matches(TargetTriple other) {
        return this.triple.equals(other.triple) || this.arch.equals(other.arch) && this.vendor.equals(other.vendor) && this.systemName.equals(other.systemName) && Objects.equals(this.abi, other.abi);
    }
}

