/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;

public final class LLVMThreadStart {

    public static final class LLVMPThreadFunctionRootNode
    extends LLVMRootNode {
        @Node.Child
        private LLVMExpressionNode callNode;
        private final int functionSlot;
        private final int argSlot;

        private LLVMPThreadFunctionRootNode(LLVMLanguage language, FrameDescriptor frameDescriptor, int functionSlot, int argSlot, NodeFactory nodeFactory) {
            super(language, frameDescriptor, nodeFactory.createStackAccess());
            this.functionSlot = functionSlot;
            this.argSlot = argSlot;
            this.callNode = CommonNodeFactory.createFunctionCall(LLVMReadNode.LLVMObjectReadNode.create(functionSlot), new LLVMExpressionNode[]{nodeFactory.createGetStackFromFrame(), LLVMReadNode.LLVMObjectReadNode.create(argSlot)}, FunctionType.create(PointerType.VOID, PointerType.VOID));
        }

        public static LLVMPThreadFunctionRootNode create(LLVMLanguage language, NodeFactory nodeFactory) {
            FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
            nodeFactory.addStackSlots(builder);
            int functionSlot = builder.addSlot(FrameSlotKind.Object, null, null);
            int argSlot = builder.addSlot(FrameSlotKind.Object, null, null);
            FrameDescriptor descriptor = builder.build();
            return new LLVMPThreadFunctionRootNode(language, descriptor, functionSlot, argSlot, nodeFactory);
        }

        public boolean isInternal() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            this.stackAccess.executeEnter(frame, this.getContext().getThreadingStack().getStack((Node)this));
            try {
                Object[] arguments = frame.getArguments();
                Object function = arguments[0];
                Object arg = arguments[1];
                frame.setObject(this.functionSlot, function);
                frame.setObject(this.argSlot, arg);
                Object object = this.callNode.executeGeneric(frame);
                return object;
            }
            finally {
                this.stackAccess.executeExit(frame);
            }
        }
    }

    static final class LLVMThreadRunnable
    implements Runnable {
        private final Object startRoutine;
        private final Object arg;
        private final LLVMContext context;

        LLVMThreadRunnable(Object startRoutine, Object arg, LLVMContext context) {
            this.startRoutine = startRoutine;
            this.arg = arg;
            this.context = context;
        }

        @Override
        public void run() {
            LLVMPThreadContext pThreadContext = this.context.getpThreadContext();
            try {
                Object returnValue = pThreadContext.getPthreadCallTarget().call(new Object[]{this.startRoutine, this.arg});
                if (returnValue == null) {
                    returnValue = LLVMNativePointer.createNull();
                }
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), returnValue);
            }
            catch (PThreadExitException returnValue) {
            }
            catch (Throwable t) {
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), LLVMNativePointer.createNull());
                throw t;
            }
            finally {
                if (!this.context.getEnv().getContext().isClosed()) {
                    pThreadContext.callDestructors(this.context);
                }
            }
        }
    }
}

