/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.VarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorageFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

@ExportLibrary(value=InteropLibrary.class)
public class LLVMVaListStorage
implements TruffleObject {
    public static final String GET_MEMBER = "get";
    public static final String NEXT_MEMBER = "next";
    public Object[] realArguments;
    protected int numberOfExplicitArguments;
    protected LLVMPointer vaListStackPtr;
    protected boolean nativized;
    public static final boolean UNPACK_32BIT_PRIMITIVES_IN_STRUCTS = true;
    public static final boolean KEEP_32BIT_PRIMITIVES_IN_STRUCTS = false;

    public static VarArgArea getVarArgArea(Object arg) {
        if (arg instanceof Boolean) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Byte) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Short) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Integer) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Long) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof Float) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof Double) {
            return VarArgArea.FP_AREA;
        }
        if (arg instanceof LLVMVarArgCompoundValue) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (LLVMPointer.isInstance(arg)) {
            return VarArgArea.GP_AREA;
        }
        if (arg instanceof LLVM80BitFloat) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (arg instanceof LLVMFloatVector && ((LLVMFloatVector)arg).getLength() <= 2) {
            return VarArgArea.FP_AREA;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
    }

    public static VarArgArea getVarArgArea(Type type) {
        if (type == PrimitiveType.I1) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I8) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I16) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I32) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.I64) {
            return VarArgArea.GP_AREA;
        }
        if (type == PrimitiveType.FLOAT) {
            return VarArgArea.FP_AREA;
        }
        if (type == PrimitiveType.DOUBLE) {
            return VarArgArea.FP_AREA;
        }
        if (type == PrimitiveType.X86_FP80) {
            return VarArgArea.OVERFLOW_AREA;
        }
        if (LLVMVaListStorage.isFloatVectorWithMaxTwoElems(type)) {
            return VarArgArea.FP_AREA;
        }
        if (LLVMVaListStorage.isFloatArrayWithMaxTwoElems(type)) {
            return VarArgArea.FP_AREA;
        }
        if (type instanceof PointerType) {
            return VarArgArea.GP_AREA;
        }
        return VarArgArea.OVERFLOW_AREA;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFloatVectorWithMaxTwoElems(Type type) {
        return type instanceof VectorType && LLVMVaListStorage.getVectorElementType(type) == PrimitiveType.FLOAT && ((VectorType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFloatArrayWithMaxTwoElems(Type type) {
        return type instanceof ArrayType && LLVMVaListStorage.getArrayElementType(type) == PrimitiveType.FLOAT && ((ArrayType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isDoubleVectorWithMaxTwoElems(Type type) {
        return type instanceof VectorType && LLVMVaListStorage.getVectorElementType(type) == PrimitiveType.DOUBLE && ((VectorType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isDoubleArrayWithMaxTwoElems(Type type) {
        return type instanceof ArrayType && LLVMVaListStorage.getArrayElementType(type) == PrimitiveType.DOUBLE && ((ArrayType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isI64VectorWithMaxTwoElems(Type type) {
        return type instanceof VectorType && LLVMVaListStorage.getVectorElementType(type) == PrimitiveType.I64 && ((VectorType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isI64ArrayWithMaxTwoElems(Type type) {
        return type instanceof ArrayType && LLVMVaListStorage.getArrayElementType(type) == PrimitiveType.I64 && ((ArrayType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isI32VectorWithMaxTwoElems(Type type) {
        return type instanceof VectorType && LLVMVaListStorage.getVectorElementType(type) == PrimitiveType.I32 && ((VectorType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isI32ArrayWithMaxTwoElems(Type type) {
        return type instanceof ArrayType && LLVMVaListStorage.getArrayElementType(type) == PrimitiveType.I32 && ((ArrayType)type).getNumberOfElements() <= 2L;
    }

    @CompilerDirectives.TruffleBoundary
    private static Type getVectorElementType(Type type) {
        return ((VectorType)type).getElementType();
    }

    @CompilerDirectives.TruffleBoundary
    private static Type getArrayElementType(Type type) {
        return ((ArrayType)type).getElementType();
    }

    protected static DataLayout findDataLayoutFromCurrentFrame() {
        RootCallTarget callTarget = (RootCallTarget)Truffle.getRuntime().iterateFrames(f -> f.getCallTarget());
        return ((LLVMHasDatalayoutNode)callTarget.getRootNode()).getDatalayout();
    }

    public static long storeArgument(LLVMPointer ptr, long offset, LLVMMemMoveNode memmove, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, LLVMI32StoreNode.LLVMI32OffsetStoreNode storeI32Node, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode storeFP80Node, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode, Object object, int stackStep) {
        if (object instanceof Number) {
            return LLVMVaListStorage.doPrimitiveWrite(ptr, offset, storeI64Node, object, stackStep);
        }
        if (object instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)object;
            LLVMPointer currentPtr = ptr.increment(offset);
            memmove.executeWithTarget(currentPtr, obj.getAddr(), obj.getSize());
            return obj.getSize();
        }
        if (LLVMPointer.isInstance(object)) {
            storePointerNode.executeWithTarget(ptr, offset, object);
            return stackStep;
        }
        if (object instanceof LLVM80BitFloat) {
            storeFP80Node.executeWithTarget(ptr, offset, (LLVM80BitFloat)object);
            return 16L;
        }
        if (object instanceof LLVMFloatVector) {
            LLVMFloatVector floatVec = (LLVMFloatVector)object;
            for (int i = 0; i < floatVec.getLength(); ++i) {
                storeI32Node.executeWithTarget(ptr, offset + (long)(i * 4), Float.floatToIntBits(floatVec.getValue(i)));
            }
            return floatVec.getLength() * 4;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(object));
    }

    private static int doPrimitiveWrite(LLVMPointer ptr, long offset, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode, Object arg, int stackStep) throws AssertionError {
        long value;
        if (arg instanceof Boolean) {
            value = (Boolean)arg != false ? 1L : 0L;
        } else if (arg instanceof Byte) {
            value = Integer.toUnsignedLong(((Byte)arg).byteValue());
        } else if (arg instanceof Short) {
            value = Integer.toUnsignedLong(((Short)arg).shortValue());
        } else if (arg instanceof Integer) {
            value = Integer.toUnsignedLong((Integer)arg);
        } else if (arg instanceof Long) {
            value = (Long)arg;
        } else if (arg instanceof Float) {
            value = Integer.toUnsignedLong(Float.floatToIntBits(((Float)arg).floatValue()));
        } else if (arg instanceof Double) {
            value = Double.doubleToRawLongBits((Double)arg);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
        }
        storeNode.executeWithTarget(ptr, offset, value);
        return stackStep;
    }

    protected LLVMVaListStorage(LLVMPointer vaListStackPtr) {
        this.vaListStackPtr = vaListStackPtr;
    }

    public boolean isNativized() {
        return this.nativized;
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return new VAListMembers();
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.realArguments.length - this.numberOfExplicitArguments;
    }

    @ExportMessage
    public boolean isArrayElementReadable(long index) {
        return index < (long)(this.realArguments.length - this.numberOfExplicitArguments);
    }

    @ExportMessage
    public Object readArrayElement(long index, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) {
        Object arg = this.realArguments[(int)index + this.numberOfExplicitArguments];
        return pointerEscapeNode.executeWithTarget(arg);
    }

    @ExportMessage
    public boolean isPointer() {
        return this.isNativized() && LLVMNativePointer.isInstance(this.vaListStackPtr);
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return LLVMNativePointer.cast(this.vaListStackPtr).asNative();
        }
        throw UnsupportedMessageException.create();
    }

    public static enum VarArgArea {
        GP_AREA,
        FP_AREA,
        OVERFLOW_AREA;

    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class VAListMembers
    implements TruffleObject {
        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 2L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L || index == 1L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return LLVMVaListStorage.GET_MEMBER;
            }
            if (index == 1L) {
                return LLVMVaListStorage.NEXT_MEMBER;
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @GenerateUncached
    public static abstract class LoadFromAreaNode
    extends LLVMNode {
        public abstract Object execute(LLVMPointer var1, int var2, int var3, int var4, Type var5);

        @Specialization
        static Object load(LLVMPointer vaList, int saveAreaOffset, int offsetInArea, int incrementArea, Type type, @Cached LLVMI1LoadNode.LLVMI1OffsetLoadNode loadI1, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadI8, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode loadI16, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadI32, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadI64, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode loadPointer, @Cached LLVMFloatLoadNode.LLVMFloatOffsetLoadNode loadFloat, @Cached LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode loadDouble, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode regSaveAreaLoad, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode store) {
            LLVMPointer areaPtr = regSaveAreaLoad.executeWithTarget(vaList, saveAreaOffset);
            if (incrementArea != 0) {
                store.executeWithTarget(vaList, saveAreaOffset, areaPtr.increment(incrementArea));
            }
            if (type instanceof PrimitiveType) {
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case DOUBLE: {
                        return loadDouble.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case FLOAT: {
                        return loadFloat.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case I1: {
                        return loadI1.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case I16: {
                        return loadI16.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case I32: {
                        return loadI32.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case I64: {
                        return loadI64.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                    case I8: {
                        return loadI8.executeWithTargetGeneric(areaPtr, offsetInArea);
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
            }
            if (type instanceof PointerType) {
                return loadPointer.executeWithTargetGeneric(areaPtr, offsetInArea);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
        }
    }

    public static final class ArgumentListExpander
    extends LLVMNode {
        private final BranchProfile expansionBranchProfile;
        private final ConditionProfile noExpansionProfile;
        @Node.Child
        private ArgumentExpander expander;
        private final boolean cached;
        private static final ArgumentListExpander uncached_unpack32 = new ArgumentListExpander(false, true);
        private static final ArgumentListExpander uncached_no_unpack32 = new ArgumentListExpander(false, false);

        private ArgumentListExpander(boolean cached, boolean unpack32) {
            this.expansionBranchProfile = cached ? BranchProfile.create() : BranchProfile.getUncached();
            ConditionProfile conditionProfile = this.noExpansionProfile = cached ? ConditionProfile.create() : ConditionProfile.getUncached();
            this.expander = cached ? (unpack32 ? LLVMVaListStorageFactory.ArgumentListExpanderFactory.Unpack32ArgumentExpanderNodeGen.create() : LLVMVaListStorageFactory.ArgumentListExpanderFactory.ArgumentExpanderNodeGen.create()) : (unpack32 ? LLVMVaListStorageFactory.ArgumentListExpanderFactory.Unpack32ArgumentExpanderNodeGen.getUncached() : LLVMVaListStorageFactory.ArgumentListExpanderFactory.ArgumentExpanderNodeGen.getUncached());
            this.cached = cached;
        }

        public boolean isAdoptable() {
            return this.cached;
        }

        public static ArgumentListExpander create(boolean unpack32) {
            return new ArgumentListExpander(true, unpack32);
        }

        public static ArgumentListExpander getUncached(boolean unpack32) {
            return unpack32 ? uncached_unpack32 : uncached_no_unpack32;
        }

        public Object[] expand(Object[] args, Object[][][] expansionsOutArg) {
            Object[][] expansions = null;
            int extraSize = 0;
            for (int i = 0; i < args.length; ++i) {
                Object[] expansion = this.expander.execute(args[i]);
                if (expansion == null) continue;
                this.expansionBranchProfile.enter();
                if (expansions == null) {
                    expansions = new Object[args.length][];
                }
                expansions[i] = expansion;
                extraSize += expansion.length - 1;
            }
            expansionsOutArg[0] = expansions;
            return this.noExpansionProfile.profile(expansions == null) ? args : ArgumentListExpander.expandArgs(args, expansions, extraSize);
        }

        static Object[] expandArgs(Object[] args, Object[][] expansions, int extraSize) {
            Object[] result = new Object[args.length + extraSize];
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                if (expansions[i] == null) {
                    result[j] = args[i];
                    ++j;
                    continue;
                }
                for (int k = 0; k < expansions[i].length; ++k) {
                    result[j] = expansions[i][k];
                    ++j;
                }
            }
            return result;
        }

        @ImportStatic(value={LLVMVaListStorage.class})
        @GenerateUncached
        public static abstract class Unpack32ArgumentExpander
        extends ArgumentExpander {
            @Specialization(guards={"isFloatArrayWithMaxTwoElems(arg.getType()) || isFloatVectorWithMaxTwoElems(arg.getType())"})
            protected Object[] expandFloatArrayOrVectorCompoundArg(LLVMVarArgCompoundValue arg, @Cached IntegerConversionHelperNode convNode) {
                return new Object[]{Float.valueOf(Float.intBitsToFloat(convNode.executeInteger(arg, 0))), Float.valueOf(Float.intBitsToFloat(convNode.executeInteger(arg, 4)))};
            }

            @Specialization(guards={"isI32ArrayWithMaxTwoElems(arg.getType()) || isI32VectorWithMaxTwoElems(arg.getType())"})
            protected Object[] expandI32ArrayOrVectorCompoundArg(LLVMVarArgCompoundValue arg, @Cached IntegerConversionHelperNode convNode) {
                return new Object[]{convNode.executeInteger(arg, 0), convNode.executeInteger(arg, 4)};
            }
        }

        @ImportStatic(value={LLVMVaListStorage.class})
        @GenerateUncached
        public static abstract class ArgumentExpander
        extends LLVMNode {
            public abstract Object[] execute(Object var1);

            @Specialization(guards={"isDoubleArrayWithMaxTwoElems(arg.getType()) || isDoubleVectorWithMaxTwoElems(arg.getType())"})
            protected Object[] expandDoubleArrayOrVectorCompoundArg(LLVMVarArgCompoundValue arg, @Cached LongConversionHelperNode convNode) {
                return new Object[]{Double.longBitsToDouble(convNode.executeLong(arg, 0)), Double.longBitsToDouble(convNode.executeLong(arg, 8))};
            }

            @Specialization(guards={"isI64ArrayWithMaxTwoElems(arg.getType()) || isI64VectorWithMaxTwoElems(arg.getType())"})
            protected Object[] expandI64ArrayOrVectorCompoundArg(LLVMVarArgCompoundValue arg, @Cached LongConversionHelperNode convNode) {
                return new Object[]{convNode.executeLong(arg, 0), convNode.executeLong(arg, 8)};
            }

            @Fallback
            protected Object[] noExpansion(Object arg) {
                return null;
            }
        }
    }

    @GenerateUncached
    public static abstract class PointerConversionHelperNode
    extends NumberConversionHelperNode {
        @Specialization
        LLVMPointer pointerConversion(LLVMPointer p, int offset) {
            assert (offset == 0);
            return p;
        }

        @Specialization
        LLVMPointer longObjectConversion(long x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.create(x);
        }

        @Specialization
        LLVMPointer intObjectConversion(int x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.create(x);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        LLVMPointer compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        LLVMPointer compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readPointer(ptr.getObject(), offset);
        }

        @Fallback
        LLVMPointer fallackConversion(Object x, int offset) {
            return LLVMNativePointer.createNull();
        }

        public static PointerConversionHelperNode create() {
            return LLVMVaListStorageFactory.PointerConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    public static abstract class LongConversionHelperNode
    extends NumberConversionHelperNode {
        public long executeLong(Object x, int offset) {
            return (Long)this.execute(x, offset);
        }

        @Specialization
        long byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long intConversion(Integer x, int offset) {
            assert (offset == 0);
            return x.longValue();
        }

        @Specialization
        long longConversion(Long x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        long doubleConversion(Double x, int offset) {
            assert (offset == 0);
            return Double.doubleToLongBits(x);
        }

        @Specialization
        long floatVectorConversion(LLVMFloatVector x, int offset) {
            int index = offset / 4;
            assert (index + 1 < x.getLength());
            long low = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            long high = Float.floatToIntBits(((Float)x.getElement(index + 1)).floatValue());
            return low + (high << 32);
        }

        @Specialization
        long doubleVectorConversion(LLVMDoubleVector x, int offset) {
            int index = offset / 8;
            assert (index < x.getLength());
            return Double.doubleToLongBits((Double)x.getElement(index));
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        long compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode offsetLoad) {
            try {
                return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        Object compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readGenericI64(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        long nativePointerConversion(LLVMPointer x, int offset) {
            assert (offset == 0);
            return LLVMNativePointer.cast(x).asNative();
        }

        @Specialization(guards={"isManagedPointer(x)"})
        Object managedPointerConversion(LLVMPointer x, int offset) {
            assert (offset == 0);
            return x;
        }

        public static LongConversionHelperNode create() {
            return LLVMVaListStorageFactory.LongConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    public static abstract class IntegerConversionHelperNode
    extends NumberConversionHelperNode {
        public int executeInteger(Object x, int offset) {
            return (Integer)this.execute(x, offset);
        }

        int byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.intValue();
        }

        @Specialization
        int shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x.intValue();
        }

        @Specialization
        int intConversion(Integer x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        int floatConversion(Float x, int offset) {
            return Float.floatToIntBits(x.floatValue());
        }

        @Specialization
        int longConversion(Long x, int offset, @Cached ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.intValue();
            }
            assert (offset == 4) : "Illegal long offset " + offset;
            return (int)(x >> 32);
        }

        @Specialization
        int doubleConversion(Double x, int offset, @Cached ConditionProfile conditionProfile) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile);
        }

        @Specialization
        int floatVectorConversion(LLVMFloatVector x, int offset) {
            int index = offset / 4;
            assert (index < x.getLength());
            return Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        int compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        int compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI32(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        int nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached ConditionProfile conditionProfile) {
            return this.longConversion(LLVMNativePointer.cast(x).asNative(), offset, conditionProfile);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        int managedPointerObjectConversion(LLVMManagedPointer x, int offset, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer, @Cached ConditionProfile conditionProfile) {
            LLVMNativePointer nativePointer = toNativePointer.execute(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile);
        }

        public static IntegerConversionHelperNode create() {
            return LLVMVaListStorageFactory.IntegerConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    public static abstract class ShortConversionHelperNode
    extends NumberConversionHelperNode {
        @Specialization
        short byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x.shortValue();
        }

        @Specialization
        short shortConversion(Short x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        short intConversion(Integer x, int offset, @Cached ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.shortValue();
            }
            assert (offset == 2) : "Illegal integer offset " + offset;
            return (short)(x >> 16);
        }

        @Specialization
        short longConversion(Long x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            if (conditionProfile1.profile(offset < 4)) {
                return this.intConversion(x.intValue(), offset, conditionProfile2);
            }
            return this.intConversion((int)(x >> 32), offset % 4, conditionProfile2);
        }

        @Specialization
        short doubleConversion(Double x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile1, conditionProfile2);
        }

        @Specialization
        short floatVectorConversion(LLVMFloatVector x, int offset, @Cached ConditionProfile conditionProfile) {
            int index = offset / 4;
            assert (index < x.getLength());
            int fi = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            return this.intConversion(fi, offset, conditionProfile);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        short compoundObjectConversion(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            return compObjReadLib.readI16(x.getAddr(), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        short compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI16(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        short nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            return this.longConversion(x.asNative(), offset, conditionProfile1, conditionProfile2);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        short managedPointerObjectConversion(LLVMManagedPointer x, int offset, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            LLVMNativePointer nativePointer = toNativePointer.execute(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile1, conditionProfile2);
        }

        public static ShortConversionHelperNode create() {
            return LLVMVaListStorageFactory.ShortConversionHelperNodeGen.create();
        }
    }

    @GenerateUncached
    public static abstract class ByteConversionHelperNode
    extends NumberConversionHelperNode {
        @Specialization
        byte byteConversion(Byte x, int offset) {
            assert (offset == 0);
            return x;
        }

        @Specialization
        byte shortConversion(Short x, int offset, @Cached ConditionProfile conditionProfile) {
            if (conditionProfile.profile(offset == 0)) {
                return x.byteValue();
            }
            assert (offset == 1) : "Illegal short offset " + offset;
            return (byte)(x >> 8);
        }

        @Specialization
        byte intConversion(Integer x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            if (conditionProfile1.profile(offset < 2)) {
                return this.shortConversion(x.shortValue(), offset, conditionProfile2);
            }
            return this.shortConversion((short)(x >> 16), offset % 2, conditionProfile2);
        }

        @Specialization
        byte longConversion(Long x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2, @Cached ConditionProfile conditionProfile3) {
            if (conditionProfile1.profile(offset < 4)) {
                return this.intConversion(x.intValue(), offset, conditionProfile2, conditionProfile3);
            }
            return this.intConversion((int)(x >> 32), offset % 4, conditionProfile2, conditionProfile3);
        }

        @Specialization
        byte doubleConversion(Double x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2, @Cached ConditionProfile conditionProfile3) {
            return this.longConversion(Double.doubleToLongBits(x), offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        @Specialization
        byte float80Conversion(LLVM80BitFloat x, int offset) {
            assert (offset < 10);
            return x.getBytes()[offset];
        }

        @Specialization
        byte floatVectorConversion(LLVMFloatVector x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2) {
            int index = offset / 4;
            assert (index < x.getLength());
            int fi = Float.floatToIntBits(((Float)x.getElement(index)).floatValue());
            return this.intConversion(fi, offset, conditionProfile1, conditionProfile2);
        }

        @Specialization(guards={"isNativePointer(x.getAddr())"})
        byte compoundObjectConversionNative(LLVMVarArgCompoundValue x, int offset, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(LLVMNativePointer.cast(x.getAddr()), offset);
        }

        @Specialization(guards={"!isNativePointer(x.getAddr())"})
        byte compoundObjectConversionManaged(LLVMVarArgCompoundValue x, int offset, @CachedLibrary(limit="1") LLVMManagedReadLibrary compObjReadLib) {
            LLVMManagedPointer ptr = LLVMManagedPointer.cast(x.getAddr());
            return compObjReadLib.readI8(ptr.getObject(), offset);
        }

        @Specialization(guards={"isNativePointer(x)"})
        byte nativePointerObjectConversion(LLVMNativePointer x, int offset, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2, @Cached ConditionProfile conditionProfile3) {
            return this.longConversion(x.asNative(), offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        @Specialization(guards={"!isNativePointer(x)"})
        byte managedPointerObjectConversion(LLVMManagedPointer x, int offset, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer, @Cached ConditionProfile conditionProfile1, @Cached ConditionProfile conditionProfile2, @Cached ConditionProfile conditionProfile3) {
            LLVMNativePointer nativePointer = toNativePointer.execute(x.getObject());
            return this.nativePointerObjectConversion(nativePointer, offset, conditionProfile1, conditionProfile2, conditionProfile3);
        }

        public static ByteConversionHelperNode create() {
            return LLVMVaListStorageFactory.ByteConversionHelperNodeGen.create();
        }
    }

    public static abstract class NumberConversionHelperNode
    extends LLVMNode {
        public abstract Object execute(Object var1, int var2);

        static boolean isNativePointer(Object x) {
            return LLVMNativePointer.isInstance(x);
        }

        static boolean isManagedPointer(Object x) {
            return LLVMManagedPointer.isInstance(x);
        }
    }

    public static abstract class AbstractOverflowArgArea
    extends ArgsArea
    implements Cloneable {
        protected final long[] offsets;
        public final long overflowAreaSize;
        protected long previousOffset = -1L;
        protected long currentOffset;

        protected AbstractOverflowArgArea(Object[] args, long[] offsets, long overflowAreaSize) {
            super(args);
            this.overflowAreaSize = overflowAreaSize;
            this.offsets = offsets;
            this.currentOffset = offsets[0];
        }

        @Override
        protected long offsetToIndex(long offset) {
            int i;
            if (offset < 0L) {
                return -1L;
            }
            for (i = 0; i < this.offsets.length; ++i) {
                if (this.offsets[i] < 0L) {
                    if (offset < this.overflowAreaSize) {
                        long j = offset - this.offsets[i - 1];
                        return (long)(i - 1) + (j << 32);
                    }
                    return -1L;
                }
                if (offset == this.offsets[i]) {
                    return i;
                }
                if (offset >= this.offsets[i]) continue;
                assert (i > 0);
                long j = offset - this.offsets[i - 1];
                return (long)(i - 1) + (j << 32);
            }
            i = this.offsets.length - 1;
            long j = offset - this.offsets[i];
            return (long)i + (j << 32);
        }

        public void shift(int steps) {
            this.previousOffset = this.currentOffset;
            long n = this.offsetToIndex(this.currentOffset);
            int i = (int)(n << 32 >> 32);
            this.currentOffset = this.offsets[i + steps];
        }

        public void setOffset(long newOffset) {
            this.previousOffset = this.currentOffset;
            this.currentOffset = newOffset;
        }

        public Object getCurrentArg() {
            int i = this.getCurrentArgIndex();
            return i < 0 ? null : this.args[i];
        }

        public Object getPreviousArg() {
            int i = this.getPreviousArgIndex();
            return i < 0 ? null : this.args[i];
        }

        public int getCurrentArgIndex() {
            long n = this.offsetToIndex(this.currentOffset);
            int i = (int)(n << 32 >> 32);
            return i;
        }

        public int getPreviousArgIndex() {
            if (this.previousOffset < 0L) {
                return -1;
            }
            long n = this.offsetToIndex(this.previousOffset);
            int i = (int)(n << 32 >> 32);
            return i;
        }

        public LLVMManagedPointer getCurrentArgPtr() {
            return LLVMManagedPointer.create(this, this.currentOffset);
        }

        public long getOffset() {
            return this.currentOffset;
        }
    }

    @ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=false)
    public static abstract class ArgsArea
    implements TruffleObject {
        public final Object[] args;
        private static final LLVMInteropType.Array I8_ARG_TYPE = LLVMInteropType.ValueKind.I8.type.toArray(8L);
        private static final LLVMInteropType.Array I16_ARG_TYPE = LLVMInteropType.ValueKind.I16.type.toArray(4L);
        private static final LLVMInteropType.Array I32_ARG_TYPE = LLVMInteropType.ValueKind.I32.type.toArray(2L);
        private static final LLVMInteropType.Array I64_ARG_TYPE = LLVMInteropType.ValueKind.I64.type.toArray(1L);
        private static final LLVMInteropType.Array F80_ARG_TYPE = LLVMInteropType.ValueKind.I64.type.toArray(2L);

        protected ArgsArea(Object[] args) {
            this.args = args;
        }

        protected abstract long offsetToIndex(long var1);

        @ExportMessage
        public boolean isReadable() {
            return true;
        }

        @ExportMessage
        public byte readI8(long offset, @Cached ByteConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Byte)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        public short readI16(long offset, @Cached ShortConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Short)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        public int readI32(long offset, @Cached IntegerConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            if (i < 0) {
                return 0;
            }
            return (Integer)convNode.execute(this.args[i], j);
        }

        @ExportMessage
        public LLVMPointer readPointer(long offset, @Cached PointerConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            return i < 0 ? LLVMNativePointer.createNull() : LLVMPointer.cast(convNode.execute(this.args[i], j));
        }

        @ExportMessage
        public Object readGenericI64(long offset, @Cached LongConversionHelperNode convNode) {
            long n = this.offsetToIndex(offset);
            int i = (int)(n << 32 >> 32);
            int j = (int)(n >> 32);
            return i < 0 ? Long.valueOf(Double.doubleToLongBits(0.0)) : convNode.execute(this.args[i], j);
        }

        protected static LLVMInteropType getVarArgType(Object arg) {
            if (arg == null) {
                return LLVMInteropType.ValueKind.I8.type.toArray(0L);
            }
            if (arg instanceof Boolean) {
                return I8_ARG_TYPE;
            }
            if (arg instanceof Byte) {
                return I8_ARG_TYPE;
            }
            if (arg instanceof Short) {
                return I16_ARG_TYPE;
            }
            if (arg instanceof Integer) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof Long) {
                return I64_ARG_TYPE;
            }
            if (arg instanceof Float) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof Double) {
                return I64_ARG_TYPE;
            }
            if (LLVMPointer.isInstance(arg)) {
                return I64_ARG_TYPE;
            }
            if (arg instanceof LLVMFloatVector && ((LLVMFloatVector)arg).getLength() <= 2) {
                return I32_ARG_TYPE;
            }
            if (arg instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue compVal = (LLVMVarArgCompoundValue)arg;
                return LLVMInteropType.ValueKind.I64.type.toArray(compVal.getSize() / 8L);
            }
            if (arg instanceof LLVM80BitFloat) {
                return F80_ARG_TYPE;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
        }
    }

    public static final class StackAllocationNode
    extends LLVMNode
    implements GenerateAOT.Provider {
        private static final StackAllocationNode UNCACHED = new StackAllocationNode();
        @Node.Child
        VarargsAreaStackAllocationNode allocNode;

        private StackAllocationNode() {
        }

        public static StackAllocationNode create() {
            return new StackAllocationNode();
        }

        public static StackAllocationNode getUncached() {
            return UNCACHED;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            this.allocNode = this.createVarargsAreaStackAllocationNode();
            this.insert((Node)this.allocNode);
        }

        public LLVMPointer executeWithTarget(long size, Frame frame) {
            if (this.allocNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocNode = this.createVarargsAreaStackAllocationNode();
                this.insert((Node)this.allocNode);
            }
            assert (frame instanceof VirtualFrame);
            return this.allocNode.executeWithTarget((VirtualFrame)frame, size);
        }

        VarargsAreaStackAllocationNode createVarargsAreaStackAllocationNode() {
            DataLayout dataLayout = this.getDataLayout();
            LLVMLanguage lang = LLVMLanguage.get(null);
            return lang.getActiveConfiguration().createNodeFactory(lang, dataLayout).createVarargsAreaStackAllocation();
        }
    }

    @GenerateUncached
    public static abstract class VAListPointerWrapperFactoryDelegate
    extends LLVMNode {
        public abstract Object execute(Object var1);

        @Specialization
        Object createWrapper(LLVMPointer pointer, @Cached(value="createVAListPointerWrapperFactory(true)", uncached="createVAListPointerWrapperFactory(false)") VAListPointerWrapperFactory wrapperFactory) {
            return wrapperFactory.execute(pointer);
        }

        @Fallback
        Object createWrapper(Object o) {
            return o;
        }

        public static VAListPointerWrapperFactory createVAListPointerWrapperFactory(boolean cached) {
            return LLVMLanguage.get(null).getCapability(PlatformCapability.class).createNativeVAListWrapper(cached);
        }
    }

    @GenerateUncached
    public static abstract class VAListPointerWrapperFactory
    extends LLVMNode {
        public abstract Object execute(LLVMPointer var1);
    }

    @ExportMessage
    public static class InvokeMember {
        @Specialization(guards={"GET_MEMBER.equals(member)"})
        public static Object get(LLVMVaListStorage receiver, String member, Object[] arguments, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) throws ArityException, UnsupportedTypeException {
            if (arguments.length != 2) {
                throw ArityException.create((int)2, (int)2, (int)arguments.length);
            }
            if (!(arguments[0] instanceof Integer)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedTypeException.create((Object[])new Object[]{arguments[0]}, (String)"Index argument must be an integer");
            }
            int i = (Integer)arguments[0];
            if (i >= receiver.realArguments.length - receiver.numberOfExplicitArguments) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new ArrayIndexOutOfBoundsException(i);
            }
            Object arg = receiver.realArguments[receiver.numberOfExplicitArguments + i];
            if (!(arguments[1] instanceof LLVMInteropType.Structured)) {
                return arg;
            }
            LLVMInteropType.Structured type = (LLVMInteropType.Structured)arguments[1];
            if (!LLVMPointer.isInstance(arg)) {
                return arg;
            }
            LLVMPointer ptrArg = LLVMPointer.cast(arg);
            return pointerEscapeNode.executeWithType(ptrArg, type);
        }

        @Specialization(guards={"NEXT_MEMBER.equals(member)"})
        public static Object next(LLVMVaListStorage receiver, String member, Object[] arguments, @CachedLibrary(value="receiver") LLVMVaListLibrary vaListLib, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) throws ArityException, UnsupportedTypeException {
            if (arguments.length != 1) {
                throw ArityException.create((int)1, (int)1, (int)arguments.length);
            }
            if (!(arguments[0] instanceof LLVMInteropType)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedTypeException.create((Object[])arguments, (String)"LLVMInteropType");
            }
            return InvokeMember.next(receiver, (LLVMInteropType)arguments[0], vaListLib, pointerEscapeNode);
        }

        public static Object next(Object receiver, LLVMInteropType type, LLVMVaListLibrary vaListLib, LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) {
            Object result = vaListLib.shift(receiver, InvokeMember.getInternalType(type), null);
            if (!(type instanceof LLVMInteropType.Structured)) {
                return result;
            }
            if (!LLVMPointer.isInstance(result)) {
                return result;
            }
            LLVMPointer ptrArg = LLVMPointer.cast(result);
            return pointerEscapeNode.executeWithType(ptrArg, (LLVMInteropType.Structured)type);
        }

        private static Type getInternalType(LLVMInteropType type) {
            if (type instanceof LLVMInteropType.Value) {
                switch (((LLVMInteropType.Value)type).kind) {
                    case DOUBLE: {
                        return PrimitiveType.DOUBLE;
                    }
                    case FLOAT: {
                        return PrimitiveType.FLOAT;
                    }
                    case I1: {
                        return PrimitiveType.I1;
                    }
                    case I16: {
                        return PrimitiveType.I16;
                    }
                    case I32: {
                        return PrimitiveType.I32;
                    }
                    case I64: {
                        return PrimitiveType.I64;
                    }
                    case I8: {
                        return PrimitiveType.I8;
                    }
                    case POINTER: {
                        return new PointerType(PrimitiveType.I64);
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
            }
            if (type instanceof LLVMInteropType.Structured) {
                return new PointerType(PrimitiveType.I64);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
        }

        @Fallback
        public static Object other(LLVMVaListStorage receiver, String member, Object[] arguments) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create((String)member);
        }
    }

    @ExportMessage
    public static class IsMemberInvocable {
        @Specialization(guards={"GET_MEMBER.equals(member)"})
        public static boolean get(LLVMVaListStorage receiver, String member) {
            return true;
        }

        @Specialization(guards={"NEXT_MEMBER.equals(member)"})
        public static boolean next(LLVMVaListStorage receiver, String member) {
            return true;
        }

        @Fallback
        public static boolean other(LLVMVaListStorage receiver, String member) {
            return false;
        }
    }
}

