/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMArithmetic {
    public static final CarryArithmetic CARRY_ADD = new CarryArithmetic(){

        @Override
        public byte evalI8(byte left, byte right, byte cin, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = (left & 0xFF) + (right & 0xFF) + (cin & 0xFF);
            boolean overflow = (res & 0xF00) != 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right, short cin, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = (left & 0xFFFF) + (right & 0xFFFF) + (cin & 0xFFFF);
            boolean overflow = (res & 0xF0000) != 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right, int cin, LLVMPointer addr, LLVMI32StoreNode store) {
            int res1 = left + right;
            boolean overflow1 = (~res1 & left | ~res1 & right | left & right) < 0;
            int res2 = res1 + cin;
            boolean overflow2 = (~res2 & res1 | ~res2 & cin | res1 & cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }

        @Override
        public long evalI64(long left, long right, long cin, LLVMPointer addr, LLVMI64StoreNode store) {
            long res1 = left + right;
            boolean overflow1 = ((res1 ^ 0xFFFFFFFFFFFFFFFFL) & left | (res1 ^ 0xFFFFFFFFFFFFFFFFL) & right | left & right) < 0L;
            long res2 = res1 + cin;
            boolean overflow2 = ((res2 ^ 0xFFFFFFFFFFFFFFFFL) & res1 | (res2 ^ 0xFFFFFFFFFFFFFFFFL) & cin | res1 & cin) < 0L;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1L : 0L);
            return res2;
        }
    };
    public static final CarryArithmetic CARRY_SUB = new CarryArithmetic(){

        @Override
        public byte evalI8(byte left, byte right, byte cin, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = (left & 0xFF) - (right & 0xFF) - (cin & 0xFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right, short cin, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = (left & 0xFFFF) - (right & 0xFFFF) - (cin & 0xFFFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, overflow ? (byte)1 : 0);
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right, int cin, LLVMPointer addr, LLVMI32StoreNode store) {
            int res1 = left - right;
            boolean overflow1 = Integer.compareUnsigned(left, right) < 0;
            int res2 = res1 - cin;
            boolean overflow2 = Integer.compareUnsigned(res1, cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1 : 0);
            return res2;
        }

        @Override
        public long evalI64(long left, long right, long cin, LLVMPointer addr, LLVMI64StoreNode store) {
            long res1 = left - right;
            boolean overflow1 = Long.compareUnsigned(left, right) < 0;
            long res2 = res1 - cin;
            boolean overflow2 = Long.compareUnsigned(res1, cin) < 0;
            store.executeWithTarget(addr, overflow1 | overflow2 ? 1L : 0L);
            return res2;
        }
    };
    public static final Arithmetic SIGNED_ADD = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = left + right;
            boolean overflow = ((res ^ left) & (res ^ right) & 0x80) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = left + right;
            boolean overflow = ((res ^ left) & (res ^ right) & 0x8000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final SaturatingArithmetic SIGNED_ADD_SAT = new SaturatingArithmetic(){

        @Override
        public byte evalI8(byte left, byte right) {
            boolean overflow;
            int res = left + right;
            boolean bl = overflow = ((res ^ left) & (res ^ right) & 0x80) != 0;
            if (overflow) {
                return left > 0 ? (byte)127 : -128;
            }
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right) {
            boolean overflow;
            int res = left + right;
            boolean bl = overflow = ((res ^ left) & (res ^ right) & 0x8000) != 0;
            if (overflow) {
                return left > 0 ? (short)Short.MAX_VALUE : Short.MIN_VALUE;
            }
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right) {
            int res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            if (overflow) {
                return left > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            return res;
        }

        @Override
        public long evalI64(long left, long right) {
            long res;
            boolean overflow = false;
            try {
                res = Math.addExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left + right;
                overflow = true;
            }
            if (overflow) {
                return left > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return res;
        }
    };
    public static final Arithmetic UNSIGNED_ADD = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = (left & 0xFF) + (right & 0xFF);
            boolean overflow = (res & 0x100) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = (left & 0xFFFF) + (right & 0xFFFF);
            boolean overflow = (res & 0x10000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            int res = left + right;
            boolean overflow = (~res & left | ~res & right | left & right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res = left + right;
            boolean overflow = ((res ^ 0xFFFFFFFFFFFFFFFFL) & left | (res ^ 0xFFFFFFFFFFFFFFFFL) & right | left & right) < 0L;
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final SaturatingArithmetic UNSIGNED_ADD_SAT = new SaturatingArithmetic(){

        @Override
        public byte evalI8(byte left, byte right) {
            int res = (left & 0xFF) + (right & 0xFF);
            boolean overflow = (res & 0x100) != 0;
            return (byte)(overflow ? 255 : res);
        }

        @Override
        public short evalI16(short left, short right) {
            int res = (left & 0xFFFF) + (right & 0xFFFF);
            boolean overflow = (res & 0x10000) != 0;
            return (short)(overflow ? 65535 : res);
        }

        @Override
        public int evalI32(int left, int right) {
            int res = left + right;
            boolean overflow = (~res & left | ~res & right | left & right) < 0;
            return overflow ? -1 : res;
        }

        @Override
        public long evalI64(long left, long right) {
            long res = left + right;
            boolean overflow = ((res ^ 0xFFFFFFFFFFFFFFFFL) & left | (res ^ 0xFFFFFFFFFFFFFFFFL) & right | left & right) < 0L;
            return overflow ? -1L : res;
        }
    };
    public static final Arithmetic SIGNED_SUB = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = left - right;
            boolean overflow = ((left ^ right) & (left ^ res) & 0x80) != 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = left - right;
            boolean overflow = ((left ^ right) & (left ^ res) & 0x8000) != 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final SaturatingArithmetic SIGNED_SUB_SAT = new SaturatingArithmetic(){

        @Override
        public byte evalI8(byte left, byte right) {
            boolean overflow;
            int res = left - right;
            boolean bl = overflow = ((left ^ right) & (left ^ res) & 0x80) != 0;
            if (overflow) {
                return left > 0 ^ right < 0 ? (byte)127 : -128;
            }
            return (byte)res;
        }

        @Override
        public short evalI16(short left, short right) {
            boolean overflow;
            int res = left - right;
            boolean bl = overflow = ((left ^ right) & (left ^ res) & 0x8000) != 0;
            if (overflow) {
                return left > 0 ^ right < 0 ? (short)Short.MAX_VALUE : Short.MIN_VALUE;
            }
            return (short)res;
        }

        @Override
        public int evalI32(int left, int right) {
            int res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            if (overflow) {
                return left > 0 ^ right < 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            return res;
        }

        @Override
        public long evalI64(long left, long right) {
            long res;
            boolean overflow = false;
            try {
                res = Math.subtractExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left - right;
                overflow = true;
            }
            if (overflow) {
                return left > 0L ^ right < 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return res;
        }
    };
    public static final Arithmetic UNSIGNED_SUB = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = (left & 0xFF) - (right & 0xFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = (left & 0xFFFF) - (right & 0xFFFF);
            boolean overflow = res < 0;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            int res = left - right;
            boolean overflow = Integer.compareUnsigned(left, right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res = left - right;
            boolean overflow = Long.compareUnsigned(left, right) < 0;
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final SaturatingArithmetic UNSIGNED_SUB_SAT = new SaturatingArithmetic(){

        @Override
        public byte evalI8(byte left, byte right) {
            int res = (left & 0xFF) - (right & 0xFF);
            boolean overflow = res < 0;
            return (byte)(overflow ? 0 : res);
        }

        @Override
        public short evalI16(short left, short right) {
            int res = (left & 0xFFFF) - (right & 0xFFFF);
            boolean overflow = res < 0;
            return (short)(overflow ? 0 : res);
        }

        @Override
        public int evalI32(int left, int right) {
            int res = left - right;
            boolean overflow = Integer.compareUnsigned(left, right) < 0;
            return overflow ? 0 : res;
        }

        @Override
        public long evalI64(long left, long right) {
            long res = left - right;
            boolean overflow = Long.compareUnsigned(left, right) < 0;
            return overflow ? 0L : res;
        }
    };
    public static final Arithmetic SIGNED_MUL = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = left * right;
            boolean overflow = (byte)res != res;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = left * right;
            boolean overflow = (short)res != res;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            int res;
            boolean overflow = false;
            try {
                res = Math.multiplyExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left * right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res;
            boolean overflow = false;
            try {
                res = Math.multiplyExact(left, right);
            }
            catch (ArithmeticException e) {
                res = left * right;
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };
    public static final Arithmetic UNSIGNED_MUL = new Arithmetic(){

        @Override
        public boolean evalI8(byte left, byte right, LLVMPointer addr, LLVMI8StoreNode store) {
            int res = (left & 0xFF) * (right & 0xFF);
            boolean overflow = (res & 0xFF) != res;
            store.executeWithTarget(addr, (byte)res);
            return overflow;
        }

        @Override
        public boolean evalI16(short left, short right, LLVMPointer addr, LLVMI16StoreNode store) {
            int res = (left & 0xFFFF) * (right & 0xFFFF);
            boolean overflow = (res & 0xFFFF) != res;
            store.executeWithTarget(addr, (short)res);
            return overflow;
        }

        @Override
        public boolean evalI32(int left, int right, LLVMPointer addr, LLVMI32StoreNode store) {
            long res = ((long)left & 0xFFFFFFFFL) * ((long)right & 0xFFFFFFFFL);
            boolean overflow = (res & 0xFFFFFFFFL) != res;
            store.executeWithTarget(addr, (int)res);
            return overflow;
        }

        @Override
        public boolean evalI64(long left, long right, LLVMPointer addr, LLVMI64StoreNode store) {
            long res = left * right;
            boolean overflow = false;
            if ((left | right) >>> 31 != 0L && right != 0L && Long.divideUnsigned(res, right) != left) {
                overflow = true;
            }
            store.executeWithTarget(addr, res);
            return overflow;
        }
    };

    private LLVMArithmetic() {
    }

    public static interface CarryArithmetic {
        public byte evalI8(byte var1, byte var2, byte var3, LLVMPointer var4, LLVMI8StoreNode var5);

        public short evalI16(short var1, short var2, short var3, LLVMPointer var4, LLVMI16StoreNode var5);

        public int evalI32(int var1, int var2, int var3, LLVMPointer var4, LLVMI32StoreNode var5);

        public long evalI64(long var1, long var3, long var5, LLVMPointer var7, LLVMI64StoreNode var8);
    }

    public static interface Arithmetic {
        public boolean evalI8(byte var1, byte var2, LLVMPointer var3, LLVMI8StoreNode var4);

        public boolean evalI16(short var1, short var2, LLVMPointer var3, LLVMI16StoreNode var4);

        public boolean evalI32(int var1, int var2, LLVMPointer var3, LLVMI32StoreNode var4);

        public boolean evalI64(long var1, long var3, LLVMPointer var5, LLVMI64StoreNode var6);
    }

    public static interface SaturatingArithmetic {
        public byte evalI8(byte var1, byte var2);

        public short evalI16(short var1, short var2);

        public int evalI32(int var1, int var2);

        public long evalI64(long var1, long var3);
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="cin", type=LLVMExpressionNode.class), @NodeChild(value="cout", type=LLVMExpressionNode.class)})
    public static abstract class LLVMArithmeticWithOverflowAndCarry
    extends LLVMBuiltin {
        private final CarryArithmetic arithmetic;

        public LLVMArithmeticWithOverflowAndCarry(CarryArithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected byte doIntrinsic(byte left, byte right, byte cin, LLVMPointer addr, @Cached LLVMI8StoreNode store) {
            return this.arithmetic.evalI8(left, right, cin, addr, store);
        }

        @Specialization
        protected short doIntrinsic(short left, short right, short cin, LLVMPointer addr, @Cached LLVMI16StoreNode store) {
            return this.arithmetic.evalI16(left, right, cin, addr, store);
        }

        @Specialization
        protected int doIntrinsic(int left, int right, int cin, LLVMPointer addr, @Cached LLVMI32StoreNode store) {
            return this.arithmetic.evalI32(left, right, cin, addr, store);
        }

        @Specialization
        protected long doIntrinsic(long left, long right, long cin, LLVMPointer addr, @Cached LLVMI64StoreNode store) {
            return this.arithmetic.evalI64(left, right, cin, addr, store);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="target", type=LLVMExpressionNode.class)})
    public static abstract class LLVMArithmeticWithOverflow
    extends LLVMBuiltin {
        private final long secondValueOffset;
        private final Arithmetic arithmetic;
        @Node.Child
        private LLVMI1StoreNode.LLVMI1OffsetStoreNode storeI1 = LLVMI1StoreNode.LLVMI1OffsetStoreNode.create();

        public LLVMArithmeticWithOverflow(Arithmetic arithmetic, long secondValueOffset) {
            this.secondValueOffset = secondValueOffset;
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected Object doIntrinsic(byte left, byte right, LLVMPointer addr, @Cached LLVMI8StoreNode store) {
            boolean overflow = this.arithmetic.evalI8(left, right, addr, store);
            this.storeI1.executeWithTarget(addr, this.secondValueOffset, overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(short left, short right, LLVMPointer addr, @Cached LLVMI16StoreNode store) {
            boolean overflow = this.arithmetic.evalI16(left, right, addr, store);
            this.storeI1.executeWithTarget(addr, this.secondValueOffset, overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(int left, int right, LLVMPointer addr, @Cached LLVMI32StoreNode store) {
            boolean overflow = this.arithmetic.evalI32(left, right, addr, store);
            this.storeI1.executeWithTarget(addr, this.secondValueOffset, overflow);
            return addr;
        }

        @Specialization
        protected Object doIntrinsic(long left, long right, LLVMPointer addr, @Cached LLVMI64StoreNode store) {
            boolean overflow = this.arithmetic.evalI64(left, right, addr, store);
            this.storeI1.executeWithTarget(addr, this.secondValueOffset, overflow);
            return addr;
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMSimpleArithmeticPrimitive
    extends LLVMBuiltin {
        private final SaturatingArithmetic arithmetic;

        public LLVMSimpleArithmeticPrimitive(SaturatingArithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected byte doIntrinsic(byte left, byte right) {
            return this.arithmetic.evalI8(left, right);
        }

        @Specialization
        protected short doIntrinsic(short left, short right) {
            return this.arithmetic.evalI16(left, right);
        }

        @Specialization
        protected int doIntrinsic(int left, int right) {
            return this.arithmetic.evalI32(left, right);
        }

        @Specialization
        protected long doIntrinsic(long left, long right) {
            return this.arithmetic.evalI64(left, right);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class), @NodeChild(value="target", type=LLVMExpressionNode.class)})
    public static abstract class GCCArithmetic
    extends LLVMBuiltin {
        private final Arithmetic arithmetic;

        public GCCArithmetic(Arithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Specialization
        protected byte doIntrinsic(byte left, byte right, LLVMPointer addr, @Cached LLVMI8StoreNode store) {
            return this.arithmetic.evalI8(left, right, addr, store) ? (byte)1 : 0;
        }

        @Specialization
        protected short doIntrinsic(short left, short right, LLVMPointer addr, @Cached LLVMI16StoreNode store) {
            return this.arithmetic.evalI16(left, right, addr, store) ? (byte)1 : 0;
        }

        @Specialization
        protected int doIntrinsic(int left, int right, LLVMPointer addr, @Cached LLVMI32StoreNode store) {
            return this.arithmetic.evalI32(left, right, addr, store) ? 1 : 0;
        }

        @Specialization
        protected long doIntrinsic(long left, long right, LLVMPointer addr, @Cached LLVMI64StoreNode store) {
            return this.arithmetic.evalI64(left, right, addr, store) ? 1L : 0L;
        }
    }
}

