/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMArrayTypeIDNodeGen;

@NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
public abstract class LLVMArrayTypeIDNode
extends LLVMExpressionNode {
    public static LLVMArrayTypeIDNode create(LLVMExpressionNode base, LLVMExpressionNode len) {
        return LLVMArrayTypeIDNodeGen.create(base, len);
    }

    @Specialization(guards={"len >= 0"})
    LLVMInteropType.Array doArray(LLVMInteropType base, long len) {
        return base.toArray(len);
    }

    @Fallback
    Object doError(Object base, Object len) {
        if (len instanceof Long && (Long)len < 0L) {
            throw new LLVMPolyglotException((Node)this, "Negative array length %s in polyglot_array_typeid.", len);
        }
        throw new LLVMPolyglotException(this, "Invalid typeid in polyglot_array_typeid.");
    }
}

