/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.values.LLVMInstantValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotInstantFromTimeNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.time.DateTimeException;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotInstantFromTimeNode
extends LLVMExpressionNode {
    public abstract LLVMInstantValue execute(VirtualFrame var1);

    @CompilerDirectives.TruffleBoundary
    private Object instantOfEpochSecond(long epochSecond) {
        try {
            return LLVMInstantValue.ofEpochSecond(epochSecond);
        }
        catch (DateTimeException ex) {
            throw new LLVMPolyglotException((Node)this, "Failed to construct instant value: %s", ex.toString());
        }
    }

    @Specialization
    public Object doLong(long epochSecond) {
        return LLVMManagedPointer.create(this.instantOfEpochSecond(epochSecond));
    }

    public static LLVMPolyglotInstantFromTimeNode create(LLVMExpressionNode epochSecondNode) {
        return LLVMPolyglotInstantFromTimeNodeGen.create(epochSecondNode);
    }
}

