/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;
import java.util.Arrays;

@NodeChildren(value={@NodeChild(value="charset", type=LLVMReadCharsetNode.class), @NodeChild(value="rawString", type=ReadBytesNode.class, executeWith={"charset"})})
public abstract class LLVMPolyglotFromString
extends LLVMIntrinsic {
    public static LLVMPolyglotFromString create(LLVMExpressionNode string, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadZeroTerminatedBytesNode rawString = LLVMPolyglotFromStringNodeGen.ReadZeroTerminatedBytesNodeGen.create(null, string);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    public static LLVMPolyglotFromString createN(LLVMExpressionNode string, LLVMExpressionNode n, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadBytesWithLengthNode rawString = LLVMPolyglotFromStringNodeGen.ReadBytesWithLengthNodeGen.create(null, string, n);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    @Specialization
    LLVMManagedPointer doFromString(LLVMReadCharsetNode.LLVMCharset charset, byte[] rawString) {
        return LLVMManagedPointer.create(charset.decode(rawString));
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    static abstract class ReadZeroTerminatedBytesNode
    extends ReadBytesNode {
        @CompilerDirectives.CompilationFinal
        private int bufferSize = 8;
        @CompilerDirectives.CompilationFinal
        private BranchProfile trimProfile = BranchProfile.create();

        ReadZeroTerminatedBytesNode() {
        }

        private static ByteArraySupport nativeOrder() {
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                return ByteArraySupport.bigEndian();
            }
            return ByteArraySupport.littleEndian();
        }

        private static byte[] ensureCapacity(byte[] result, int size, int elementSize) {
            if (result.length - size < elementSize) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return Arrays.copyOf(result, result.length * 2);
            }
            return result;
        }

        private byte[] trimResult(byte[] blockedResult, int size) {
            byte[] result = blockedResult;
            if (result.length > size) {
                this.trimProfile.enter();
                result = Arrays.copyOf(result, size);
            }
            if (result.length > this.bufferSize) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferSize = result.length;
                this.trimProfile = BranchProfile.create();
            }
            return result;
        }

        @Specialization(guards={"charset.zeroTerminatorLen == 1"})
        byte[] doReadI8(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode load) {
            byte value;
            ByteArraySupport byteArraySupport = ReadZeroTerminatedBytesNode.nativeOrder();
            byte[] result = new byte[this.bufferSize];
            int size = 0;
            while ((value = load.executeWithTarget(string, size)) != 0) {
                result = ReadZeroTerminatedBytesNode.ensureCapacity(result, size, 1);
                byteArraySupport.putByte(result, size, value);
                ++size;
            }
            return this.trimResult(result, size);
        }

        @Specialization(guards={"charset.zeroTerminatorLen == 2"})
        byte[] doReadI16(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode load) {
            short value;
            ByteArraySupport byteArraySupport = ReadZeroTerminatedBytesNode.nativeOrder();
            byte[] result = new byte[this.bufferSize];
            int size = 0;
            while ((value = load.executeWithTarget(string, size)) != 0) {
                result = ReadZeroTerminatedBytesNode.ensureCapacity(result, size, 2);
                byteArraySupport.putShort(result, size, value);
                size += 2;
            }
            return this.trimResult(result, size);
        }

        @Specialization(guards={"charset.zeroTerminatorLen == 4"})
        byte[] doReadI32(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode load) {
            int value;
            ByteArraySupport byteArraySupport = ReadZeroTerminatedBytesNode.nativeOrder();
            byte[] result = new byte[this.bufferSize];
            int size = 0;
            while ((value = load.executeWithTarget(string, size)) != 0) {
                result = ReadZeroTerminatedBytesNode.ensureCapacity(result, size, 4);
                byteArraySupport.putInt(result, size, value);
                size += 4;
            }
            return this.trimResult(result, size);
        }

        @Specialization(guards={"charset.zeroTerminatorLen == 8"})
        byte[] doReadI64(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode load, @Cached LLVMToNativeNode toNative) {
            long value;
            ByteArraySupport byteArraySupport = ReadZeroTerminatedBytesNode.nativeOrder();
            byte[] result = new byte[this.bufferSize];
            int size = 0;
            while ((value = toNative.executeWithTarget(load.executeWithTargetGeneric(string, size)).asNative()) != 0L) {
                result = ReadZeroTerminatedBytesNode.ensureCapacity(result, size, 8);
                byteArraySupport.putLong(result, size, value);
                size += 8;
            }
            return this.trimResult(result, size);
        }
    }

    static abstract class ReadBytesNode
    extends LLVMNode {
        ReadBytesNode() {
        }

        protected abstract byte[] execute(VirtualFrame var1, LLVMReadCharsetNode.LLVMCharset var2);
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(value="string", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
    static abstract class ReadBytesWithLengthNode
    extends ReadBytesNode {
        @Node.Child
        private LLVMI8LoadNode.LLVMI8OffsetLoadNode load = LLVMI8LoadNode.LLVMI8OffsetLoadNode.create();

        ReadBytesWithLengthNode() {
        }

        @Specialization
        byte[] doRead(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, long len) {
            byte[] buffer = new byte[(int)len];
            int i = 0;
            while ((long)i < len) {
                buffer[i] = this.load.executeWithTarget(string, i * 1);
                ++i;
            }
            return buffer;
        }
    }
}

