/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotBufferInfoFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="buffer")
public abstract class LLVMPolyglotBufferInfo
extends LLVMExpressionNode {
    protected LLVMPolyglotException notABuffer() {
        return new LLVMPolyglotException(this, "The argument is not a buffer.");
    }

    public static abstract class GetBufferSize
    extends LLVMPolyglotBufferInfo {
        @Specialization
        @GenerateAOT.Exclude
        public long getNativeBufferSize(LLVMNativePointer pointer, @Cached BranchProfile exception, @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                return interop.getBufferSize((Object)pointer);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public long nonForeignBufferSize(LLVMManagedPointer pointer, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                return interop.getBufferSize((Object)pointer);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        @Specialization(guards={"foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public long getManagedBufferSize(LLVMManagedPointer pointer, @Cached LLVMAsForeignNode foreign, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object object = foreign.execute(pointer);
            try {
                return interop.getBufferSize(object);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        public static GetBufferSize create(LLVMExpressionNode arg) {
            return LLVMPolyglotBufferInfoFactory.GetBufferSizeNodeGen.create(arg);
        }
    }

    public static abstract class IsBufferWritable
    extends LLVMPolyglotBufferInfo {
        @Specialization
        @GenerateAOT.Exclude
        public boolean isNativeBufferWritable(LLVMNativePointer pointer, @Cached BranchProfile exception, @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                return interop.isBufferWritable((Object)pointer);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public boolean nonForeignBufferWritable(LLVMManagedPointer pointer, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            try {
                return interop.isBufferWritable((Object)pointer);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        @Specialization(guards={"foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public boolean isManagedBufferWritable(LLVMManagedPointer pointer, @Cached LLVMAsForeignNode foreign, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object object = foreign.execute(pointer);
            try {
                return interop.isBufferWritable(object);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw this.notABuffer();
            }
        }

        public static IsBufferWritable create(LLVMExpressionNode arg) {
            return LLVMPolyglotBufferInfoFactory.IsBufferWritableNodeGen.create(arg);
        }
    }

    public static abstract class HasBufferElements
    extends LLVMPolyglotBufferInfo {
        @Specialization
        @GenerateAOT.Exclude
        public boolean doNative(LLVMNativePointer pointer, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.hasBufferElements((Object)pointer);
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public boolean nonForeignHasElements(LLVMManagedPointer pointer, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            return interop.hasBufferElements((Object)pointer);
        }

        @Specialization(guards={"foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public boolean doManaged(LLVMManagedPointer pointer, @Cached LLVMAsForeignNode foreign, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object object = foreign.execute(pointer);
            return interop.hasBufferElements(object);
        }

        @Fallback
        public boolean unsupported(Object buffer) {
            return false;
        }

        public static HasBufferElements create(LLVMExpressionNode arg) {
            return LLVMPolyglotBufferInfoFactory.HasBufferElementsNodeGen.create(arg);
        }
    }
}

